/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.ui.WLenSelectorPopup;
import cerent.cms.ui.Wavelength;
import cerent.util.gui.AbstractCellEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class WLenCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    WLenSelectorPopup wlsp;
    WLenSelectorPopup.DefaultWLDialogValue dv;
    WLenEditorPanel editorPanel;
    private boolean autoStart;

    public WLenCellEditor(WLenSelectorPopup.DefaultWLDialogValue defaultWLDialogValue) {
        this.dv = defaultWLDialogValue;
        this.editorPanel = new WLenEditorPanel();
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorPanel.getValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.dv.setValue((Attribute)object);
        this.editorPanel.init(object, jTable);
        if (this.autoStart) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WLenCellEditor.this.editorPanel.popupDlg();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WLenCellEditor.this.editorPanel.ready();
                }
            });
        }
        return this.editorPanel;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            int n = ((MouseEvent)eventObject).getClickCount();
            if (n == 1) {
                this.autoStart = false;
                return true;
            }
            if (n == 2) {
                this.autoStart = true;
                return true;
            }
        }
        return true;
    }

    class WLenEditorPanel
    extends JPanel {
        JButton browse;
        JLabel lb;
        Object newValue;
        JFrame frame;

        WLenEditorPanel() {
            super(new BorderLayout());
            this.lb = new JLabel();
            this.frame = null;
            this.lb.setBorder(null);
            this.setBackground(Color.WHITE);
            this.add((Component)this.lb, "West");
            this.browse = new JButton("...");
            this.browse.setMargin(new Insets(0, 0, 0, 0));
            Font font = this.browse.getFont();
            this.browse.setFont(font.deriveFont(font.getSize() - 1));
            this.add((Component)this.browse, "East");
            this.frame = (JFrame)SwingUtilities.getWindowAncestor(this);
            this.browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WLenCellEditor.this.wlsp = new WLenSelectorPopup((Frame)WLenEditorPanel.this.frame, WLenCellEditor.this.dv);
                    WLenCellEditor.this.wlsp.start();
                    WLenCellEditor.this.wlsp.pack();
                    WLenCellEditor.this.wlsp.setVisible(true);
                    if (WLenCellEditor.this.dv.getValue() != null) {
                        Attribute attribute = WLenCellEditor.this.dv.getValue();
                        WLenEditorPanel.this.newValue = attribute;
                        WLenCellEditor.this.stopCellEditing();
                        WLenCellEditor.this.fireEditingStopped();
                    } else {
                        WLenEditorPanel.this.newValue = null;
                        WLenCellEditor.this.fireEditingCanceled();
                    }
                }
            });
        }

        public void init(Object object, JTable jTable) {
            Attribute attribute = (Attribute)object;
            this.lb.setText(object == null ? "" : Wavelength.getWideWL(attribute));
            this.lb.setFont(jTable.getFont());
            this.lb.setBackground(Color.WHITE);
            this.browse.setEnabled(false);
        }

        void ready() {
            this.browse.setEnabled(true);
        }

        Object getValue() {
            return this.newValue;
        }

        void popupDlg() {
            this.ready();
            this.browse.doClick();
        }
    }
}

