/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.Attribute;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.aic.AbstractAicEnvControlTableModel;
import cerent.cms.ui.aic.EnvCtrlSetting;
import cerent.util.SDebug;

public class AicEnvControlMaintTableModel
extends AbstractAicEnvControlTableModel {
    public static final int LINENUMBER_INDEX = 0;
    public static final int TYPE_INDEX = 1;
    public static final int TRIGGERINFO_INDEX = 2;
    public static final int DESCRIPTION_INDEX = 3;
    public static final int CURR_STATE = 4;
    public static final int AUTO_STATE = 5;
    public static final int MODE_INDEX = 6;
    private static final SDebug dbMaint = new SDebug("EnvCtrlMaint");

    public AicEnvControlMaintTableModel(EnvControlModel[] envControlModelArray, int n) {
        super(envControlModelArray[0].getNodeModel(), envControlModelArray);
        this.commonInit();
    }

    public AicEnvControlMaintTableModel(INodeModel iNodeModel, EnvControlModel[] envControlModelArray) {
        super(iNodeModel, envControlModelArray);
        this.commonInit();
        this.settings = new EnvCtrlSetting[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.settings[i] = new EnvCtrlSetting(envControlModelArray[i]);
        }
    }

    private void commonInit() {
        this.db = dbMaint;
        this.columnNames = new String[]{"Control #", "Control Type", "Trigger Type", "Description", "Current State", "Auto State", "Contact Setting..."};
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.enabled || n2 == 0) {
            return false;
        }
        if (this.models != null && this.numLines > 0 && ((ModuleModel)this.models[0].getAncestorOfType(eClass.E_MODULE)).isProtectModule()) {
            return false;
        }
        return this.settings[n].outputConfig.enabled && n2 == 6;
    }

    @Override
    public Class getColumnClass(int n) {
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.settings[n] == null) {
            return "";
        }
        try {
            switch (n2) {
                case 0: {
                    return Integer.toString(n + 1);
                }
                case 1: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].getType();
                }
                case 2: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].getTrigger();
                }
                case 3: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].outputConfig.description;
                }
                case 6: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].getManOverride();
                }
                case 4: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.getPrintableContactStatus(this.settings[n].currClosed);
                }
                case 5: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.getPrintableContactStatus(this.settings[n].autoClosed);
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object == null || this.settings[n] == null) {
            return;
        }
        switch (n2) {
            case 6: {
                this.settings[n].setManOverride((Attribute)object);
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            this.rowDirty[i] = false;
            this.settings[i].setManOverRide();
            this.settings[i].print(this.db, "To NE [" + i + "]");
        }
    }
}

