/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.idl.Equipment.eEnvCtrlType;
import cerent.cms.model.Attribute;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.aic.AbstractAicEnvControlTableModel;
import cerent.cms.ui.aic.EnvCtrlSetting;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.WID;
import java.awt.Component;

public class AicEnvControlTableModel
extends AbstractAicEnvControlTableModel {
    public static final int LINENUMBER_INDEX = 0;
    public static final int ENABLED_INDEX = 1;
    public static final int TYPE_INDEX = 2;
    public static final int TRIGGERINFO_INDEX = 3;
    public static final int DESCRIPTION_INDEX = 4;
    private static final SDebug dbProv = new SDebug("EnvCtrlProv");

    public AicEnvControlTableModel(EnvControlModel[] envControlModelArray, int n) {
        super(envControlModelArray[0].getNodeModel(), envControlModelArray);
        this.commonInit();
    }

    public AicEnvControlTableModel(INodeModel iNodeModel, EnvControlModel[] envControlModelArray) {
        super(iNodeModel, envControlModelArray);
        this.settings = new EnvCtrlSetting[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.settings[i] = new EnvCtrlSetting(envControlModelArray[i]);
        }
        this.commonInit();
    }

    private void commonInit() {
        this.db = dbProv;
        this.columnNames = new String[]{"Control #", "Enabled", "Control Type", "Trigger Type", "Description"};
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        ModuleModel moduleModel;
        if (!this.enabled || n2 == 0 || this.settings[n] == null) {
            return false;
        }
        if (this.models != null && this.numLines > 0 && (moduleModel = (ModuleModel)this.models[0].getModuleModel()) != null && moduleModel.isProtectModule()) {
            return false;
        }
        return n2 == 1 || this.settings[n].outputConfig.enabled;
    }

    @Override
    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.settings[n] == null) {
            return this.getDefaultValue(n2);
        }
        try {
            switch (n2) {
                case 0: {
                    return Integer.toString(n + 1);
                }
                case 1: {
                    return this.getBoolean(this.settings[n].outputConfig.enabled);
                }
                case 2: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].getType();
                }
                case 3: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].getTrigger();
                }
                case 4: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].outputConfig.description;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return this.getDefaultValue(n2);
    }

    private Object getDefaultValue(int n) {
        if (n == 1) {
            return this.getBoolean(false);
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object == null || this.settings[n] == null) {
            return;
        }
        switch (n2) {
            case 1: {
                this.settings[n].outputConfig.enabled = (Boolean)object;
                this.setValueAt(this.getAttributeFor(eEnvCtrlType.class.getName(), 7), n, 2);
                break;
            }
            case 4: {
                String string = (String)object;
                if (string.length() > 40) {
                    ErrorMsg.displayWarning((Component)this.getFrame(), (WID)EMC.WID_ENV_ALARM_DESC_TOOLONG_PARAM_1, (Object)Integer.toString(40));
                    string = string.substring(0, 40);
                }
                this.settings[n].outputConfig.description = string;
                break;
            }
            case 2: {
                this.settings[n].setType((Attribute)object);
                break;
            }
            case 3: {
                this.settings[n].setTrigger((Attribute)object);
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i]) continue;
            this.rowDirty[i] = false;
            this.settings[i].submit();
            this.settings[i].print(this.db, "To NE [" + i + "]");
        }
    }
}

