/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aici;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.aic.AicEnvControlTableModel;
import cerent.cms.ui.aic.EnvCtrlSetting;
import cerent.cms.ui.aici.AiciCardTabbedView;
import cerent.util.SDebug;
import java.util.List;

public class AiciEnvControlTableModel
extends AicEnvControlTableModel {
    private AiciCardTabbedView tabbedView;
    private static final SDebug db = new SDebug("AiciEnvControlTableModel");
    private TabbedView parent = null;

    public AiciEnvControlTableModel(INodeModel iNodeModel, EnvControlModel[] envControlModelArray) {
        super(iNodeModel, envControlModelArray);
    }

    public AiciEnvControlTableModel(EnvControlModel[] envControlModelArray, TabbedView tabbedView) {
        this(tabbedView.getUiModel().getNodeModel(), envControlModelArray);
        this.parent = tabbedView;
        if (!this.isM6()) {
            this.tabbedView = (AiciCardTabbedView)tabbedView;
        }
    }

    private boolean isM6() {
        boolean bl = false;
        ChassisModel chassisModel = null;
        if (this.parent.getUiModel() instanceof ChassisModel && (chassisModel = (ChassisModel)this.parent.getUiModel()).isM6Chassis()) {
            bl = true;
        }
        return bl;
    }

    private EnvControlModel[] getControlOutput() {
        EntityModel entityModel = null;
        if (this.parent.getUiModel() instanceof ChassisModel) {
            entityModel = (ChassisModel)this.parent.getUiModel();
        }
        List list = entityModel.getDescendantsOfType(eEqType.ENVIRONMENT_CONTROL);
        return list.toArray(new EnvControlModel[0]);
    }

    public synchronized void updateModel() {
        if (db.on()) {
            db.println("updateModel");
        }
        try {
            IModel[] iModelArray = null;
            iModelArray = this.isM6() ? this.getControlOutput() : this.tabbedView.getControlOutput();
            this.setModels(iModelArray);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            db.println("Caught exception in updateModel");
        }
    }

    @Override
    public synchronized void setModels(IModel[] iModelArray) {
        super.setModels(iModelArray);
        this.models = (EnvControlModel[])iModelArray;
        this.settings = new EnvCtrlSetting[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.settings[i] = new EnvCtrlSetting(this.models[i]);
        }
    }
}

