/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aici;

import cerent.cms.model.OrderwireModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.aic.AicProvOrderwirePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class AiciProvOrderwirePane
extends AicProvOrderwirePane
implements ActionListener {
    private static final int NUM_SLIDERS = 4;
    private static final int[] rawValuesL4RX_aici = new int[]{190, 170, 151, 135, 120, 107, 95, 85, 76, 68, 60, 54, 48, 42, 38, 34, 30};
    private static final int[] rawValuesL4TX_aici = new int[]{85, 96, 107, 120, 135, 152, 170, 192};
    private static final int[] rawValuesL2RX_aici = new int[]{117, 111, 104, 99, 92, 88, 83, 78, 74, 70, 66};
    private static final int[] rawValuesL2TX_aici = new int[]{95, 100, 106, 113, 119, 126, 134, 141, 150, 159, 169, 179, 189, 200, 212, 223};
    protected JCheckBox buzzerCheckBox;

    public AiciProvOrderwirePane(String string, TabbedView tabbedView, OrderwireModel orderwireModel, String string2) {
        super(string, tabbedView, orderwireModel, string2);
    }

    @Override
    protected void init() {
        this.rawValues[0] = rawValuesL2RX_aici;
        this.rawValues[1] = rawValuesL2TX_aici;
        this.rawValues[2] = rawValuesL4RX_aici;
        this.rawValues[3] = rawValuesL4TX_aici;
        this.minSliderValues[0] = 0;
        this.minSliderValues[1] = -15;
        this.minSliderValues[2] = -16;
        this.minSliderValues[3] = 0;
    }

    @Override
    protected JPanel getOrderwireBuzzerPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Buzzer"));
        this.buzzerCheckBox = new JCheckBox("Buzzer On");
        if (this.isUserAuthorized()) {
            this.buzzerCheckBox.addActionListener(this);
        } else {
            this.buzzerCheckBox.setEnabled(false);
        }
        jPanel.add((Component)this.buzzerCheckBox, "West");
        return jPanel;
    }

    @Override
    protected boolean getBuzzerValue() {
        return this.buzzerCheckBox.isSelected();
    }

    @Override
    protected void setBuzzerValue(boolean bl) {
        this.buzzerCheckBox.setSelected(bl);
    }

    @Override
    protected int getNumSliders() {
        return 4;
    }

    @Override
    protected JSlider createSlider(int n, int n2) {
        int n3 = this.minSliderValues[n2];
        int n4 = n3 + this.rawValues[n2].length - 1;
        JSlider jSlider = new JSlider(n, n3, n4, n3);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        if (n2 == 0) {
            hashtable.put(new Integer(0), new JLabel("0.0"));
            hashtable.put(new Integer(5), new JLabel("2.5"));
            hashtable.put(new Integer(10), new JLabel("5.0"));
            jSlider.setLabelTable(hashtable);
        } else if (n2 == 1) {
            hashtable.put(new Integer(-15), new JLabel("-7.5"));
            hashtable.put(new Integer(-10), new JLabel("-5.0"));
            hashtable.put(new Integer(-5), new JLabel("-2.5"));
            hashtable.put(new Integer(0), new JLabel("0.0"));
            jSlider.setLabelTable(hashtable);
        }
        return jSlider;
    }

    @Override
    protected void setSliderValueLabel(int n, int n2) {
        JLabel jLabel = this.sliderValueLabels[n];
        if (n2 >= 0) {
            if (n == 0 || n == 1) {
                jLabel.setText("+" + Double.toString((double)n2 / 2.0));
            } else {
                jLabel.setText("+" + Integer.toString(n2));
            }
        } else if (n == 0 || n == 1) {
            jLabel.setText(Double.toString((double)n2 / 2.0));
        } else {
            jLabel.setText(Integer.toString(n2));
        }
        jLabel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setDirty();
    }
}

