/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.If.eLaserStatus;
import cerent.cms.idl.If.eOSRIStatus;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.RamanOpticsLineModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ampli.OpticalAlsTableModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.List;
import org.omg.CORBA.UserException;

public class AmpliAlsTableModel
extends OpticalAlsTableModel {
    public static final String[] columnNames = new String[]{"Port", "OSRI", "ALS Mode", "Recovery Pulse Duration ( sec. )", "Recovery Pulse Interval ( sec. )", "Currently Shutdown", "Request Laser Restart", "OSC Based Startup"};
    public static final String[] LaserStatusStrings = new String[]{"YES", "NO", "APR"};
    public static final String[] ALSCommandStrings = new String[]{"Disable", "Auto Restart", "Manual Restart", "Manual Restart for Test"};
    public static final String[] OSRICommandStrings = new String[]{"OFF", "ON"};
    public static final String[] OSRIStatusStrings = new String[]{"OSRI Off", "OSRI On", "N/A"};
    public static final int PORT_NAME_INDEX = 0;
    public static final int OSRI_MODE_INDEX = 1;
    public static final int ALS_MODE_INDEX = 2;
    public static final int RECOVERY_DURATION_INDEX = 3;
    public static final int RECOVERY_INTERVAL_INDEX = 4;
    public static final int CURRENTLY_SHUTDOWN_INDEX = 5;
    public static final int LASER_RESTART_INDEX = 6;
    public static final int RAMAN_OSC_BASED = 7;
    private int[] LaserStatus;
    private int[] OSRIStatus;
    private int[] ALSCommand;
    private int[] OSRICommand;
    private boolean[][] isDirty;
    protected Boolean[] LaserRestart;
    protected Boolean[] ramanOscBased;
    int newALSCommand = 0;
    int newOSRICommand = 0;
    private ElementModelsDelegate elementModel;
    private InterfaceModel[] ifModel = null;
    protected Float[] alsPulseWidthVal = null;
    protected Short[] alsRecIntVal = null;
    protected Boolean[] laserShutdownVal = null;
    private int ALSPort = 0;
    private static final SDebug db = new SDebug("AmpliAlsTableModel");

    public AmpliAlsTableModel(OpticsModuleModel opticsModuleModel, InterfaceModel[] interfaceModelArray) {
        super(db, opticsModuleModel);
        Object object;
        this.ifModel = interfaceModelArray;
        switch (opticsModuleModel.getEqType()) {
            case 287: 
            case 294: 
            case 295: 
            case 296: 
            case 321: {
                object = opticsModuleModel.getALSInterfaces();
                this.numLines = ((AbstractOpticsLineModel[])object).length;
                this.ifModel = object;
                break;
            }
            case 127: {
                this.ALSPort = 2;
                break;
            }
            case 128: {
                this.ALSPort = 6;
            }
        }
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.LaserStatus = new int[this.numLines];
        this.OSRIStatus = new int[this.numLines];
        this.ALSCommand = new int[this.numLines];
        this.OSRICommand = new int[this.numLines];
        this.LaserRestart = new Boolean[this.numLines];
        this.ramanOscBased = new Boolean[this.numLines];
        this.alsPulseWidthVal = new Float[this.numLines];
        this.alsRecIntVal = new Short[this.numLines];
        this.laserShutdownVal = new Boolean[this.numLines];
        object = (NodeModelDelegate)opticsModuleModel.getNodeModel();
        this.elementModel = ((NodeModelDelegate)object).getElementModelsDelegate();
        this.resetDirtyBits();
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 6: {
                return Boolean.class;
            }
            case 3: {
                return Float.class;
            }
            case 4: {
                return Short.class;
            }
            case 7: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public String[] getALSCommandStrings() {
        return ALSCommandStrings;
    }

    public String[] getOSRICommandStrings() {
        return OSRICommandStrings;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && AbstractPane.isUserAuthorized(this.model, SecurityLevel.MAINTENANCE)) {
            if (n2 == 2 || n2 == 1) {
                return true;
            }
            if (n2 == 7) {
                if (this.ifModel[n] instanceof OpticsLineModel) {
                    return true;
                }
            } else if (n2 == 6) {
                return this.TestAlsMode(n);
            }
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            if (db.on()) {
                db.println("Riga [" + n + "]-" + columnNames[n2] + ":");
            }
            switch (n2) {
                case 0: {
                    return this.getPort(n);
                }
                case 2: {
                    return this.getALSMode(n);
                }
                case 1: {
                    return this.getOSRIMode(n);
                }
                case 3: {
                    return this.getRecPulseDuration(n);
                }
                case 4: {
                    return this.getRecPulseInterval(n);
                }
                case 6: {
                    return this.getLaserRestart(n);
                }
                case 5: {
                    return this.getLaserStatusString(n);
                }
                case 7: {
                    return this.getRamanOscBased(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Barolo AlsTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private Object getRamanOscBased(int n) throws WrongInterfaceType, FeatureUnsupported, NoSuchInterface, UserException {
        if (this.ifModel[n] instanceof RamanOpticsLineModel) {
            if (!this.isDirty[n][7]) {
                this.ramanOscBased[n] = ((RamanOpticsLineModel)this.ifModel[n]).getOscBased();
            }
            return this.ramanOscBased[n];
        }
        return null;
    }

    private String getPort(int n) {
        if (this.model.getEqType() == 127 || this.model.getEqType() == 128) {
            n = this.ALSPort;
        }
        try {
            IPortModel iPortModel = this.ifModel[n].getPortModel();
            return PortHelper.getPortNumString((IPortModel)iPortModel) + " (" + this.getType(n) + ")";
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return "N/A";
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
            return "N/A";
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
            return "N/A";
        }
    }

    private String getType(int n) throws NoSuchInterface, WrongInterfaceType {
        return ((AbstractOpticsLineModel)this.ifModel[n]).getOptPortTypeString();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        try {
            switch (n2) {
                case 2: {
                    this.newALSCommand = this.getIndexOf((String)object, ALSCommandStrings);
                    if (this.ALSCommand[n] == this.newALSCommand) {
                        return;
                    }
                    this.ALSCommand[n] = this.newALSCommand;
                    if (this.ALSCommand[n] != 2 && this.ALSCommand[n] != 3 && this.LaserRestart[n] != Boolean.FALSE) {
                        this.LaserRestart[n] = Boolean.FALSE;
                        this.isDirty[n][6] = true;
                        this.fireTableCellUpdated(n, 6);
                    }
                    break;
                }
                case 1: {
                    this.newOSRICommand = this.getIndexOf((String)object, OSRICommandStrings);
                    if (this.OSRICommand[n] == this.newOSRICommand) {
                        return;
                    }
                    this.OSRICommand[n] = this.newOSRICommand;
                    break;
                }
                case 6: {
                    Boolean bl = (Boolean)object;
                    if (this.LaserRestart[n].equals(bl)) {
                        return;
                    }
                    this.LaserRestart[n] = bl;
                    break;
                }
                case 7: {
                    Boolean bl = (Boolean)object;
                    if (this.ramanOscBased[n].equals(bl)) {
                        return;
                    }
                    this.ramanOscBased[n] = bl;
                    this.isDirty[n][7] = true;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public void setOSRIOn(int n) {
        try {
            this.model.setOSRIStatus(eOSRIStatus.OSRI_ON, n);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void setOSRIOff(int n) {
        try {
            this.model.setOSRIStatus(eOSRIStatus.OSRI_OFF, n);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public String getOSRIStatus(int n) {
        try {
            eOSRIStatus eOSRIStatus2;
            eOSRIStatus eOSRIStatus3 = eOSRIStatus2 = this.model != null ? this.model.getOSRIStatus(n) : eOSRIStatus.OSRI_OFF;
            this.OSRIStatus[n] = eOSRIStatus2 == eOSRIStatus.OSRI_OFF ? 0 : (eOSRIStatus2 == eOSRIStatus.OSRI_ON ? 1 : 2);
        }
        catch (Exception exception) {
            this.OSRIStatus[n] = 2;
        }
        return OSRIStatusStrings[this.OSRIStatus[n]];
    }

    public String getLaserStatusString(int n) {
        eLaserStatus eLaserStatus2 = this.getLaserStatus(n);
        if (eLaserStatus2 != null) {
            if (eLaserStatus2 == eLaserStatus.OFF) {
                this.LaserStatus[n] = 0;
            } else if (eLaserStatus2 == eLaserStatus.ON) {
                this.LaserStatus[n] = 1;
            } else if (eLaserStatus2 == eLaserStatus.APR) {
                this.LaserStatus[n] = 2;
            }
        } else {
            return "N/A";
        }
        return LaserStatusStrings[this.LaserStatus[n]];
    }

    private eLaserStatus getLaserStatus(int n) {
        try {
            return this.model != null ? this.model.getLaserStatus(n) : eLaserStatus.OFF;
        }
        catch (Exception exception) {
            db.severe("Error getting the laser status" + exception);
            return null;
        }
    }

    private Float getRecPulseDuration(int n) {
        int n2 = n;
        if (this.model.getEqType() == 127 || this.model.getEqType() == 128) {
            n2 = this.ALSPort;
        }
        if (this.alsPulseWidthVal[n] == null) {
            try {
                this.alsPulseWidthVal[n] = new Float(this.ifModel[n2].getALSRecoveryPulseWidth());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting ALS Pulse Width:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.alsPulseWidthVal[n] = new Float(0.0f);
            }
        }
        return this.alsPulseWidthVal[n];
    }

    private Boolean getLaserRestart(int n) {
        if (this.LaserRestart[n] == null) {
            this.LaserRestart[n] = Boolean.FALSE;
        }
        return this.LaserRestart[n];
    }

    protected Short getRecPulseInterval(int n) {
        if (this.alsRecIntVal[n] == null) {
            try {
                int n2 = n;
                if (this.model.getEqType() == 127 || this.model.getEqType() == 128) {
                    n2 = this.ALSPort;
                }
                this.alsRecIntVal[n] = new Short(this.ifModel[n2].getALSRecoveryInterval());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting ALS Pulse Interval:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                this.alsRecIntVal[n] = new Short("0");
            }
        }
        return this.alsRecIntVal[n];
    }

    public String getALSMode(int n) {
        if (this.ALSCommand[n] == -1) {
            try {
                int n2;
                int n3 = n;
                if (this.model.getEqType() == 127 || this.model.getEqType() == 128) {
                    n3 = this.ALSPort;
                }
                this.ALSCommand[n] = n2 = this.ifModel[n3].getALSMode();
            }
            catch (Exception exception) {
                this.ALSCommand[n] = 0;
            }
        }
        return ALSCommandStrings[this.ALSCommand[n]];
    }

    public String getOSRIMode(int n) {
        if (this.OSRICommand[n] == -1) {
            try {
                eOSRIStatus eOSRIStatus2;
                eOSRIStatus eOSRIStatus3 = eOSRIStatus2 = this.model != null ? this.model.getOSRIStatus(n) : eOSRIStatus.OSRI_OFF;
                this.OSRICommand[n] = eOSRIStatus2 == eOSRIStatus.OSRI_OFF ? 0 : 1;
            }
            catch (Exception exception) {
                this.OSRIStatus[n] = 0;
            }
        }
        return OSRICommandStrings[this.OSRICommand[n]];
    }

    private boolean TestAlsMode(int n) {
        return this.ALSCommand[n] == 2 && this.getLaserStatus(n) == eLaserStatus.OFF || this.ALSCommand[n] == 3 && this.getLaserStatus(n) == eLaserStatus.OFF;
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.LaserRestart[i] = null;
            this.ramanOscBased[i] = null;
            this.refreshLineFromModel(i);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    public void refreshFromReset() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
    }

    public void refreshLineFromModel(int n) {
        this.resetLineCache(n);
        this.getALSMode(n);
        this.getOSRIMode(n);
        this.getRecPulseDuration(n);
        this.getRecPulseInterval(n);
        this.getLaserRestart(n);
        this.getLaserStatusString(n);
        try {
            this.getRamanOscBased(n);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.LaserStatus[n] = -1;
        this.OSRIStatus[n] = -1;
        this.ALSCommand[n] = -1;
        this.OSRICommand[n] = -1;
        this.alsPulseWidthVal[n] = null;
        this.alsRecIntVal[n] = null;
        this.laserShutdownVal[n] = null;
        this.LaserRestart[n] = null;
        this.ramanOscBased[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void applyToModel() throws Exception {
        int n = this.ALSPort;
        int n2 = 0;
        if (db.on()) {
            db.println("applyToModel");
        }
        String string = "";
        int n3 = this.model.getEqType();
        string = this.ALSCommand[n2] == 0 && (n3 == 130 || n3 == 196 || n3 == 239 || n3 == 240 || n3 == 277 || n3 == 278 || n3 == 286 || n3 == 281 || n3 == 294 || n3 == 296 || n3 == 295) ? "Attention!  This operation will disable optical safety \nand can cause a potential safety hazard.\n\n" : "The selected operation will be service affecting.\n";
        String string2 = n3 == 286 ? "The changes will be performed only on standby port. Is it OK to apply the changes anyway?" : "Is it OK to apply the changes anyway?";
        if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)(string + string2), (String)"Confirmation Dialog")) {
            try {
                for (n2 = 0; n2 < this.numLines; ++n2) {
                    int n4;
                    if (this.isDirty[n2][2]) {
                        n4 = this.model.getEqType();
                        if (n4 == 287 || n4 == 321 || n4 == 294 || n4 == 296 || n4 == 295) {
                            n = n2;
                        }
                        this.ifModel[n].setALSMode(this.ALSCommand[n2]);
                    }
                    if (this.isDirty[n2][1]) {
                        if (this.OSRICommand[n2] == 1) {
                            this.setOSRIOn(n2);
                        } else {
                            this.setOSRIOff(n2);
                        }
                    }
                    if (this.isDirty[n2][6]) {
                        n4 = this.model.getEqType();
                        if (n4 == 287 || n4 == 321 || n4 == 294 || n4 == 296 || n4 == 295) {
                            n = n2;
                        }
                        this.ifModel[n].restartLaser();
                    }
                    if (!this.isDirty[n2][7]) continue;
                    this.setOscBased(n2);
                }
                this.resetDirtyBits();
            }
            catch (ConfigError configError) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ERROR_LASER_ON);
                this.refreshFromModel();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
                this.refreshFromModel();
            }
            catch (Exception exception) {
                throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_ERROR_APPLYING_CHANGES), exception);
            }
        } else {
            this.refreshFromModel();
        }
    }

    private void setOscBased(int n) {
        try {
            ((RamanOpticsLineModel)this.ifModel[n]).setOscBased(this.ramanOscBased[n]);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    private Frame getFrame() {
        return this.elementModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

