/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class AmpliModeTableModel
extends AbstractTableModel {
    private static final SDebug db = new SDebug("AmpliModeTableModel");
    private boolean[] rowDirty = new boolean[this.numPorts];
    private int numLines = 1;
    private int numPorts = 1;
    public static String[] columnNames = new String[]{"System Type", "Control Mode"};
    protected static final int SYSTEM_TYPE_INDEX = 0;
    protected static final int CONTROL_MODE_INDEX = 1;
    public static final String[] systemTypeStrings = new String[]{"SMF-48", "SMF-49"};

    public AmpliModeTableModel() {
        this.resetRowDirty();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    private Integer getLineNumberFor(int n) {
        return new Integer(n + 1);
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getSystemType(n);
                }
                case 1: {
                    return this.getControlMode(n);
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private String getSystemType(int n) {
        return "SMF-28";
    }

    private String getControlMode(int n) {
        return "Na";
    }

    public void resetRowDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        this.fireTableRowsUpdated(n, n);
    }

    public void refresh() {
        for (int i = 0; i < this.numPorts; ++i) {
        }
        this.fireTableRowsUpdated(0, this.numPorts - 1);
    }

    public static void main(String[] stringArray) {
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void destroy() {
        this.rowDirty = null;
    }

    public String[] getSystemTypeStrings() {
        return systemTypeStrings;
    }
}

