/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.Optics.eOpticalAmplifierControlMode;
import cerent.cms.idl.OpticsTopology.eDwdmRingType;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.OpticalTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;

public class AmpliParametersTableModel
extends OpticalTableModel {
    public static final int SIDE_INDEX = 14;
    public static final int OSC_POWER_INDEX = 15;
    public static final int POWREF_INDEX = 16;
    public static final int SIGNAL_OUTPOWER_INDEX = 17;
    public static final int OUTPOWER_SETPOINT_INDEX = 18;
    public static final int MODE_INDEX = 19;
    public static final int DCU_INSLOSS_INDEX = 20;
    public static final int GAIN_INDEX = 21;
    public static final int SETPOINT_GAIN_INDEX = 22;
    public static final int TILT_REFERENCE_INDEX = 23;
    public static final int TILT_CALIB_INDEX = 24;
    public static final int MAX_AMPLI_COLUMN = 25;
    public static final int OUTPUT_POWER = 0;
    public static final int GAIN = 1;
    public static final int FIXED_GAIN = 2;
    public static final int INVALID = 3;
    public static final String[] ModeStrings = new String[]{"Control Power", "Gain", "Fixed Gain", "N/A"};
    public static String[] columnNames = new String[]{"Side", "OSC Power", "Channel Power Ref.", "Signal Output Power", "Output Power Set-Point", "Working Mode", "DCU Insertion Loss", "Gain", "Gain SetPoint", "Tilt Reference", "Tilt Calibration"};
    private String[] oscPower = new String[this.numLines];
    private int[] Mode = new int[this.numLines];
    private String[] SetPointGain;
    private String[] TiltCalib = new String[this.numLines];
    private String[] ChnPower;
    private boolean FlgOkDialog = false;
    private boolean FlgAdminStateChanged = false;
    private String[] actAseCompPwr;
    private String[] actGain;
    private static final SDebug db = new SDebug("AmpliParametersTableModel");

    public AmpliParametersTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(db, abstractOpticsLineModelArray);
        this.SetPointGain = new String[this.numLines];
        this.ChnPower = new String[this.numLines];
        this.actAseCompPwr = new String[this.numLines];
        this.actGain = new String[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.oscPower[i] = null;
            this.Mode[i] = -1;
            this.TiltCalib[i] = null;
            this.SetPointGain[i] = null;
            this.ChnPower[i] = null;
            this.actAseCompPwr[i] = null;
            this.actGain[i] = null;
        }
        this.changeColumnName(23);
        this.changeColumnName(5);
        this.changeColumnName(7);
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return super.getColumnCount() + columnNames.length;
    }

    private void changeColumnName(int n) {
        if (this.model[0] instanceof OpticsAmplifiedLineModel && (this.eqpmtModel.getEqType() == 287 || this.eqpmtModel.getEqType() == 321 || this.eqpmtModel.getEqType() == 277 || this.eqpmtModel.getEqType() == 278) && n == 23) {
            AmpliParametersTableModel.columnNames[9] = "Tilt";
        } else if (this.model[0] instanceof OpticsAmplifiedLineModel && n == 23) {
            AmpliParametersTableModel.columnNames[9] = "Tilt Reference";
        }
        if (this.model[0] instanceof OpticsAmplifiedLineModel && n == 5) {
            this.otmColumnNames[5] = "Total Output Power";
        }
        if (this.model[0] instanceof OpticsAmplifiedLineModel && n == 7) {
            this.otmColumnNames[7] = "Offset";
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 16 || n2 == 22 && this.ringtype == eDwdmRingType.METRO_ACCESS) {
            return true;
        }
        if (n2 == 24) {
            return !this.Flg_FeatureUnsupported[n][n2];
        }
        return super.isCellEditable(n, n2);
    }

    @Override
    public String getColumnName(int n) {
        if (n < 14) {
            return super.getColumnName(n);
        }
        return columnNames[n - 14];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 15: {
                    return this.getOSCPower(n);
                }
                case 16: {
                    return this.getChnPowerRef(n);
                }
                case 19: {
                    return this.getMode(n);
                }
                case 20: {
                    return this.getDCUInsLoss(n);
                }
                case 21: {
                    return this.actGain[n];
                }
                case 22: {
                    return this.getSetPointGain(n);
                }
                case 23: {
                    return this.getTiltReference(n);
                }
                case 24: {
                    return this.getTiltCal(n);
                }
                case 18: {
                    return this.getRefPower(n);
                }
                case 17: {
                    return this.actAseCompPwr[n];
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("AmpliParametersTableModel: error in getValueAt" + exception);
            }
            KDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value row=" + n + " col=" + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 22: {
                    this.SetPointGain[n] = (String)object;
                    break;
                }
                case 24: {
                    this.TiltCalib[n] = (String)object;
                    break;
                }
                case 16: {
                    this.ChnPower[n] = (String)object;
                    break;
                }
                default: {
                    super.setValueAt(object, n, n2);
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            KDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    boolean isCOMPort(int n) {
        try {
            OpticalPortType opticalPortType = this.model[n].getOptPortType();
            return opticalPortType == OpticalPortType.IN_COM || opticalPortType == OpticalPortType.OUT_COM;
        }
        catch (Exception exception) {
            db.warning("Cannot get port type for " + this.model[n] + ": " + exception.getMessage());
            if (db.isFinestEnabled()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return false;
        }
    }

    private String getMode(int n) {
        if (this.Mode[n] == -1) {
            try {
                if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel) {
                    eOpticalAmplifierControlMode eOpticalAmplifierControlMode2;
                    OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                    eOpticalAmplifierControlMode eOpticalAmplifierControlMode3 = eOpticalAmplifierControlMode2 = this.model[n] != null ? opticsAmplifiedLineModel.getControlMode() : eOpticalAmplifierControlMode.OUTPUT_POWER;
                    this.Mode[n] = eOpticalAmplifierControlMode2 == eOpticalAmplifierControlMode.GAIN ? 1 : (eOpticalAmplifierControlMode2 == eOpticalAmplifierControlMode.OUTPUT_POWER ? 0 : (eOpticalAmplifierControlMode2 == eOpticalAmplifierControlMode.FIXED_GAIN_MODE ? 2 : 3));
                } else {
                    this.Mode[n] = 3;
                }
            }
            catch (Exception exception) {
                this.Mode[n] = 3;
            }
        }
        return ModeStrings[this.Mode[n]];
    }

    protected String getOSCPowerFromUnit(int n) {
        return this.model[n].getOSCPowerString();
    }

    private String getRefPower(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getReferencePower();
            string = ConvertPwrToDb.formatDecimalNumber(n2);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    public String getChnPowerRef(int n) {
        if (this.ChnPower[n] == null) {
            try {
                if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel) {
                    OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                    int n2 = opticsAmplifiedLineModel.getChnPowerRef();
                    this.ChnPower[n] = n2 != -1000000 ? ConvertPwrToDb.formatDecimalNumber(n2) : "N/A";
                }
            }
            catch (Exception exception) {
                this.ChnPower[n] = "N/A";
            }
        }
        return this.ChnPower[n];
    }

    public void setChnPower(int n) {
        if (AmpliParametersTableModel.isValidNumber(this.ChnPower[n], "Chn Power.")) {
            float f = Float.parseFloat(this.ChnPower[n]);
            int n2 = (int)(f *= 10.0f);
            try {
                OpticsAmplifiedLineModel opticsAmplifiedLineModel = (OpticsAmplifiedLineModel)this.model[n];
                opticsAmplifiedLineModel.setChnPower(n2);
            }
            catch (ProvisionError provisionError) {
                int n3 = provisionError.getDiscriminator();
                if (n3 == 3) {
                    int n4 = provisionError.getLoValue();
                    String string = ConvertPwrToDb.formatDecimalNumber(n4);
                    int n5 = provisionError.getHiValue();
                    String string2 = ConvertPwrToDb.formatDecimalNumber(n5);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "Per Channel Power ", string, string2);
                    this.ChnPower[n] = null;
                    this.getChnPowerRef(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.ChnPower[n] = null;
                this.getChnPowerRef(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.ChnPower[n] = null;
            this.getChnPowerRef(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private String getDCUInsLoss(int n) {
        String string = "N/A";
        try {
            int n2;
            if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel && (n2 = ((OpticsAmplifiedLineModel)this.model[n]).getDCULoss()) != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getGainValue(int n) {
        String string = "N/A";
        try {
            int n2;
            if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel && (n2 = ((OpticsAmplifiedLineModel)this.model[n]).getGain()) != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getComAsePower(int n) {
        String string = "N/A";
        try {
            int n2;
            if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel && (n2 = ((OpticsAmplifiedLineModel)this.model[n]).getAsePower()) != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getSetPointGain(int n) {
        if (this.SetPointGain[n] == null) {
            this.SetPointGain[n] = "N/A";
            try {
                int n2;
                if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel && (n2 = ((OpticsAmplifiedLineModel)this.model[n]).getGainSetPoint()) != -1000000) {
                    this.SetPointGain[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                }
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.SetPointGain[n];
    }

    private void setSetPointGain(int n) {
        if (AmpliParametersTableModel.isValidNumber(this.SetPointGain[n], "Gain Set Point")) {
            float f = Float.parseFloat(this.SetPointGain[n]) * 10.0f;
            try {
                ((OpticsAmplifiedLineModel)this.model[n]).setGainSetPoint((int)f);
            }
            catch (ProvisionError provisionError) {
                int n2 = provisionError.getDiscriminator();
                if (n2 == 3) {
                    int n3 = provisionError.getLoValue();
                    String string = ConvertPwrToDb.formatDecimalNumber(n3);
                    int n4 = provisionError.getHiValue();
                    String string2 = ConvertPwrToDb.formatDecimalNumber(n4);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "Gain Set Point", string, string2);
                    this.SetPointGain[n] = null;
                    this.getSetPointGain(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.SetPointGain[n] = null;
                this.getSetPointGain(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.SetPointGain[n] = null;
            this.getSetPointGain(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    private String getTiltReference(int n) {
        String string = "N/A";
        try {
            int n2;
            if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel && (n2 = ((OpticsAmplifiedLineModel)this.model[n]).getReferenceTilt()) != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getTiltCal(int n) {
        if (this.TiltCalib[n] == null) {
            this.Flg_FeatureUnsupported[n][24] = true;
            try {
                int n2;
                if (this.model[n] != null && this.model[n] instanceof OpticsAmplifiedLineModel && (n2 = ((OpticsAmplifiedLineModel)this.model[n]).getCalibratedTilt()) != -1000000) {
                    this.TiltCalib[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][24] = false;
                }
            }
            catch (Exception exception) {
                this.TiltCalib[n] = "N/A";
            }
        }
        return this.TiltCalib[n];
    }

    private void setTiltCal(int n) {
        if (AmpliParametersTableModel.isValidNumber(this.TiltCalib[n], "Tilt Calib.")) {
            float f = Float.parseFloat(this.TiltCalib[n]) * 10.0f;
            try {
                ((OpticsAmplifiedLineModel)this.model[n]).setTiltCalibration((int)f);
            }
            catch (ProvisionError provisionError) {
                int n2 = provisionError.getDiscriminator();
                if (n2 == 3) {
                    int n3 = provisionError.getLoValue();
                    String string = ConvertPwrToDb.formatDecimalNumber(n3);
                    int n4 = provisionError.getHiValue();
                    String string2 = ConvertPwrToDb.formatDecimalNumber(n4);
                    ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_4, "Tilt Calibration and Tilt Reference", string, string2);
                    this.TiltCalib[n] = null;
                    this.getTiltCal(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                }
            }
            catch (Exception exception) {
                this.TiltCalib[n] = null;
                this.getTiltCal(n);
                this.fireTableRowsUpdated(0, this.numLines - 1);
            }
        } else {
            this.TiltCalib[n] = null;
            this.getTiltCal(n);
            this.fireTableRowsUpdated(0, this.numLines - 1);
        }
    }

    @Override
    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.getMode(n);
        this.SetPointGain[n] = this.getSetPointGain(n);
        this.TiltCalib[n] = this.getTiltCal(n);
        this.ChnPower[n] = this.getChnPowerRef(n);
        this.actGain[n] = this.getGainValue(n);
        this.actAseCompPwr[n] = this.getComAsePower(n);
        this.getRefPower(n);
        this.oscPower[n] = this.getOSCPowerFromUnit(n);
        super.refreshLineFromModel(n);
    }

    @Override
    protected void resetLineCache(int n) {
        super.resetLineCache(n);
        this.oscPower[n] = null;
        this.actGain[n] = null;
        this.actAseCompPwr[n] = null;
        this.TiltCalib[n] = null;
        this.SetPointGain[n] = null;
        this.ChnPower[n] = null;
        this.Mode[n] = -1;
    }

    @Override
    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if ((this.isDirty[n][24] || this.isDirty[n][22]) && !this.FlgOkDialog) {
                    if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)"The selected operation could be service affecting. Is it OK to apply the changes anyway?", (String)"Confirmation Dialog")) {
                        this.FlgOkDialog = true;
                    } else {
                        this.refreshFromModel();
                        return;
                    }
                }
                if (this.isDirty[n][22]) {
                    this.setSetPointGain(n);
                }
                if (this.isDirty[n][24]) {
                    this.setTiltCal(n);
                }
                if (!this.isDirty[n][16]) continue;
                this.setChnPower(n);
            }
            super.applyToModel();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            if (this.FlgAdminStateChanged) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_CHANGE_ADMIN_STATE_NOTALLOWED);
            } else {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            }
            this.refreshFromModel();
        }
    }

    public String getOSCPower(int n) {
        return this.oscPower[n];
    }
}

