/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CommonHelper;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ampli.AmpliPMPane;
import cerent.cms.ui.ochterm.OchPmPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;

public class AmpliPerfPane
extends AbstractPane
implements ITabName {
    ModuleModel eqpmtModel = null;
    protected OpticsLineModel[] otsModels;
    protected OpticsModuleModel model;
    private static final SDebug db = new SDebug("AmpliPerfPane");

    public AmpliPerfPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView);
        this.eqpmtModel = moduleModel;
        this.model = (OpticsModuleModel)this.getUiModel();
        this.initLineModel();
        this.subTabs = new SubTabbedView(moduleModel, tabbedView);
        this.subTabs.addTab("Optical Line", (Component)this.getPMTab(this.model.getOTSSupportingPM()));
        if (!CommonHelper.isTDCUCard(this.model)) {
            this.subTabs.addTab("Opt.Ampli.Line", (Component)this.getPMTab(this.model.getAOTSSupportingPM()));
        }
        if (this.model.getEqType() == 294 || this.model.getEqType() == 295 || this.model.getEqType() == 296) {
            AbstractOpticsLineModel[] abstractOpticsLineModelArray = ((OpticsModuleModel)this.getUiModel()).getInterfaceSupportingOch();
            this.subTabs.addTab("OCH", (Component)this.getOptOchPMTab(abstractOpticsLineModelArray));
        }
        this.subTabs.setTabPlacement(2);
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    protected void initLineModel() {
        this.otsModels = this.model.getOTSSupportingPM();
    }

    protected Pane getPMTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new AmpliPMPane("Optics PM", this.getParentView(), abstractOpticsLineModelArray);
    }

    protected Pane getOptOchPMTab(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        return new OchPmPane("Optics PM", this.getParentView(), abstractOpticsLineModelArray);
    }

    public boolean hasSubTabs() {
        return true;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void enteringPage() throws Exception {
    }

    @Override
    public void leavingPage() throws Exception {
    }
}

