/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class OchncMaintenancePane
extends AbstractPane
implements ActionListener {
    private JPanel mainPanel;
    private boolean isAuthUser = this.isUserAuthorized(SecurityLevel.PROVISIONING);
    private JTextField actualTextField;
    private JTextField powerTextField;
    public static final String APPLY = "Apply";
    private JButton applyButton;
    private JComboBox portComboBox;
    private JComboBox waveLengthComboBox;
    private JButton refreshButton;
    private JButton clearButton;
    private AbstractOpticsLineModel lineTxModel;
    private Attribute wave = null;
    private String powerStr = "";
    private String actualStr = "";
    private int portIndex = 0;
    private boolean isChannelActive = false;
    private ObservableManager _obsMgr = null;
    private static String OVERLOAD_STR = "Overload";
    private static String LIMIT_OVERLOAD_STR = "100000.0";
    private static String NA_VALUE = "-100000.0";
    private static String NA_STR = "N/A";
    private boolean isDirty = false;

    public OchncMaintenancePane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView);
        this.initComponents();
        this.init();
        this.portComboBox.setModel(this.createDefaultPort(abstractOpticsLineModelArray));
        this.getObsMgr().addObservable((Observable)((Object)this.lineTxModel));
    }

    protected void init() {
        this.retValuePanelInit();
        this.insertValuePanelInit();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.OCHNCMaintPane);
        this.add(cSHelpButtonPane, "South");
        this.actualTextField = new JTextField();
        this.powerTextField = new JTextField();
        this.portComboBox = new JComboBox();
        this.refreshButton = new JButton("Refresh");
        this.clearButton = new JButton("Delete");
        this.add(this.mainPanel, "North");
    }

    private JPanel getRefreshButtonPanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jPanel.setLayout(new GridBagLayout());
        this.refreshButton.setEnabled(false);
        this.refreshButton.addActionListener(this);
        jPanel.add((Component)this.refreshButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(this);
        jPanel.add((Component)this.clearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        jLabel.setText("Auto-refresh:");
        return jPanel;
    }

    private void insertValuePanelInit() {
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jLabel.setText("Target Power (dBm)");
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 10, 10), 0, 0));
        this.powerTextField.setText("");
        this.powerTextField.addActionListener(this);
        this.powerTextField.setMaximumSize(new Dimension(100, 20));
        jPanel.add((Component)this.powerTextField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 0, 10), 0, 0));
        jLabel2.setText("Port");
        jLabel2.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.portComboBox.setMaximumSize(new Dimension(100, 20));
        this.portComboBox.addActionListener(this);
        jPanel.add((Component)this.portComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        jLabel3.setText("Wavelength");
        jLabel3.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 10, 10), 0, 0));
        this.waveLengthComboBox = new JComboBox();
        this.waveLengthComboBox.setModel(new DefaultComboBoxModel<Attribute>(((OpticsModuleModel)this.getUiModel()).getSupportedWavelengths()));
        this.waveLengthComboBox.setEditable(false);
        this.waveLengthComboBox.setMaximumSize(new Dimension(100, 20));
        this.waveLengthComboBox.addActionListener(this);
        jPanel.add((Component)this.waveLengthComboBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
        Dimension dimension = new Dimension(75, 25);
        this.applyButton = new JButton(APPLY);
        this.applyButton.setEnabled(this.isAuthUser);
        this.applyButton.setMinimumSize(dimension);
        this.applyButton.setMaximumSize(dimension);
        this.applyButton.addActionListener(this);
        jPanel.add((Component)this.applyButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 40, 0, 0), 0, 0));
        jPanel2.setBorder(new TitledBorder("Insert Value"));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jPanel);
        this.mainPanel.add((Component)jPanel2, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 50, 0), 0, 0));
    }

    private void retValuePanelInit() {
        JLabel jLabel = new JLabel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jLabel.setText("Actual Power (dBm):");
        jLabel.setHorizontalAlignment(2);
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 3, 0, 10), 0, 0));
        this.actualTextField.setPreferredSize(new Dimension(100, 20));
        this.actualTextField.setEditable(false);
        jPanel2.add((Component)this.actualTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("                  ");
        jPanel2.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        if (((OpticsModuleModel)this.getUiModel()).getEqType() == 294 || ((OpticsModuleModel)this.getUiModel()).getEqType() == 295) {
            jPanel.setBorder(new TitledBorder("Return Value LINE-TX on selected Wavelength"));
        } else {
            jPanel.setBorder(new TitledBorder("Return Value on selected Wavelength"));
        }
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jPanel2);
        jPanel.add(this.getRefreshButtonPanel());
        this.mainPanel.add((Component)jPanel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 50, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshButton) {
            this.getMaintenanceChanelPower(this.lineTxModel);
            this.resetModel();
            this.applyButton.setEnabled(true);
            return;
        }
        if (object == this.clearButton) {
            this.disaMaintenanceChanelPower(this.lineTxModel);
            this.isChannelActive = false;
            this.clearActualPwrField();
            this.updateButtons();
        }
        if (object == this.applyButton) {
            this.updateModel();
        }
    }

    @Override
    public void enteringPage() throws Exception {
        this.getMaintenanceChanelPower(this.lineTxModel);
        this.resetModel();
    }

    public void updateModel() {
        int n;
        int n2 = 0;
        if (this.powerTextField.getText().trim().length() == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FIELD_IS_REQUIRED_PARAM_1, (Object)"Target Power and Voa Attenuation");
            return;
        }
        try {
            n = this.convertStringToPwr(this.powerTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_WRONG_INPUT);
            return;
        }
        if (this.isChannelActive) {
            try {
                Attribute attribute = (Attribute)this.portComboBox.getSelectedItem();
                this.setMaintenanceChanelPower(attribute.getIntValue(), n, n2, (Attribute)this.waveLengthComboBox.getSelectedItem());
                this.portIndex = attribute.getIntValue();
                this.wave = (Attribute)this.waveLengthComboBox.getSelectedItem();
                this.powerStr = this.powerTextField.getText();
                this.clearActualPwrField();
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayDetailed((Component)((Object)this), provisionError.getEID(), provisionError.getEIDMsg());
                return;
            }
            catch (FeatureUnsupported featureUnsupported) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, (Exception)((Object)featureUnsupported));
                return;
            }
        }
        try {
            Attribute attribute = (Attribute)this.portComboBox.getSelectedItem();
            this.enaMaintenanceChanelPower(attribute.getIntValue(), n, n2, (Attribute)this.waveLengthComboBox.getSelectedItem());
            this.portIndex = attribute.getIntValue();
            this.wave = (Attribute)this.waveLengthComboBox.getSelectedItem();
            this.powerStr = this.powerTextField.getText();
            this.clearActualPwrField();
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayDetailed((Component)((Object)this), provisionError.getEID(), provisionError.getEIDMsg());
            return;
        }
        catch (FeatureUnsupported featureUnsupported) {
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_OPERATION, (Exception)((Object)featureUnsupported));
            return;
        }
        this.isChannelActive = true;
        this.updateButtons();
    }

    public void resetModel() {
        this.powerTextField.setText(this.powerStr);
        if (this.actualStr.equals(LIMIT_OVERLOAD_STR)) {
            this.actualTextField.setText(OVERLOAD_STR);
        } else if (this.actualStr.equals(NA_VALUE)) {
            this.actualTextField.setText(NA_STR);
        } else {
            this.actualTextField.setText(this.actualStr);
        }
        if (this.portIndex != 0) {
            this.setSelectedPort(this.portIndex);
            this.waveLengthComboBox.setSelectedItem(this.wave);
        } else {
            this.portComboBox.setSelectedIndex(0);
            this.waveLengthComboBox.setSelectedIndex(0);
        }
        this.updateButtons();
    }

    private DefaultComboBoxModel createDefaultPort(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        Vector<Attribute> vector = new Vector<Attribute>();
        try {
            int n;
            for (n = 0; n < abstractOpticsLineModelArray.length; ++n) {
                if (abstractOpticsLineModelArray[n].getOptPortType() != OpticalPortType.OUT_LINE && !this.isWxc80Port(abstractOpticsLineModelArray[n])) continue;
                this.lineTxModel = abstractOpticsLineModelArray[n];
                this.powerStr = this.lineTxModel.defaultPTargetMaintenance();
                break;
            }
            for (n = 0; n < abstractOpticsLineModelArray.length; ++n) {
                if (abstractOpticsLineModelArray[n].getOptPortType() != OpticalPortType.IN_EXPRESS && abstractOpticsLineModelArray[n].getOptPortType() != OpticalPortType.ADD && abstractOpticsLineModelArray[n].getOptPortType() != OpticalPortType.EAD_BIDI && abstractOpticsLineModelArray[n].getOptPortType() != OpticalPortType.AD_BIDI) continue;
                vector.add(new Attribute(this.getPortNameString(abstractOpticsLineModelArray[n]), abstractOpticsLineModelArray[n].getIndex()));
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return new DefaultComboBoxModel<Attribute>(vector.toArray(new Attribute[0]));
    }

    @Override
    public void leavingPage() throws Exception {
    }

    private void disaMaintenanceChanelPower(AbstractOpticsLineModel abstractOpticsLineModel) {
        try {
            abstractOpticsLineModel.disaMaintenanceChanelPower(this.getOutputIndex());
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
        }
        catch (FeatureUnsupported featureUnsupported) {
            KDebug.printStackTrace((Throwable)featureUnsupported);
        }
    }

    private int[] getMaintenanceChanelPower(AbstractOpticsLineModel abstractOpticsLineModel) {
        int[] nArray;
        try {
            nArray = abstractOpticsLineModel.getMaintenanceChanelPower(this.getOutputIndex());
            try {
                this.portIndex = nArray[1] = Integer.parseInt(String.valueOf(nArray[1]));
            }
            catch (NumberFormatException numberFormatException) {
                this.portIndex = 0;
                return null;
            }
            boolean bl = this.isChannelActive = this.portIndex != 0;
            if (this.isChannelActive) {
                this.wave = nArray[2] == 82 ? Wavelength.getCMaintenanceWlAttribute() : Wavelength.getWlAttribute(nArray[2]);
                this.powerStr = this.convertPwrToString(nArray[3]);
                this.actualStr = this.convertPwrToString(nArray[5]);
            } else {
                this.wave = null;
                this.powerStr = "";
                this.actualStr = "";
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            this.wave = null;
            this.powerStr = "";
            this.actualStr = "";
            this.portIndex = 0;
            this.isChannelActive = false;
            KDebug.printStackTrace((Throwable)noSuchInterface);
            return null;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
            return null;
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
            return null;
        }
        catch (FeatureUnsupported featureUnsupported) {
            KDebug.printStackTrace((Throwable)featureUnsupported);
            return null;
        }
        return nArray;
    }

    private void enaMaintenanceChanelPower(int n, int n2, int n3, Attribute attribute) throws ProvisionError, FeatureUnsupported {
        int[] nArray = new int[]{this.getOutputIndex(), n, attribute.getIntValue(), n2, n3};
        try {
            this.lineTxModel.enaMaintenanceChanelPower(nArray);
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
        }
    }

    private void setMaintenanceChanelPower(int n, int n2, int n3, Attribute attribute) throws ProvisionError, FeatureUnsupported {
        int[] nArray = new int[]{this.getOutputIndex(), n, attribute.getIntValue(), n2, n3};
        try {
            this.lineTxModel.setMaintenanceChanelPower(nArray);
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
        }
    }

    public final int getOutputIndex() {
        return this.lineTxModel.getIndex();
    }

    private String getPortNameString(AbstractOpticsLineModel abstractOpticsLineModel) {
        String string;
        try {
            string = PortHelper.getPortNumString((IPortModel)abstractOpticsLineModel.getPortModel());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            string = String.valueOf(1);
        }
        return string + " (" + this.getType(abstractOpticsLineModel) + ")";
    }

    private String getType(AbstractOpticsLineModel abstractOpticsLineModel) {
        try {
            return abstractOpticsLineModel.getOptPortTypeString();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    private void setSelectedPort(int n) {
        for (int i = 0; i < this.portComboBox.getItemCount(); ++i) {
            if (((Attribute)this.portComboBox.getItemAt(i)).getIntValue() != n) continue;
            this.portComboBox.setSelectedIndex(i);
            break;
        }
    }

    private void clearActualPwrField() {
        this.actualStr = "";
        this.actualTextField.setText(this.actualStr);
    }

    private void updateButtons() {
        this.refreshButton.setEnabled(this.isChannelActive);
        this.clearButton.setEnabled(this.isChannelActive);
        this.portComboBox.setEnabled(!this.isChannelActive);
        this.waveLengthComboBox.setEnabled(!this.isChannelActive);
        this.applyButton.setEnabled(!this.isChannelActive && this.isAuthUser);
    }

    private String convertPwrToString(int n) {
        return String.valueOf((double)n / 10.0);
    }

    private int convertStringToPwr(String string) {
        return (int)(Double.parseDouble(string) * 10.0);
    }

    @Override
    public void refresh() {
        this.applyButton.setEnabled(!this.isChannelActive && this.isAuthUser);
        this.resetModel();
    }

    public final void setDirty(boolean bl) {
        if (db.on()) {
            db.println("setDirty: " + this.getName() + ": " + this.isDirty + " -> " + bl);
        }
        this.isDirty = bl;
        if (this.applyButton != null) {
            this.applyButton.setEnabled(this.isDirty && this.isAuthUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void apply() {
        try {
            if (this.isDirty) {
                this.setCursor(3);
                this.updateModel();
                this.stopTableCellEditing();
                this.applyChangesToModel();
                this.setDirty(false);
            }
            EventBus.instance().notifyEvent((Object)this.getFullName(), (Object)APPLY);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.println("caught " + (Object)((Object)abstractCmsIOException) + " in Pane.apply");
            }
        }
        catch (EMCProvisionError eMCProvisionError) {
            if (db.on()) {
                db.println("caught " + (Object)((Object)eMCProvisionError) + " in Pane.apply");
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID(), (Object)eMCProvisionError.getEIDMsg());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    public void applyChangesToModel() throws Exception {
        this.setDirty(false);
    }

    private boolean isWxc80Port(AbstractOpticsLineModel abstractOpticsLineModel) throws NoSuchInterface, WrongInterfaceType {
        return abstractOpticsLineModel.getOptPortType() == OpticalPortType.COM_BIDI;
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: got CHANGED from " + observable.getClass());
        }
        this.getMaintenanceChanelPower(this.lineTxModel);
        this.resetModel();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
            this._obsMgr.setPassing(true);
        }
        return this._obsMgr;
    }
}

