/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.ConfigError;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IRamanModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RamanOpticsLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;
import org.omg.CORBA.UserException;

public class RamanSetupInfoTableModel
extends AbstractTableModel {
    private RamanOpticsLineModel[] lineModel;
    private boolean[] rowDirty;
    private static final int USER_LOGIN = 0;
    private static final int DATE_TIME = 1;
    private static final int STATUS = 2;
    private static final int S1LOW = 3;
    private static final int S1HIGH = 4;
    private static final int S2LOW = 5;
    private static final int S2HIGH = 6;
    private static final int RAMAN_POWER = 7;
    private static final int RAMAN_RATIO = 8;
    private static final int RAMAN_GAIN = 9;
    private static final int CALCULATED_TILT = 10;
    private static final int FIBER_CUT = 11;
    private static final int FIBER_CUT_DATE = 12;
    protected String[] columnNames = new String[]{"User", "Date", "Status", "S1Low (dBm)", "S1High (dBm)", "S2Low (dBm)", "S2High (dBm)", "Power (mW)", "Ratio", "Actual Gain", "Actual Tilt", "Fiber Cut Recovery", "Fiber Cut Date"};

    public RamanSetupInfoTableModel(RamanOpticsLineModel[] ramanOpticsLineModelArray) {
        this.lineModel = ramanOpticsLineModelArray;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = this.lineModel[n].getIndex();
        try {
            switch (n2) {
                case 0: {
                    return this.lineModel[n].getUserName();
                }
                case 1: {
                    String[] stringArray = this.lineModel[n].getInstallation();
                    return stringArray[3];
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return this.PowerLevel(this.lineModel[n].getNodeModel().getRamanModels(), n2, n3);
                }
                case 7: {
                    String[] stringArray = this.lineModel[n].getInstallation();
                    return stringArray[2];
                }
                case 9: {
                    return String.valueOf(this.lineModel[n].getActualGain());
                }
                case 8: {
                    String[] stringArray = this.lineModel[n].getInstallation();
                    return stringArray[1];
                }
                case 10: {
                    return String.valueOf(this.lineModel[n].getActualTilt());
                }
                case 2: {
                    return this.lineModel[n].getWizardResultStatus();
                }
                case 11: {
                    return this.lineModel[n].getFCResult();
                }
                case 12: {
                    return this.lineModel[n].getFCTimeStamp();
                }
            }
            return null;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
            return null;
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
            return null;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return null;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        catch (ConfigError configError) {
            SDebug.printStackTrace((Throwable)configError);
            return null;
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
            return null;
        }
    }

    private String PowerLevel(IRamanModel iRamanModel, int n, int n2) throws ConfigError, WrongInterfaceType, ProvisionError, NoSuchInterface {
        int n3 = -1000000;
        switch (n) {
            case 3: 
            case 4: {
                IRamanModel.RamanPowerMeasures ramanPowerMeasures = iRamanModel.getRamanParams(n2, 0);
                if (n == 3) {
                    n3 = ramanPowerMeasures.powerMinRamanLevel;
                    break;
                }
                n3 = ramanPowerMeasures.powerMaxRamanLevel;
                break;
            }
            case 5: 
            case 6: {
                IRamanModel.RamanPowerMeasures ramanPowerMeasures = iRamanModel.getRamanParams(n2, 1);
                n3 = n == 5 ? ramanPowerMeasures.powerMinRamanLevel : ramanPowerMeasures.powerMaxRamanLevel;
            }
        }
        if (n3 == -1000000) {
            return "N/A";
        }
        return ConvertPwrToDb.formatDecimalNumber(n3);
    }

    @Override
    public int getRowCount() {
        return this.lineModel.length;
    }
}

