/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ANSHelper
extends Model {
    private ANSNode droot;
    private NodeModelDelegate nodeModel;
    private Component parent;

    public ANSHelper(Component component, NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.nodeModel = nodeModelDelegate;
        this.parent = component;
        this.nodeModel.getANSManager().addObserver(this);
    }

    @Override
    public void dispose() {
        this.nodeModel.getANSManager().deleteObserver(this);
        super.dispose();
    }

    public boolean applyToNode(List<ANSElement> list) throws Exception {
        return this.applyToNode(null, list);
    }

    public boolean applyToNode() throws Exception {
        return this.applyToNode(this.droot, null);
    }

    private boolean applyToNode(ANSNode aNSNode, List<ANSElement> list) throws Exception {
        if (!CerentDialog.yesNoDialog((Component)this.parent, (String)"CAUTION: Changing parameters manually is not recommended.\nIncorrect changes will cause traffic loss.\nUse your DWDM network design application to recalculate\nthe node parameters, then import the new parameters into the node.\nDo you wish to continue?", (String)"Apply NE Update to Node")) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (aNSNode != null) {
            this.nodeModel.getANSManager().applyToNode(aNSNode, arrayList);
        } else {
            this.nodeModel.getANSManager().applyToNode(list, arrayList);
        }
        if (arrayList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("The following ANS parameters failed during the apply operation:\n");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next() + "\n");
            }
            throw new Exception(stringBuffer.toString());
        }
        CerentDialog.infoDialog((Component)this.parent, (String)"Note: After applying the changes,\nyou must run automatic node setup (ANS).", (String)"Apply NE Update to Node");
        return true;
    }

    public ANSNode getDefaultsRoot(boolean bl) throws Exception {
        if (this.droot == null || bl) {
            this.droot = this.nodeModel.getANSManager().getAnsParametersTree();
        }
        return this.droot;
    }

    public int showProperty(BufferedReader bufferedReader, String string) throws IOException {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        JTextArea jTextArea = new JTextArea();
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setText("Importing File " + string + "\n");
        jTextArea.append("Would you Continue?");
        JList<Object> jList = new JList<Object>(arrayList.toArray());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jTextArea, "North");
        jPanel.add(new JScrollPane(jList));
        jList.setVisibleRowCount(10);
        return JOptionPane.showOptionDialog(this.parent, jPanel, "Import Defaults", 2, 2, null, null, null);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }
}

