/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.ans.AbstractANSController;
import cerent.cms.ui.ans.AnsPathDataSource;
import cerent.cms.ui.ans.AnsPathTableModel;
import cerent.cms.ui.ans.IANSTreeViewPane;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class ANSResultController
extends AbstractANSController {
    private final AnsPathTableModel tableModel;
    private final AnsPathDataSource dataSource;

    public ANSResultController(IANSTreeViewPane iANSTreeViewPane, DwdmOpticalSetupModel dwdmOpticalSetupModel, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        super(iANSTreeViewPane, nodeModelDelegate, sDebug);
        this.dataSource = new AnsPathDataSource(dwdmOpticalSetupModel);
        this.tableModel = new AnsPathTableModel(this.dataSource, iANSTreeViewPane.getParentComponent());
    }

    @Override
    protected ANSNode getDefaultsRoot() throws Exception {
        return this.am.getAnsResultsTree();
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    public AnsPathDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setTableContent(TreePath treePath) {
        if (treePath != null) {
            ANSNode aNSNode = this.getANSNode(treePath);
            this.dataSource.setScope(this.am.getFilteredAnsResult(aNSNode));
        }
    }
}

