/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSValue;
import cerent.util.gui.HtmlLabelEditor;
import java.awt.Dimension;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ANSValueEditor {
    private JTextField textField = new JTextField();
    private JTextArea textArea = new JTextArea();
    private JComboBox comboBox = new JComboBox();
    private JScrollPane scrollTextArea = new JScrollPane(this.textArea);
    private HtmlLabelEditor htmlEditor;
    private int selector;

    public ANSValueEditor() {
        Dimension dimension = this.textField.getPreferredSize();
        dimension.width = 50;
        this.textField.setPreferredSize(dimension);
        this.textField.setHorizontalAlignment(4);
        this.textArea.setLineWrap(true);
        this.scrollTextArea.setHorizontalScrollBarPolicy(31);
    }

    public String getValue() {
        Object object = null;
        if (this.selector == 0 || this.selector == 6) {
            object = this.textField.getText();
        } else if (this.selector == 2 || this.selector == 5 || this.selector == 3) {
            object = this.comboBox.getSelectedItem();
        } else if (this.selector == 1) {
            object = this.textArea.getText();
        } else if (this.selector == 4) {
            object = this.htmlEditor.getText();
        }
        return object;
    }

    public JComponent initValue(ANSValue aNSValue) {
        this.selector = aNSValue.getDefElemClass();
        if (this.selector == 0 || this.selector == 6) {
            this.textField.setText(aNSValue.getValue());
            return this.textField;
        }
        if (this.selector == 2 || this.selector == 5 || this.selector == 3) {
            String[] stringArray = aNSValue.getValidEnumValues();
            this.comboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
            this.comboBox.setSelectedItem(aNSValue.getValue());
            return this.comboBox;
        }
        if (this.selector == 1) {
            this.textArea.setText(aNSValue.getValue());
            return this.scrollTextArea;
        }
        if (this.selector == 4) {
            if (this.htmlEditor == null) {
                this.htmlEditor = new HtmlLabelEditor();
            }
            this.htmlEditor.setText(aNSValue.getValue());
            return this.htmlEditor;
        }
        return null;
    }
}

