/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.ANSManager;
import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.ans.IANSController;
import cerent.cms.ui.ans.IANSTreeViewPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractANSController
extends AbstractRoDataSourceControl
implements Observer,
Runnable,
IANSController {
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_SCOPE = "scope";
    private static final ANSNode LOADING_DNODE = new ANSNode("Loading parameters...");
    private static final DefaultMutableTreeNode LOADING_TREE_NODE = new DefaultMutableTreeNode(LOADING_DNODE);
    private static final ANSNode ERROR_DNODE = new ANSNode("Error loading defaults");
    private static final DefaultMutableTreeNode ERROR_TREE_NODE = new DefaultMutableTreeNode(ERROR_DNODE);
    protected ANSNode droot;
    private DefaultTreeModel treeModel;
    private boolean disposed = false;
    private final SDebug dbg;
    protected final NodeModelDelegate nmd;
    protected final IANSTreeViewPane pane;
    protected final ANSManager am;
    private TableRefreshThread tableRefreshThread;

    public AbstractANSController(IANSTreeViewPane iANSTreeViewPane, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.nmd = nodeModelDelegate;
        this.dscObservableManager = new ObservableManager(this, true);
        this.am = ANSManager.getInstance(this.nmd);
        this.treeModel = new DefaultTreeModel(LOADING_TREE_NODE);
        this.dbg = sDebug;
        this.pane = iANSTreeViewPane;
    }

    public final TreeModel getTreeModel() {
        return this.treeModel;
    }

    protected void refreshPane(String string) {
        this.getTableModel().fireTableDataChanged();
        this.refreshTree((DefaultMutableTreeNode)this.treeModel.getRoot());
        this.pane.updateLabel(string);
    }

    protected final void refreshTree(TreeNode treeNode) {
        this.treeModel.nodeChanged(treeNode);
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.refreshTree(treeNode.getChildAt(i));
        }
    }

    protected abstract ANSNode getDefaultsRoot() throws Exception;

    public abstract void setTableContent(TreePath var1);

    public abstract AbstractTableModel getTableModel();

    @Override
    public final Component getParentComponent() {
        return this.pane.getParentComponent();
    }

    public final void refreshFromModel() throws Exception {
        if (this.tableRefreshThread == null || !this.tableRefreshThread.isAlive()) {
            this.tableRefreshThread = new TableRefreshThread(this);
        }
        if (this.tableRefreshThread.isAlive()) {
            this.tableRefreshThread.interrupt();
            this.tableRefreshThread = new TableRefreshThread(this);
            this.tableRefreshThread.start();
        } else {
            this.tableRefreshThread.start();
        }
    }

    @Override
    public void disposeDataSource() {
        this.disposed = true;
    }

    public final IObservableManager getObservableManager() {
        return this.dscObservableManager;
    }

    @Override
    public void update(Observable observable, Object object) {
        block2: {
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (!this.dbg.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        AbstractANSController abstractANSController = this;
        synchronized (abstractANSController) {
            if (!this.disposed) {
                this.pane.clearLabel();
                try {
                    this.droot = this.getDefaultsRoot();
                    DefaultMutableTreeNode defaultMutableTreeNode = this.createTree(this.droot);
                    this.treeModel.setRoot(defaultMutableTreeNode);
                    String string = Preferences.instance().getProperty(PROP_PREF, PROP_SCOPE, null);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                    if (string != null) {
                        defaultMutableTreeNode2 = this.getTreeRoot(defaultMutableTreeNode, string);
                    }
                    if (defaultMutableTreeNode2 == null) {
                        defaultMutableTreeNode2 = defaultMutableTreeNode;
                    }
                    this.pane.getTreeSelectionModel().setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
                    this.pane.updateLabel("node");
                }
                catch (Exception exception) {
                    this.setEditorContent(ERROR_TREE_NODE);
                    String string = "No reason available";
                    if (exception.getMessage() != null) {
                        string = exception.toString();
                    }
                    if (this.dbg.isSevereEnabled()) {
                        this.dbg.severe(string);
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayError((Component)((Object)this.pane.getParentComponent()), (EID)EMC.EID_ERROR_RETRIEVING_DEFAULTS_PARAM_1, (Object)string);
                }
            }
        }
    }

    public final void setEditorContent(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.droot = (ANSNode)defaultMutableTreeNode.getUserObject();
        this.treeModel.setRoot(defaultMutableTreeNode);
        this.pane.getTreeSelectionModel().clearSelection();
        this.pane.getTreeSelectionModel().setSelectionPath(new TreePath(defaultMutableTreeNode));
    }

    @Override
    public final void setDirty(ANSNode aNSNode) {
        this.pane.setDirty();
        this.updateTreeModel((DefaultMutableTreeNode)this.treeModel.getRoot(), aNSNode.getFullName());
    }

    private void updateTreeModel(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        this.treeModel.nodeChanged(defaultMutableTreeNode);
        int n = string.indexOf(46);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            ANSNode aNSNode = (ANSNode)defaultMutableTreeNode3.getUserObject();
            if (!aNSNode.getName().equals(string2)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 != null) {
            this.updateTreeModel(defaultMutableTreeNode2, string);
        }
    }

    private final String getTreeSelection() {
        TreePath treePath = this.pane.getTreeSelectionModel().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return ((ANSNode)defaultMutableTreeNode.getUserObject()).getFullName();
        }
        return "";
    }

    private DefaultMutableTreeNode getTreeRoot(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        String string2;
        int n = string.indexOf(46);
        if (n < 0) {
            string2 = string;
            string = null;
        } else {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            ANSNode aNSNode = (ANSNode)defaultMutableTreeNode3.getUserObject();
            if (!aNSNode.getName().equals(string2)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 != null && string != null) {
            return this.getTreeRoot(defaultMutableTreeNode2, string);
        }
        return defaultMutableTreeNode2;
    }

    @Override
    public final boolean isAuthorized() {
        return this.nmd.isUserAuthorized(SecurityLevel.SUPERUSER);
    }

    private DefaultMutableTreeNode createTree(ANSNode aNSNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(aNSNode);
        for (ANSNode aNSNode2 : aNSNode.getChildren()) {
            if (aNSNode2.isLeaf()) continue;
            defaultMutableTreeNode.add(this.createTree(aNSNode2));
        }
        return defaultMutableTreeNode;
    }

    protected final ANSNode getANSNode(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return (ANSNode)defaultMutableTreeNode.getUserObject();
    }

    private class TableRefreshThread
    extends Thread {
        public AbstractANSController ansController;

        public TableRefreshThread(AbstractANSController abstractANSController2) {
            this.ansController = abstractANSController2;
        }

        @Override
        public void run() {
            block3: {
                try {
                    Thread.sleep(300L);
                    String string = AbstractANSController.this.getTreeSelection();
                    Preferences.instance().setProperty(AbstractANSController.PROP_PREF, AbstractANSController.PROP_SCOPE, string);
                    AbstractANSController.this.setEditorContent(LOADING_TREE_NODE);
                    new Thread((Runnable)this.ansController, "ANS NE Update loader for " + AbstractANSController.this.nmd.getName()).start();
                }
                catch (InterruptedException interruptedException) {
                    if (!AbstractANSController.this.dbg.on()) break block3;
                    AbstractANSController.this.dbg.println("INTERRUPTED");
                }
            }
            if (AbstractANSController.this.dbg.on()) {
                AbstractANSController.this.dbg.println("EXIT");
            }
        }
    }
}

