/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.idl.OpticsTopology.eParamType;
import cerent.cms.idl.OpticsTopology.eSpectrumGranularity;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.model.ANS.ANSValue;
import cerent.cms.model.ANS.NodeANS;
import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.ParameterAlreadyPresent;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.AbstractPortSelectorAttr;
import cerent.cms.ui.CombosCellRenderer;
import cerent.cms.ui.WavelengthAttribute;
import cerent.cms.ui.ans.ANSValueEditor;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AnsAddParamDialog
extends UDialog {
    private JButton okButton;
    private JButton cancelButton;
    private ParamTypeAttr paramAttr;
    private PortSelectorAttr portAttr;
    private GranularityAttr granularityAttr;
    private ValueAttr valueAttr;
    private NodeANS.ANSParamDetails details;
    private NodeModelDelegate nm = null;
    protected static final SDebug db = new SDebug("AnsParamCreationDialog");
    private static final String DIALOG_TITLE = "Add Ans Parameter";

    public static AnsAddParamDialog instance(Frame frame, IModel iModel) {
        return new AnsAddParamDialog(frame, iModel);
    }

    private AnsAddParamDialog(Frame frame, IModel iModel) {
        super(frame, DIALOG_TITLE, true);
        if (db.on()) {
            db.println(((Object)((Object)this)).getClass().toString() + " AnsParamCreationDialog constructor");
        }
        this.nm = (NodeModelDelegate)iModel.getNodeModel();
        this.initMainPane(frame);
        this.paramAttr.initialize();
        this.setVisible(true);
    }

    protected void initMainPane(Frame frame) {
        if (db.on()) {
            db.println(((Object)((Object)this)).getClass().toString() + " initMainPane");
        }
        Container container = this.getContentPane();
        this.setSize(new Dimension(350, 520));
        container.setLayout(new BorderLayout());
        container.add((Component)this.getParamPanel(), "North");
        container.add((Component)this.getButtonPanel(), "South");
    }

    protected JPanel getButtonPanel() {
        if (db.on()) {
            db.println(((Object)((Object)this)).getClass().toString() + " getButtonPanel");
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnsAddParamDialog.this.ok();
            }
        });
        this.okButton.setEnabled(true);
        jPanel2.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnsAddParamDialog.this.dispose();
            }
        });
        this.cancelButton.setEnabled(true);
        jPanel2.add(this.cancelButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel getParamPanel() {
        if (db.on()) {
            db.println(((Object)((Object)this)).getClass().toString() + " getLocalePanel");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.paramAttr = new ParamTypeAttr();
        jPanel.add(this.paramAttr);
        this.portAttr = new PortSelectorAttr();
        jPanel.add(this.portAttr);
        this.granularityAttr = new GranularityAttr();
        jPanel.add(this.granularityAttr);
        this.valueAttr = new ValueAttr();
        jPanel.add(this.valueAttr);
        return jPanel;
    }

    public void dispose() {
        if (db.on()) {
            db.println(((Object)((Object)this)).getClass().toString() + " dispose");
        }
        super.dispose();
    }

    private void ok() {
        if (db.on()) {
            db.println(((Object)((Object)this)).getClass().toString() + " ok");
        }
        ANSValue aNSValue = this.details.getDefaultANSValue();
        try {
            String string = this.valueAttr.getValue();
            aNSValue.setValue(string);
            sParameterKey sParameterKey2 = new sParameterKey();
            sParameterKey2.paramLocation = this.portAttr.getPortIndex();
            sParameterKey2.type = this.paramAttr.getSelectedParamType();
            sParameterKey2.spectrum = this.granularityAttr.getSelectedSpectrumType();
            sParameterKey2.spectrumIndex = this.granularityAttr.getSpectrumIndex();
            this.nm.getANSManager().getNeANSModel().addParameter(sParameterKey2, aNSValue.getIntValue());
            this.dispose();
            CerentDialog.infoDialog((Component)((Object)this), (String)"Note: After adding new parameter,\nyou must run automatic node setup (ANS).", (String)"Apply NE Update to Node");
        }
        catch (ProvisionError provisionError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)provisionError.getEID(), (Object[])provisionError.getEIDParams());
            aNSValue.resetValue();
            this.valueAttr.init(aNSValue);
        }
        catch (NoSuchEquipment noSuchEquipment) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_NO_SUCHINTERFACE, "error to be managed here");
        }
        catch (ParameterAlreadyPresent parameterAlreadyPresent) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)parameterAlreadyPresent);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_WDMANS_PARAM_PRESENT);
        }
        catch (InvalidParams invalidParams) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)invalidParams);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_WDMANS_PARAM_INVALID);
        }
    }

    protected void initContentPane(JPanel jPanel, Object object) {
    }

    private void updateParamDetails(NodeANS.ANSParamDetails aNSParamDetails) {
        db.info("updateParamDetails with: " + aNSParamDetails);
        this.details = aNSParamDetails;
        this.portAttr.initialize();
        this.granularityAttr.setVisible(aNSParamDetails.hasGranularity());
        this.valueAttr.init(aNSParamDetails.getDefaultANSValue());
    }

    private abstract class AttributeSelectorAttr
    extends JPanel {
        private DefaultComboBoxModel model;
        private JComboBox cb;
        protected GridBagConstraints gc;

        AttributeSelectorAttr(String string, Attribute[] attributeArray, int n) {
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.setLayout(new GridBagLayout());
            this.gc = new GridBagConstraints();
            this.gc.gridx = 0;
            this.gc.gridy = 0;
            this.gc.fill = 0;
            this.gc.insets = new Insets(5, 5, 0, 0);
            this.gc.anchor = 11;
            this.model = new DefaultComboBoxModel<Attribute>(attributeArray);
            this.cb = new JComboBox(this.model);
            if (n != 0) {
                Dimension dimension = this.cb.getPreferredSize();
                dimension.width = n;
                this.cb.setPreferredSize(dimension);
                this.cb.setMinimumSize(dimension);
            }
            this.add((Component)this.cb, this.gc);
        }

        int getSelectedItem() {
            Attribute attribute = (Attribute)this.cb.getSelectedItem();
            if (attribute != null) {
                return attribute.getIntValue();
            }
            return -1;
        }

        void setSelectedItem(int n) {
            for (int i = 0; i < this.model.getSize(); ++i) {
                Attribute attribute = (Attribute)this.model.getElementAt(i);
                if (attribute.getIntValue() != n) continue;
                this.cb.setSelectedIndex(i);
            }
        }

        JComboBox getCB() {
            return this.cb;
        }
    }

    private class GranularityAttr
    extends AttributeSelectorAttr {
        private WavelengthAttribute wlenAttr;

        GranularityAttr() {
            super("Granularity: ", NodeANS.getAllSpectrumGranularities(), 70);
            this.wlenAttr = new WavelengthAttribute();
            this.gc.anchor = 15;
            this.gc.gridy = 1;
            this.add((Component)this.wlenAttr.getUI(), this.gc);
            this.getCB().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GranularityAttr.this.update();
                }
            });
        }

        private void update() {
            IEntityModel iEntityModel = AnsAddParamDialog.this.portAttr.getPort();
            if (iEntityModel != null) {
                this.update(iEntityModel);
            }
        }

        private void updatePort(IEntityModel iEntityModel) {
            this.setVisible(AnsAddParamDialog.this.details.hasGranularity(iEntityModel));
            this.update(iEntityModel);
        }

        private void update(IEntityModel iEntityModel) {
            db.info("update(), new port is: " + iEntityModel);
            db.info("update(), detail is: " + AnsAddParamDialog.this.details);
            int n = iEntityModel.getEqType();
            boolean bl = false;
            switch (n) {
                case 304: 
                case 305: 
                case 307: {
                    bl = this.getSelectedItem() != 1;
                    break;
                }
            }
            if (bl && iEntityModel instanceof OpticsPortModel) {
                try {
                    OpticsPortModel opticsPortModel = (OpticsPortModel)iEntityModel;
                    int n2 = opticsPortModel.getWavelengthBand();
                    int n3 = opticsPortModel.getWavelengthOddity();
                    int n4 = opticsPortModel.getNumberOfWavelengths();
                    db.info("change wavelenghts with params: " + opticsPortModel.getBandString() + "-" + opticsPortModel.getGridString() + "-" + n4);
                    this.wlenAttr.setBandAndOddity(n2, n3, n4);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (bl != this.wlenAttr.getUI().isVisible()) {
                db.info("update wavelenghts visibility to: " + bl);
                this.wlenAttr.getUI().setVisible(bl);
                this.updateUI();
            }
        }

        private void initialize(IEntityModel iEntityModel) {
            this.setSelectedItem(AnsAddParamDialog.this.details.getDefaultGranularityForPort(iEntityModel).value());
        }

        int getSpectrumIndex() {
            if (this.isVisible() && this.wlenAttr.getUI().isVisible()) {
                return this.wlenAttr.getChannel();
            }
            if (this.getSelectedSpectrumType().equals(eSpectrumGranularity.SP_OCH)) {
                return AnsAddParamDialog.this.details.getDefaultSpectrumIndex(AnsAddParamDialog.this.portAttr.getPort());
            }
            return 0;
        }

        eSpectrumGranularity getSelectedSpectrumType() {
            if (this.isVisible()) {
                return eSpectrumGranularity.from_int(this.getSelectedItem());
            }
            if (AnsAddParamDialog.this.details.isPortParam()) {
                return AnsAddParamDialog.this.details.getDefaultGranularityForPort(AnsAddParamDialog.this.portAttr.getPort());
            }
            return eSpectrumGranularity.SP_UNKNOWN;
        }

        @Override
        public void setVisible(boolean bl) {
            IEntityModel iEntityModel;
            db.info("Granularity::setVisible(): " + bl);
            super.setVisible(bl);
            if (bl && (iEntityModel = AnsAddParamDialog.this.portAttr.getPort()) != null) {
                this.initialize(iEntityModel);
            }
        }
    }

    private class ParamTypeAttr
    extends AttributeSelectorAttr {
        ParamTypeAttr() {
            super("Parameter: ", NodeANS.getAllParamTypes(), 0);
            this.getCB().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NodeANS.ANSParamDetails aNSParamDetails = NodeANS.getANSParamDetails(ParamTypeAttr.this.getSelectedParamType());
                    if (aNSParamDetails != null) {
                        AnsAddParamDialog.this.updateParamDetails(aNSParamDetails);
                    }
                }
            });
        }

        eParamType getSelectedParamType() {
            return eParamType.from_int(this.getSelectedItem());
        }

        void initialize() {
            this.getCB().setSelectedIndex(0);
        }
    }

    private class PortSelectorAttr
    extends AbstractPortSelectorAttr {
        PortSelectorAttr() {
            super(AnsAddParamDialog.this.nm, "Port Selection", new CombosCellRenderer());
        }

        @Override
        protected boolean isCardSelectorNeeded() {
            return true;
        }

        @Override
        protected boolean isMPOSelectorNeeded() {
            return false;
        }

        @Override
        protected boolean isPortSelectorNeeded() {
            return true;
        }

        @Override
        protected boolean isSideSelectorNeeded() {
            return false;
        }

        @Override
        protected void notifyPortSelected(IEntityModel iEntityModel) {
            db.info("notifyPortSelected() with: " + iEntityModel);
            if (iEntityModel != null && AnsAddParamDialog.this.granularityAttr != null) {
                AnsAddParamDialog.this.granularityAttr.updatePort(iEntityModel);
            }
        }

        public int getPortIndex() {
            if (this.isVisible()) {
                return this.getPort().getEntityIndex();
            }
            return 0;
        }

        void initialize() {
            db.info("initialize() with: " + AnsAddParamDialog.this.details);
            if (AnsAddParamDialog.this.details.isNodeParam()) {
                this.setVisible(false);
            } else if (AnsAddParamDialog.this.details.isPortParam()) {
                this.setVisible(true);
                this.loadAllPorts(AnsAddParamDialog.this.details.getOpticalPorts(AnsAddParamDialog.this.nm));
                this.notifyPortSelected(this.getPort());
            }
        }
    }

    private class ValueAttr
    extends JPanel {
        private ANSValueEditor editor;
        private JComponent valueAttr;
        private JLabel label;

        ValueAttr() {
            super(new FlowLayout(1, 5, 5));
            this.editor = new ANSValueEditor();
            this.valueAttr = null;
            this.setBorder(BorderFactory.createTitledBorder("Value: "));
            this.label = new JLabel();
        }

        void init(ANSValue aNSValue) {
            db.info("init() value: " + aNSValue);
            JComponent jComponent = this.editor.initValue(aNSValue);
            if (this.valueAttr != null) {
                this.removeAll();
            }
            this.valueAttr = jComponent;
            this.add(this.valueAttr);
            String string = "";
            if (aNSValue.getUnits().length() > 0) {
                string = string + " (" + aNSValue.getUnits() + ")";
            }
            if (aNSValue.getValidRange().length() > 0) {
                string = string + " [" + aNSValue.getValidRange() + "]";
            }
            this.label.setText(string);
            this.add(this.label);
            this.updateUI();
        }

        String getValue() {
            return this.editor.getValue();
        }
    }
}

