/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Busy;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.ui.ans.AnsConnTableModel;
import cerent.util.AnnotatedException;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnsConnDataSource
extends AbstractRowDataSource
implements IObserver {
    private OpticalPatchCordModel optPatchCordModel = null;
    private NodeModelDelegate nmd = null;
    private List<IOptLinkModel> optLinkList = new ArrayList<IOptLinkModel>();
    private static final SDebug db = new SDebug("AnsConnDataSource");
    private boolean mpoFilter;

    public AnsConnDataSource(OpticalPatchCordModel opticalPatchCordModel) {
        this.optPatchCordModel = opticalPatchCordModel;
        this.nmd = (NodeModelDelegate)opticalPatchCordModel.getNodeModel();
    }

    public void init(boolean bl) {
        this.getOpticalLinkList(bl);
        if (this.nmd != null && this.optPatchCordModel != null) {
            this.optPatchCordModel.addObserver(this);
        }
    }

    private void regToLinkForEvent(IOptLinkModel iOptLinkModel) {
        if (iOptLinkModel != null) {
            iOptLinkModel.addObserver((IObserver)this);
        }
    }

    private void unRegToLinkForEvent(IOptLinkModel iOptLinkModel) {
        if (iOptLinkModel != null) {
            iOptLinkModel.deleteObserver((IObserver)this);
        }
    }

    private synchronized void removePatchFromList(IOptLinkModel iOptLinkModel) {
        int n = this.optLinkList.indexOf(iOptLinkModel);
        if (n != -1) {
            if (db.on()) {
                db.println("Patch found. Index :" + iOptLinkModel.getIndex());
            }
            this.optLinkList.remove(n);
        } else if (db.on()) {
            db.println("Patch not found. Index :" + iOptLinkModel.getIndex());
        }
    }

    private void removeAllObservers() {
        IOptLinkModel[] iOptLinkModelArray = this.optLinkList.toArray(new IOptLinkModel[0]);
        for (int i = 0; i < iOptLinkModelArray.length; ++i) {
            this.unRegToLinkForEvent(iOptLinkModelArray[i]);
        }
        if (this.nmd != null && this.optPatchCordModel != null) {
            this.optPatchCordModel.deleteObserver(this);
        }
    }

    public void updateTable() {
        this.fireDataSourceChanged();
    }

    public void deleteOptLink(IOptLinkModel iOptLinkModel) throws AnnotatedException, Busy {
        Exception exception = null;
        try {
            iOptLinkModel.delete();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception != null) {
            if (exception instanceof Busy) {
                throw new Busy("The optical line could not be deleted. Patch-cord is in use");
            }
            throw new AnnotatedException("The optical line could not be deleted.", exception);
        }
    }

    public void deleteOptLink(AnsConnTableModel ansConnTableModel, int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        ArrayList<IOptLinkModel> arrayList = new ArrayList<IOptLinkModel>();
        for (int i = 0; i < nArray.length; ++i) {
            IOptLinkModel iOptLinkModel = (IOptLinkModel)ansConnTableModel.getValueAt(nArray[i], 0);
            arrayList.add(iOptLinkModel);
        }
        for (IOptLinkModel iOptLinkModel : arrayList) {
            try {
                iOptLinkModel.delete();
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Unable to removeOpticalLink: " + exception);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOpticalLinkList(boolean bl) {
        if (bl != this.mpoFilter) {
            this.mpoFilter = bl;
            this.optLinkList.clear();
        }
        try {
            IOptLinkModel[] iOptLinkModelArray = this.optPatchCordModel.getAllOptLinkModel(bl);
            for (int i = 0; i < iOptLinkModelArray.length; ++i) {
                if (this.optLinkList.indexOf(iOptLinkModelArray[i]) != -1) continue;
                IOptLinkModel iOptLinkModel = iOptLinkModelArray[i];
                this.optLinkList.add(iOptLinkModel);
                this.regToLinkForEvent(iOptLinkModel);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.finest("Exception in getOpticalLinkList() " + (Object)((Object)abstractCmsIOException));
        }
        finally {
            this.updateTable();
        }
    }

    public void dispose() {
        if (db.on()) {
            db.println("AnsConndataSource Dispose");
        }
        this.removeAllObservers();
        this.optLinkList.clear();
    }

    public void update(IObservable iObservable, Object object) {
        block15: {
            block16: {
                block14: {
                    if (!(iObservable instanceof OpticalPatchCordModel)) break block14;
                    int n = (Integer)object;
                    switch (n) {
                        case 2: {
                            if (db.on()) {
                                db.println("Object added");
                            }
                            this.getOpticalLinkList(this.mpoFilter);
                            break;
                        }
                        default: {
                            if (db.on()) {
                                db.println("Event not handled from OpticalPatchCordModel.");
                                db.println("Args: " + object);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block15;
                }
                if (!(iObservable instanceof IOptLinkModel)) break block16;
                int n = (Integer)object;
                switch (n) {
                    case 0: {
                        if (db.on()) {
                            db.println("Object Deleted.");
                        }
                        this.unRegToLinkForEvent((IOptLinkModel)iObservable);
                        this.removePatchFromList((IOptLinkModel)iObservable);
                        break;
                    }
                    case 1: {
                        int n2;
                        if (db.on()) {
                            db.println("Object Changed.");
                        }
                        if ((n2 = this.optLinkList.indexOf(iObservable)) != -1) {
                            this.fireRowsUpdated(n2, n2);
                            break;
                        }
                        break block15;
                    }
                    default: {
                        if (db.on()) {
                            db.println("Event not handled for AnsConnDataSource from OptLinkModel.");
                            db.println("Args: " + object);
                            break;
                        }
                        break block15;
                    }
                }
                break block15;
            }
            if (db.on()) {
                db.println("Event not handled for AnsConnDataSource from " + iObservable);
                db.println("Args: " + object);
            }
        }
        this.updateTable();
    }

    public Object getObjectAtRow(int n) {
        return this.optLinkList.get(n);
    }

    public int getRowCount() {
        return this.optLinkList.size();
    }

    public Collection getAllObjects() {
        return this.optLinkList;
    }
}

