/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ctx;

import cerent.cms.model.AbstractCtxModuleModel;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.TreeMap;

public abstract class AbstractCtxCardTabbedView
extends PluggableCardTabbedView {
    protected ArrayList ocnLinesList;

    public AbstractCtxCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
    }

    @Override
    protected void init() {
        super.init();
        TdmLineModel[] tdmLineModelArray = ((AbstractCtxModuleModel)this.getUiModel()).getOpticalLines();
        this.ocnLinesList = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray));
        this.getOM().addObservable((Observable[])tdmLineModelArray);
        this._interfaceContainers = Collections.synchronizedMap(new TreeMap());
        this.addContainers(this.getPpmModelsArray());
    }

    protected void addContainers(IPortContainer[] iPortContainerArray) {
        for (int i = 0; i < iPortContainerArray.length; ++i) {
            IPortContainer iPortContainer = iPortContainerArray[i];
            Iterator iterator = iPortContainer.getContainedPorts().iterator();
            while (iterator.hasNext()) {
                try {
                    this.addContainer(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    db.println("Caught exception in addContainers()!");
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
            }
        }
    }

    protected IPortContainer removeContainer(IInterfaceModel iInterfaceModel) {
        return (IPortContainer)this._interfaceContainers.remove(iInterfaceModel);
    }

    private void addContainer(IInterfaceModel iInterfaceModel, IPortContainer iPortContainer) {
        this._interfaceContainers.put(iInterfaceModel, iPortContainer);
    }

    protected TdmLineModel[] getOcnLinesArray() {
        return this.ocnLinesList.toArray(new TdmLineModel[this.ocnLinesList.size()]);
    }

    @Override
    protected List addModel(Observable observable) {
        List list = super.addModel(observable);
        if (observable instanceof PpmModel) {
            this.addContainers(this.getPpmModelsArray());
            Model[] modelArray = ((AbstractCtxModuleModel)this.getUiModel()).getOpticalLines();
            this.ocnLinesList = new ArrayList<TdmLineModel>(Arrays.asList(modelArray));
            this.getOM().addObservable((Observable[])modelArray);
            list.add(new OcnLineUpdate(modelArray, (IPortContainer)((Object)observable)));
        }
        return list;
    }

    @Override
    public void destroy() {
        this.ocnLinesList.clear();
        super.destroy();
    }
}

