/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dis;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.dis.DisInfo;
import cerent.cms.ui.dis.DisInformation;
import cerent.cms.ui.dis.SignatureInfo;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.List;

public class DisInfoDataSource
extends AbstractRowDataSource
implements IJobListener {
    private static DisInfoDataSource instance;
    private DisInformation disInformation;
    private List<DisInfo> disInfoList = new ArrayList<DisInfo>();
    private static String orgName;
    private static String orgUnit;
    private static String serNum;
    private static String cmnName;
    private static String hashAlg;
    private static String imgType;
    private static String keyVer;
    private static String signAlg;
    private static String WORKING;
    private static String PROTECT;

    private DisInfoDataSource() {
    }

    public static DisInfoDataSource instance() {
        if (instance == null) {
            instance = new DisInfoDataSource();
        }
        return instance;
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public Object getObjectAtRow(int n) {
        return this.disInfoList.size() > 0 ? this.disInfoList.get(n) : null;
    }

    public int getRowCount() {
        return this.disInfoList.size();
    }

    public void retrieveAllInfos(NodeModelDelegate nodeModelDelegate, int n) {
        if (this.disInformation == null) {
            this.disInformation = new DisInformation(nodeModelDelegate);
        }
        List<SignatureInfo> list = this.disInformation.getSignatureInformation(n);
        this.disInfoList = this.createDisInfos(list);
    }

    private List<DisInfo> createDisInfos(List<SignatureInfo> list) {
        SignatureInfo signatureInfo = null;
        SignatureInfo signatureInfo2 = null;
        ArrayList<DisInfo> arrayList = new ArrayList<DisInfo>();
        if (list.size() == 2) {
            if (list.get(0).getKeyInfoType().equals(WORKING)) {
                signatureInfo = list.get(0);
                signatureInfo2 = list.get(1);
            } else {
                signatureInfo = list.get(1);
                signatureInfo2 = list.get(0);
            }
            arrayList.add(new DisInfo(orgName, signatureInfo == null ? "" : signatureInfo.getOrganizationName(), signatureInfo2 == null ? "" : signatureInfo2.getOrganizationName()));
            arrayList.add(new DisInfo(orgUnit, signatureInfo == null ? "" : signatureInfo.getOrganizationUnit(), signatureInfo2 == null ? "" : signatureInfo2.getOrganizationUnit()));
            arrayList.add(new DisInfo(serNum, signatureInfo == null ? "" : String.valueOf(signatureInfo.getCertificateSerialNumber()), signatureInfo2 == null ? "" : String.valueOf(signatureInfo2.getCertificateSerialNumber())));
            arrayList.add(new DisInfo(cmnName, signatureInfo == null ? "" : signatureInfo.getCommonName(), signatureInfo2 == null ? "" : signatureInfo2.getCommonName()));
            arrayList.add(new DisInfo(hashAlg, signatureInfo == null ? "" : signatureInfo.getHashAlgorithm(), signatureInfo2 == null ? "" : signatureInfo2.getHashAlgorithm()));
            arrayList.add(new DisInfo(imgType, signatureInfo == null ? "" : signatureInfo.getImageType(), signatureInfo2 == null ? "" : signatureInfo2.getImageType()));
            arrayList.add(new DisInfo(keyVer, signatureInfo == null ? "" : signatureInfo.getKeyVersion(), signatureInfo2 == null ? "" : signatureInfo2.getKeyVersion()));
            arrayList.add(new DisInfo(signAlg, signatureInfo == null ? "" : signatureInfo.getSignAlgorithm(), signatureInfo2 == null ? "" : signatureInfo2.getSignAlgorithm()));
        }
        return arrayList;
    }

    public void destroy() {
        instance = null;
    }

    static {
        orgName = "Organization Name";
        orgUnit = "Organization Unit";
        serNum = "Serial Number";
        cmnName = "Common Name";
        hashAlg = "Hash Algorithm";
        imgType = "Image Type";
        keyVer = "Key Version";
        signAlg = "Sign Algorithm";
        WORKING = "Working";
        PROTECT = "Protect";
    }
}

