/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dis;

import cerent.cms.model.ChassisModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dis.DisInfoDataSource;
import cerent.cms.ui.dis.DisInfoTableModel;
import cerent.cms.ui.dis.SignatureInfo;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;

public class DisInfoPane
extends AbstractPane
implements ActionListener {
    private NodeModelDelegate nmd;
    private static final String RETRIEVE_ALL = "Retrieve Signature Information";
    private static final String REFRESH_ALL = "Refresh Signature Information";
    private static final String RETRIEVE_SIG_TIP = "Retrieves all the information about signature of nodes digital image";
    protected JButton retrieveButton;
    private SignatureInfo sigInfo;
    private JTextArea orgName;
    private JPanel sigInfopane;
    private JTextArea orgUnit;
    private JTextArea serNum;
    private JTextArea cmnName;
    private JTextArea hshAlg;
    private JTextArea imgType;
    private JTextArea keyVersion;
    private JTextArea signAlg;
    private DisInfoDataSource dataSource;
    private DisInfoTableModel tableModel;
    private int shelfId = -1;

    public DisInfoPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        if (this.uiModel != null) {
            this.nmd = (NodeModelDelegate)this.uiModel.getNodeModel();
        }
        if (this.uiModel instanceof IChassisModel) {
            this.shelfId = ((ChassisModel)this.uiModel).getShelfId();
        }
        this.setLayout(new BorderLayout());
        this.add(this.makeButtonPanel(), "South");
        this.add(this.makeSigInfoPanel(), "Center");
    }

    private Component makeSigInfoPanel() {
        if (this.uiModel != null) {
            this.nmd = (NodeModelDelegate)this.uiModel.getNodeModel();
        }
        this.dataSource = DisInfoDataSource.instance();
        this.tableModel = new DisInfoTableModel(this.dataSource);
        this.table = new UTable((TableModel)((Object)this.tableModel));
        ((DisInfoTableModel)((Object)this.table.getModel())).initTable(this.table);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        return uScrollPane;
    }

    public void createRowEntry(String string, JTextArea jTextArea) {
        this.sigInfopane.add(new JLabel(string));
        jTextArea.setEditable(false);
        this.sigInfopane.add(jTextArea);
    }

    private Component makeButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        this.retrieveButton = this.makeActionButton(RETRIEVE_ALL);
        this.retrieveButton.setToolTipText(RETRIEVE_SIG_TIP);
        jPanel2.add(this.retrieveButton);
        jPanel.add((Component)jPanel2, "West");
        CSHelpID cSHelpID = this.getHelpID();
        jPanel3.add(new CSHelpButton(cSHelpID));
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string, null);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    public void enteringPage() throws Exception {
    }

    @Override
    public void refresh() throws Exception {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.retrieveButton && this.nmd != null) {
            this.retrieveButton.setEnabled(false);
            DisInfoDataSource.instance().retrieveAllInfos(this.nmd, this.shelfId);
            this.table.updateUI();
            if (this.tableModel.getRowCount() > 0) {
                this.retrieveButton.setText(REFRESH_ALL);
            } else {
                this.retrieveButton.setText(RETRIEVE_ALL);
            }
            this.retrieveButton.setEnabled(true);
            this.retrieveButton.updateUI();
        }
    }

    @Override
    public void destroy() {
        this.dataSource.destroy();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.DisInfoPane;
    }
}

