/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dis;

import cerent.cms.model.ChassisModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dis.DisKeyTableModel;
import cerent.cms.ui.dis.DisKeysDataSource;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class DisKeyPane
extends AbstractPane
implements ActionListener {
    private NodeModelDelegate nmd;
    private DisKeysDataSource dataSource;
    private DisKeyTableModel tableModel;
    private static final String RETRIEVE_ALL = "Retrieve All Keys";
    private static final String REFRESH_ALL = "Refresh All Keys";
    private static final String RETRIEVE_KEYS_TIP = "Retrieves information about all the public keys such as Releasedevelopment key";
    protected JButton retrieveButton;
    private int shelfId = -1;

    public DisKeyPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        if (this.uiModel != null) {
            this.nmd = (NodeModelDelegate)this.uiModel.getNodeModel();
        }
        if (this.uiModel instanceof IChassisModel) {
            this.shelfId = ((ChassisModel)this.uiModel).getShelfId();
        }
        this.dataSource = DisKeysDataSource.instance();
        this.tableModel = new DisKeyTableModel(this.dataSource);
        this.table = new UTable((TableModel)((Object)this.tableModel));
        this.table.setRowHeight(512);
        ((DisKeyTableModel)((Object)this.table.getModel())).initTable(this.table);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
        this.add(this.makeButtonPanel(), "South");
        this.add((Component)uScrollPane, "Center");
    }

    private Component makeButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        this.retrieveButton = this.makeActionButton(RETRIEVE_ALL);
        this.retrieveButton.setToolTipText(RETRIEVE_KEYS_TIP);
        jPanel2.add(this.retrieveButton);
        jPanel.add((Component)jPanel2, "West");
        CSHelpID cSHelpID = this.getHelpID();
        jPanel3.add(new CSHelpButton(cSHelpID));
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string, null);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    public void enteringPage() throws Exception {
    }

    @Override
    public void refresh() throws Exception {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.retrieveButton) {
            this.retrieveButton.setEnabled(false);
            DisKeysDataSource.instance().retrieveAllKeys(this.nmd, this.shelfId);
            this.table.updateUI();
            if (this.tableModel.getRowCount() > 0) {
                this.retrieveButton.setText(REFRESH_ALL);
            } else {
                this.retrieveButton.setText(RETRIEVE_ALL);
            }
            this.retrieveButton.setEnabled(true);
            this.retrieveButton.updateUI();
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.DisKeyPane;
    }

    @Override
    public void destroy() {
        this.dataSource.destroy();
    }
}

