/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.download;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class DelayedUpgradeDialog
extends JDialog
implements ActionListener {
    private static final String TITLE = "Software Activation";
    private static final String OK = "OK";
    private static final int MARGIN = 5;
    private JButton okButton;
    private JCheckBox chkDelayedUpgrade;
    private INodeModel nodeModel;
    private boolean ok = false;
    private static final SDebug db = new SDebug("DelayedUpgradeDialog");

    public DelayedUpgradeDialog(Component component, INodeModel iNodeModel) {
        super(JOptionPane.getFrameForComponent(component), TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DelayedUpgradeDialog.this.dispose();
            }
        });
        this.nodeModel = iNodeModel;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getChoicePanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(component);
        this.setVisible(true);
    }

    private JPanel getChoicePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String string = "   Activation to the new version will reset each card in the node.\n   The reset will affect traffic on the ML cards.   If needed, you can\n   delay any ML card activation, for example, to coordinate the\n   upgrade of an RPR ring.\n \n   If you delay ML card activation, you must manually reset these\n   cards to complete the activation.  You will not be able to provision\n   the node until the activation is complete.\n \n";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jLabel.setIcon(CerentDialog.INFO_ICON);
        jLabel.setVerticalTextPosition(1);
        jLabel.setHorizontalTextPosition(4);
        boolean bl = this.nodeModel.getDelayedUpgradeModel().getDefaultDelayedUpgrades();
        if (db.on()) {
            db.println("DefaultDelayedUpgrades=" + bl);
        }
        this.chkDelayedUpgrade = new JCheckBox("Delay automatic activation on the ML cards");
        if (bl) {
            this.chkDelayedUpgrade.setSelected(true);
        } else {
            this.chkDelayedUpgrade.setSelected(false);
        }
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.chkDelayedUpgrade, "South");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.ok = true;
            try {
                if (this.nodeModel.provides(Feature.ML_VERSION_UP)) {
                    this.nodeModel.getDelayedUpgradeModel().setEnableDelayedUpgrade(this.chkDelayedUpgrade.isSelected());
                } else if (db.on()) {
                    db.println("Error: node=" + this.nodeModel.getName() + " doesn't support ML_VERSION_UP");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.dispose();
    }

    boolean isOk() {
        return this.ok;
    }
}

