/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds123;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Ds123Media.sThresholds;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ds3xmLineUpdate;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NotT1403Mode;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.GeneralPmThresholdsPane;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds123.Ds123PmThresholdsTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Ds123PmThresholdsPane
extends GeneralPmThresholdsPane
implements TableModelListener {
    protected Ds123PmThresholdsTableModel dataModel;
    protected Ds123LineModel[] lineModels;
    protected Ds123ModuleModel eqpmtModel;
    protected eThresholdType thresholdType;
    protected boolean nearEnd;
    protected int numLines;
    private CSHelpID helpID = null;
    private static final SDebug db = new SDebug("Ds123PmThresholdsPane");

    public Ds123PmThresholdsPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, eThresholdType eThresholdType2, boolean bl, CSHelpID cSHelpID) {
        super(string, tabbedView);
        this.nearEnd = bl;
        this.helpID = cSHelpID;
        TableColumn tableColumn = null;
        this.lineModels = ds123LineModelArray;
        this.thresholdType = eThresholdType2;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        this.initialize();
        this.numLines = this.lineModels != null ? this.lineModels.length : 0;
        this.registerWithModel();
        this.add((Component)uScrollPane);
    }

    public Ds123PmThresholdsPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, eThresholdType eThresholdType2, CSHelpID cSHelpID) {
        this(string, tabbedView, ds123LineModelArray, eThresholdType2, false, cSHelpID);
    }

    protected void initialize() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(5));
        this.table.removeColumn(tableColumn);
        --this.dataModel.numCols;
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
        this.table.removeColumn(tableColumn);
        --this.dataModel.numCols;
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(7));
        this.table.removeColumn(tableColumn);
        --this.dataModel.numCols;
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(8));
        this.table.removeColumn(tableColumn);
        --this.dataModel.numCols;
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(9));
        this.table.removeColumn(tableColumn);
        --this.dataModel.numCols;
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
        this.table.removeColumn(tableColumn);
        --this.dataModel.numCols;
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(11));
        this.table.removeColumn(tableColumn);
        --this.dataModel.numCols;
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(12));
        this.table.removeColumn(tableColumn);
        --this.dataModel.numCols;
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(13));
        this.table.removeColumn(tableColumn);
        --this.dataModel.numCols;
    }

    protected Ds123PmThresholdsTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new Ds123PmThresholdsTableModel(iNodeModel, this.lineModels, 1, this.thresholdType, true);
    }

    @Override
    protected ResettablePmThresholdsTableModel dataModel() {
        return this.dataModel;
    }

    @Override
    protected void registerWithModel() {
        super.registerWithModel();
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    public void unregisterWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void dispose() {
        this.unregisterWithModel();
        super.dispose();
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    protected Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                Ds123PmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (db.on()) {
                db.info("Received Ds3LineUpdate...");
            }
            this.unregisterWithModel();
            this.lineModels = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
            this.numLines = this.lineModels.length;
            this.registerWithModel();
            this.dataModel.refreshMyLines(this.lineModels);
        } else if (object instanceof Ds3xmLineUpdate) {
            if (db.on()) {
                db.info("Received Ds3xmLineUpdate...");
            }
            this.lineModels = ((Ds3xmLineUpdate)object).getFilteredDs3s();
            this.numLines = this.lineModels.length;
            this.dataModel.refreshMyLines(this.lineModels);
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In Ds123PmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void applyChangesToModel() throws NoSuchInterface, WrongInterfaceType, NotT1403Mode, ConfigError, UnsupportedOperation {
        int n = 0;
        for (n = 0; n < this.numLines; ++n) {
            if (db.on()) {
                db.println("setting at iteration " + n);
            }
            if (!this.dataModel.isRowDirty(n)) continue;
            this.printThresholds(this.dataModel.getThresholdsVal(n));
            this.lineModels[n].setPmThresholds(true, this.thresholdType, this.dataModel.getThresholdsVal(n));
        }
        this.dataModel.resetDirtyBits();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        if (db.on()) {
            db.println("Got table changed");
        }
        int n = tableModelEvent.getLastRow() > this.numLines - 1 ? this.numLines - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            if (db.on()) {
                db.println("Setting dirty");
            }
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    @Override
    public void enteringPage() {
        this.refresh();
    }

    @Override
    public void leavingPage() {
        if (null != this.table && this.table.isEditing()) {
            this.table.editingCanceled(new ChangeEvent(this.table));
        }
        try {
            super.leavingPage();
        }
        catch (Exception exception) {
            db.println("Caught exception in leavingPage");
            SDebug.printStackTrace((Throwable)exception);
            this.refresh();
        }
    }

    @Override
    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void printThresholds(sThresholds sThresholds2) {
        if (db.on()) {
            db.println("===============================================");
            db.println("CV " + sThresholds2.cv);
            db.println("ES " + sThresholds2.es);
            db.println("SES " + sThresholds2.ses);
            db.println("LOSS " + sThresholds2.loss);
            db.println("SAS " + sThresholds2.sas);
            db.println("AIS " + sThresholds2.ais);
            db.println("UAS " + sThresholds2.uas);
            db.println("BBE " + sThresholds2.bbe);
            db.println("===============================================");
        }
    }

    @Override
    public CSHelpID getHelpID() {
        if (this.helpID == null) {
            return CSHelpConst.Introduction;
        }
        return this.helpID;
    }
}

