/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.Dwdm40GPathTableModel;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Dwdm40GPathPane
extends NodeProvPane
implements TableModelListener {
    protected TdmHoModel[] hoModels;
    protected Dwdm40GPathTableModel dataModel;
    private ObservableManager _obsMgr;
    static final SDebug db = new SDebug("Dwdm40GPathPane");

    public Dwdm40GPathPane(String string, TabbedView tabbedView, TdmHoModel[] tdmHoModelArray, Dwdm40GPathTableModel dwdm40GPathTableModel) {
        super(string, tabbedView);
        this.hoModels = tdmHoModelArray;
        this.dataModel = dwdm40GPathTableModel;
        this.getObsMgr().addObservable((Observable[])tdmHoModelArray);
        this.init();
    }

    private void init() {
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane, "Center");
        this.initPathPaneContent();
        this.registerWithModel();
    }

    private void initPathPaneContent() {
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setMinWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        this.setAttrCellEditor(1, "declareSfBerLevel");
        this.setAttrCellEditor(2, "declareSdBerLevel");
    }

    protected void setAttrCellEditor(int n, String string) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        catch (NoSuchElementException noSuchElementException) {
            if (db.on()) {
                db.println("Warning: cannot find attributes for " + string);
            }
            this.table.removeColumn(tableColumn);
        }
    }

    @Override
    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    @Override
    public void enteringPage() throws Exception {
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        super.enteringPage();
        this.getObsMgr().setPassing(true);
    }

    @Override
    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected ModuleModel getEqpmtModel() {
        return (ModuleModel)this.getUiModel();
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.getEqpmtModel());
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = this.getAttributeMap().getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    @Override
    public void refreshFromModel() {
        this.dataModel.refreshMyLines(((DwdmModuleModel)this.getUiModel()).getHO());
        this.resetDirty();
    }

    public synchronized void setHoModels(TdmHoModel[] tdmHoModelArray) {
        this.getObsMgr().removeObservable((Observable[])tdmHoModelArray);
        this.hoModels = tdmHoModelArray;
        this.getObsMgr().addObservable((Observable[])tdmHoModelArray);
        this.dataModel.refreshMyLines(tdmHoModelArray);
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.hoModels);
        }
        this.hoModels = ((DwdmModuleModel)this.getUiModel()).getHO();
        if (this._obsMgr != null) {
            this._obsMgr.addObservable((Observable[])this.hoModels);
        }
        this.dataModel.refreshMyLines(this.hoModels);
    }

    @Override
    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.refreshFromModel();
        this.resetDirty();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.Dwdm40GPathPane;
    }
}

