/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Dwdm.eAisSquelchMode;
import cerent.cms.idl.Dwdm.eDwdmPathMonitoring;
import cerent.cms.idl.Dwdm.eTermMode;
import cerent.cms.idl.Dwdm.sDwdmCardConfig;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.sCardPeerInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmOTULineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.SlotHelper;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DwdmCardProvPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    private final String DATA_RATE_RULE_MSG;
    private final String TERM_MODE_RULE_MSG;
    private final String CARD_MODE_RULE_MSG;
    private final String CARD_FPGA_UPDATE_MSG;
    private static final String REGEN_GROUP_RULE_MSG = "Creating a regeneration group requires that:\n1) Both cards should be of same card type.\n2) Both cards have the same payload data type.\n3) Both cards should be in transparent termination mode.\n4) Neither card is part of another regeneration peer group.\n5) Neither card is part of a Y-cable protection group.\n";
    private static final String ADM_GROUP_RULE_MSG = "The peer group cannot be created because one or more circuits are provisioned on it.";
    private static String TUNABLE_WL_MSG = "Tunable Wavelengths: ";
    private final String WAVE_LENGTH_RULE_MSG;
    protected DwdmModuleModel eqpmtModel = (DwdmModuleModel)this.getUiModel();
    protected DwdmTrkLineModel firstTrk = this.eqpmtModel.getFirstTrunkLine();
    private JLabel framingTypeLBL;
    private JComboBox termModeCB;
    private JComboBox cardModeCB;
    private JComboBox cardModePG1CB;
    private JComboBox regenPeerCB;
    private JComboBox admPeerCB;
    private JComboBox squelchCB;
    private JButton forceUpgrade;
    private JComboBox odukOHCB;
    private JLabel tunableWavelengthsLBL;
    private FixedLengthField nameTF;
    private int curPeerIndex;
    private boolean createFramingTypeLabel;
    private String[] tunableWavelength;
    private String framingTypeKey;
    private String termModeKey;
    private String cardModeKey;
    private String squelchKey;
    private String odukOHKey;
    private JComboBox overClockingCB;
    private String overClockingKey;
    private String dpskValKey;
    private FixedLengthField dispersionValTF;
    private int eqType;
    private EntityTableModel etm = ((NodeModelDelegate)this.eqpmtModel.getNodeModel()).getEntityTableModel();
    private IChassisModel chassis;
    private ElementModelsDelegate emd;
    private DwdmTrkLineModel[] peerFirstTrks;
    private eWavelength waveLength;
    protected static final SDebug db = new SDebug("DwdmCardProvPane");

    private DwdmOTULineModel getOTUPayload() {
        InterfaceModel interfaceModel;
        DwdmOTULineModel dwdmOTULineModel = null;
        AbstractDwdmLineModel abstractDwdmLineModel = this.eqpmtModel.getFirstClientLine();
        if (!(((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty() && ((EntityModel)this.getUiModel()).getDescendantsOfEqType(326).isEmpty() || abstractDwdmLineModel == null || (interfaceModel = abstractDwdmLineModel.getPayloadModel()) == null || !(interfaceModel instanceof DwdmOTULineModel))) {
            dwdmOTULineModel = (DwdmOTULineModel)interfaceModel;
        }
        return dwdmOTULineModel;
    }

    public DwdmCardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        String string2 = AdminState.getAdminTermDSBLD(this.eqpmtModel.getNodeModel().getTDMTerminology());
        this.eqType = this.eqpmtModel.getEqType();
        this.DATA_RATE_RULE_MSG = "Changing the payload data type requires that:\n1) All port states are " + string2 + ".\n" + "2) No ports have DCC terminations.\n" + "3) No ports are part of any timing source.\n" + "4) No ports have any active section trace mode.\n" + "5) For all 2R payload data types, no trunk ports have any GCC termination or ITU-T G.709 OTN status enabled.\n" + "If any port is Y-cable protected, the above rules also apply to the peer port.\n" + "If the card is in a regeneration group, the above rules apply to peer card.\n";
        this.TERM_MODE_RULE_MSG = "Changing the termination mode requires that:\n1) All port states are " + string2 + ".\n" + "2) No ports have DCC terminations.\n" + "3) No ports have any overhead circuits when transitioning to transparent mode.\n" + "4) No ports have any active section trace when transitioning to transparent mode.\n" + "5) No trunk ports are a timing source.\n" + "If any client port is Y-cable protected, the above rules apply to the peer port.\n";
        this.CARD_MODE_RULE_MSG = "Changing the card operation mode requires that:\n" + (this.supportsPortGroupMode() ? "1) All port states of the affected port group are " + string2 + ".\n" : "1) All port states are " + string2 + ".\n") + "2) The current payload configuration is applicable to the new card mode.\n" + "3) The card is not downloading software.\n" + "If any port is Y-cable protected, the above rules apply to peer card.\n";
        this.WAVE_LENGTH_RULE_MSG = "Changing the wavelength requires that all trunk ports states are " + string2 + ".\n";
        this.CARD_FPGA_UPDATE_MSG = "The FPGA of this card, \ncannot be updated because \nat least one client port\nis not in the OOS,DSBLD state.";
        switch (this.eqType) {
            case 119: {
                this.framingTypeKey = "declMXP10GDwdmFramingType";
                this.termModeKey = "declTermModeTransparentSection";
                this.tunableWavelength = new String[2];
                this.createFramingTypeLabel = false;
                break;
            }
            case 182: 
            case 276: {
                this.framingTypeKey = "declMXP10GDwdmFramingType";
                this.termModeKey = "mxp25GTermMode";
                this.squelchKey = "aisSquelch";
                this.tunableWavelength = new String[8];
                this.createFramingTypeLabel = false;
                break;
            }
            case 118: {
                this.framingTypeKey = "declTXP10GDwdmFramingType";
                this.termModeKey = "declTermModeTransparentSection";
                this.tunableWavelength = new String[2];
                this.createFramingTypeLabel = false;
                break;
            }
            case 181: {
                this.framingTypeKey = "declTXP10GDwdmFramingType";
                this.termModeKey = "declTermModeFullSet";
                this.squelchKey = "aisSquelch";
                this.tunableWavelength = new String[8];
                this.createFramingTypeLabel = false;
                break;
            }
            case 274: 
            case 275: {
                this.framingTypeKey = "declTXP10EXDwdmFramingType";
                this.termModeKey = "declTermModeFullSet";
                this.squelchKey = "aisSquelch";
                this.tunableWavelength = new String[8];
                this.createFramingTypeLabel = false;
                this.odukOHKey = "odukOHMode";
                break;
            }
            default: {
                this.framingTypeKey = "declTXP25GFramingType";
                this.termModeKey = "declTermModeFullSet";
                this.tunableWavelength = new String[4];
                this.createFramingTypeLabel = true;
                break;
            }
            case 273: {
                this.framingTypeKey = null;
                this.createFramingTypeLabel = false;
                this.termModeKey = null;
                this.tunableWavelength = new String[1];
                this.tunableWavelength[0] = "XFP Wavelength";
                break;
            }
            case 183: 
            case 184: 
            case 243: 
            case 282: {
                this.framingTypeKey = null;
                this.termModeKey = null;
                this.cardModeKey = this.eqType == 243 || this.eqType == 282 ? "mxpMr10DMEPortGroupMode" : "mxpMr25GCardMode";
                this.tunableWavelength = new String[4];
                this.createFramingTypeLabel = false;
                break;
            }
            case 300: 
            case 301: 
            case 356: 
            case 358: {
                this.cardModeKey = "xmXT40GCardMode";
                this.tunableWavelength = new String[4];
                TUNABLE_WL_MSG = "Trunk Wavelength: ";
            }
        }
        if (this.eqpmtModel.supportRegenGroup()) {
            this.chassis = this.eqpmtModel.getChassis();
            this.emd = this.chassis.getElementModels();
            this.peerFirstTrks = new DwdmTrkLineModel[0];
        }
        if (this.eqpmtModel.supportADMGroup()) {
            this.chassis = this.eqpmtModel.getChassis();
            this.emd = this.chassis.getElementModels();
            this.peerFirstTrks = null;
        }
        this.initProvPane();
    }

    protected void initProvPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        this.add((Component)uScrollPane);
        jPanel.add(this.createCardInfoPanel());
        if (this.eqType != 293) {
            jPanel.add(this.createCardParametersPanel());
        }
        if (db.on()) {
            db.println("init: finish");
        }
    }

    protected Attribute[] getAttributeFor(String string) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
    }

    protected Attribute getAttributeValFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string, n);
    }

    protected JLabel createLabel(String string) {
        return this.createLabel(string, 175, 20);
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    protected JPanel createCardInfoPanel() {
        Object[] objectArray;
        JPanel jPanel = DwdmCardProvPane.createVerticalPanel("Card Provisioning");
        if (this.supportsCardMode()) {
            if (this.supportsPortGroupMode()) {
                this.cardModePG1CB = this.addComboBox(jPanel, "Port 1-4 Mode: ", this.getAttributeFor(this.cardModeKey));
                this.cardModeCB = this.addComboBox(jPanel, "Port 5-8 Mode: ", this.getAttributeFor(this.cardModeKey));
            } else {
                this.cardModeCB = this.addComboBox(jPanel, "Card Mode: ", this.getAttributeFor(this.cardModeKey));
            }
        }
        if (this.supportsODUkOH()) {
            jPanel.add(Box.createVerticalStrut(5));
            jPanel.add(Box.createVerticalStrut(5));
            this.odukOHCB = this.addComboBox(jPanel, "ODUk OH: ", this.getAttributeFor(this.odukOHKey));
        }
        if (this.supportsTermMode()) {
            this.createFramingTypeControl(jPanel, this.createFramingTypeLabel ? "Framing Type: " : null);
            jPanel.add(Box.createVerticalStrut(5));
            this.termModeCB = this.addComboBox(jPanel, "Termination Mode: ", this.getAttributeFor(this.termModeKey));
        }
        if (this.supportsAISSquelch()) {
            jPanel.add(Box.createVerticalStrut(5));
            jPanel.add(Box.createVerticalStrut(5));
            this.squelchCB = this.addComboBox(jPanel, "AIS/Squelch Configuration: ", this.getAttributeFor(this.squelchKey));
        }
        if (this.eqType == 243) {
            jPanel.add(Box.createVerticalStrut(5));
            this.forceUpgrade = this.addButton(jPanel, "");
        }
        jPanel.add(Box.createVerticalStrut(5));
        if (this.eqpmtModel.supportRegenGroup()) {
            jPanel.add(Box.createVerticalStrut(5));
            objectArray = new String[]{"None"};
            this.regenPeerCB = this.addComboBox(jPanel, "Regeneration Peer Slot: ", objectArray);
            this.nameTF = this.addTextPanel(jPanel, "Regeneration Group Name:", 32);
        }
        if (this.eqpmtModel.supportADMGroup()) {
            jPanel.add(Box.createVerticalStrut(20));
            objectArray = new String[]{"None"};
            this.admPeerCB = this.addComboBox(jPanel, "ADM Group Peer: ", objectArray);
            this.nameTF = this.addTextPanel(jPanel, "ADM Group Name:", 32);
        }
        return jPanel;
    }

    protected FixedLengthField addTextPanel(JPanel jPanel, String string, int n) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        FixedLengthField fixedLengthField = new FixedLengthField(n);
        fixedLengthField.setColumns(n);
        jPanel2.add(fixedLengthField);
        fixedLengthField.getDocument().addDocumentListener(this);
        jPanel.add(jPanel2);
        this.enableComponent(fixedLengthField);
        return fixedLengthField;
    }

    private JPanel createCardParametersPanel() {
        JPanel jPanel = DwdmCardProvPane.createVerticalPanel("Card Parameters");
        this.tunableWavelengthsLBL = this.addLabel(jPanel, TUNABLE_WL_MSG, 600, 20);
        return jPanel;
    }

    private JButton addButton(JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JButton jButton = new JButton("Force FPGA Update");
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        jPanel.add(jPanel2);
        this.enableComponent(jButton);
        return jButton;
    }

    protected JComboBox addComboBox(JPanel jPanel, String string, Object[] objectArray) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jPanel2.add(jComboBox);
        jComboBox.addActionListener(this);
        jPanel.add(jPanel2);
        this.enableComponent(jComboBox);
        if (string.startsWith("Wavelength")) {
            StringBuffer stringBuffer = new StringBuffer("   ");
            stringBuffer.append(" ** means the supported wavelength ");
            jPanel2.add(this.createLabel(stringBuffer.toString(), 300, 20));
        }
        return jComboBox;
    }

    private void createFramingTypeControl(JPanel jPanel, String string) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string, 175, 20));
            this.framingTypeLBL = this.createLabel("      ");
            jPanel2.add(this.framingTypeLBL);
        } else {
            this.framingTypeLBL = null;
        }
        jPanel.add(jPanel2);
    }

    private JLabel addLabel(JPanel jPanel, String string, int n, int n2) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JLabel jLabel = this.createLabel("", n, n2);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        return jLabel;
    }

    private int getTermModeFromCB() {
        return ((Attribute)this.termModeCB.getSelectedItem()).getIntValue();
    }

    private eCardOperMode getCardModeFromCB() {
        int n = ((Attribute)this.cardModeCB.getSelectedItem()).getIntValue();
        if (this.cardModePG1CB != null) {
            n += 13 + ((Attribute)this.cardModePG1CB.getSelectedItem()).getIntValue() * 2;
        }
        return eCardOperMode.from_int(n);
    }

    private int getAisSquelchFromCB() {
        return this.squelchCB != null ? ((Attribute)this.squelchCB.getSelectedItem()).getIntValue() : 0;
    }

    private int getOdukOHFromCB() {
        return this.odukOHCB != null ? ((Attribute)this.odukOHCB.getSelectedItem()).getIntValue() : 0;
    }

    private int getPeerFromCB(JComboBox jComboBox) {
        int n;
        block6: {
            String string;
            n = 0;
            IEntityModel iEntityModel = null;
            if (jComboBox != null && (string = (String)jComboBox.getSelectedItem()).compareTo("None") != 0) {
                try {
                    Object object;
                    if (string.indexOf("-") != -1) {
                        object = new StringTokenizer(string, "-");
                        int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
                        int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                        iEntityModel = this.etm.getEntityModelBySlot(n2, n3);
                    } else {
                        int n4 = Integer.parseInt(string);
                        iEntityModel = this.etm.getEntityModelBySlot(1, n4);
                    }
                    object = iEntityModel.getChildren();
                    if (!object.isEmpty()) {
                        n = ((IEntityModel)object.get(0)).getIndex();
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block6;
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return n;
    }

    private String getRegenGroupNameFromTF() {
        return this.nameTF != null ? this.nameTF.getText() : "";
    }

    private sDwdmCardConfig getDwdmCardConfig() {
        sDwdmCardConfig sDwdmCardConfig2 = new sDwdmCardConfig();
        sDwdmCardConfig2.termMode = this.termModeCB != null ? eTermMode.from_int(this.getTermModeFromCB()) : eTermMode.TERM_TRANSPARENT;
        sDwdmCardConfig2.regenPeerCardIndex = this.regenPeerCB != null ? this.getPeerFromCB(this.regenPeerCB) : 0;
        sDwdmCardConfig2.regenGroupName = this.nameTF != null ? this.getRegenGroupNameFromTF() : "";
        sDwdmCardConfig2.aisSquelch = this.squelchCB != null ? eAisSquelchMode.from_int(this.getAisSquelchFromCB()) : eAisSquelchMode.MODE_DISABLE;
        sDwdmCardConfig2.pathMonitoring = this.odukOHCB != null ? eDwdmPathMonitoring.from_int(this.getOdukOHFromCB()) : eDwdmPathMonitoring.TRASPARENT_STANDARD;
        sDwdmCardConfig2.wavelength = this.waveLength;
        return sDwdmCardConfig2;
    }

    private void updateAISMode() {
        sDwdmCardConfig sDwdmCardConfig2 = new sDwdmCardConfig();
        int n = AbstractDwdmLineModel.mapFramingType(this.getDataRate());
        sDwdmCardConfig2.termMode = eTermMode.from_int(this.getTermModeFromCB());
        if (!(n != 0 && n != 1 || sDwdmCardConfig2.termMode.value() != 1 && sDwdmCardConfig2.termMode.value() != 2)) {
            this.squelchCB.setEnabled(false);
            this.squelchCB.setSelectedItem(this.getAttributeValFor(this.squelchKey, 1));
        } else if (n == 2 || n == 3) {
            this.squelchCB.setSelectedItem(this.getAttributeValFor(this.squelchKey, 2));
            this.squelchCB.setEnabled(false);
        } else {
            this.squelchCB.setEnabled(true);
        }
    }

    private void updateODUkOHMode() {
        if (!((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty() || !((EntityModel)this.getUiModel()).getDescendantsOfEqType(326).isEmpty()) {
            this.odukOHCB.setEnabled(true);
        } else {
            this.odukOHCB.setSelectedItem(this.getAttributeValFor(this.odukOHKey, 1));
            this.odukOHCB.setEnabled(false);
        }
    }

    private void updateTermModeRegenGroupControl() {
        boolean bl;
        boolean bl2;
        int n = AbstractDwdmLineModel.mapFramingType(this.getDataRate());
        boolean bl3 = bl2 = this.getPeerFromCB(this.regenPeerCB) != 0 || n != 0 && n != 1;
        if (this.termModeCB != null) {
            if (bl2) {
                this.termModeCB.setSelectedItem(this.getAttributeValFor(this.termModeKey, 0));
            }
            this.termModeCB.setEnabled(!bl2 && this.isUserAuthorized());
        }
        if (this.nameTF != null) {
            boolean bl4 = bl = bl2 && this.isUserAuthorized();
            if (!bl) {
                this.nameTF.setText("");
            }
            this.nameTF.setEnabled(bl);
        }
        if (this.regenPeerCB != null && this.supportsTermMode()) {
            bl = this.getTermModeFromCB() == 0 && this.isUserAuthorized();
            this.regenPeerCB.setEnabled(bl);
        }
    }

    private void updateFramingTypeLabel() {
        if (this.createFramingTypeLabel) {
            Attribute attribute = this.getAttributeValFor(this.framingTypeKey, EntityCellRenderer.mapPayloadType(this.getDataRate()));
            if (this.framingTypeLBL != null) {
                this.framingTypeLBL.setText(attribute.getKey());
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update from " + observable + "arg obj is " + object);
        }
        if (observable == this.firstTrk || observable == this.eqpmtModel) {
            if (object.equals(ModelUpdateType.CHANGED)) {
                this.requestRefresh(observable, this.getRefreshThread(observable));
            }
        } else {
            this.requestRefresh(observable, new Runnable(){

                @Override
                public void run() {
                    DwdmCardProvPane.this.updateRegenPeerCB();
                }
            });
        }
    }

    protected Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                DwdmCardProvPane.this.refreshModule(observable);
                DwdmCardProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshModule(Observable observable) {
        if (observable instanceof DwdmModuleModel) {
            this.setCardWavelengths();
        }
    }

    protected void refreshLine(Observable observable) {
        if (observable instanceof AbstractDwdmLineModel || this.eqpmtModel.supportADMGroup()) {
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                if (db.on()) {
                    KDebug.printStackTrace((Throwable)exception);
                }
                return;
            }
        }
    }

    @Override
    protected void registerWithModel() {
        this.eqpmtModel.addObserver((Observer)((Object)this));
        if (this.firstTrk != null) {
            this.firstTrk.addObserver((Observer)((Object)this));
        }
        if (this.emd != null) {
            if (this.peerFirstTrks != null) {
                for (int i = 0; i < this.peerFirstTrks.length; ++i) {
                    this.peerFirstTrks[i].addObserver((Observer)((Object)this));
                }
            }
            if (this.eqType != 121) {
                this.emd.addObserver((Observer)((Object)this));
            }
            this.chassis.addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        this.eqpmtModel.deleteObserver((Observer)((Object)this));
        if (this.firstTrk != null) {
            this.firstTrk.deleteObserver((Observer)((Object)this));
        }
        if (this.emd != null) {
            if (this.peerFirstTrks != null) {
                for (int i = 0; i < this.peerFirstTrks.length; ++i) {
                    this.peerFirstTrks[i].deleteObserver((Observer)((Object)this));
                }
            }
            this.emd.deleteObserver((Observer)((Object)this));
            this.chassis.deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void destroy() {
        this.unRegisterWithModel();
        super.destroy();
    }

    private String getExtraMfgInfo(String string) {
        Map map = this.eqpmtModel.getExtraInfoMap();
        String string2 = (String)map.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    private boolean supportsPortGroupMode() {
        return this.eqType == 243 || this.eqType == 282;
    }

    private boolean supportsCardMode() {
        switch (this.eqType) {
            case 183: 
            case 184: 
            case 243: 
            case 282: 
            case 301: 
            case 356: {
                return true;
            }
        }
        return false;
    }

    private boolean supportsTermMode() {
        switch (this.eqType) {
            case 183: 
            case 184: 
            case 243: 
            case 273: 
            case 282: 
            case 300: 
            case 301: 
            case 356: 
            case 358: {
                return false;
            }
        }
        return true;
    }

    private boolean supportsAISSquelch() {
        switch (this.eqType) {
            case 181: 
            case 182: 
            case 274: 
            case 275: 
            case 276: {
                return true;
            }
        }
        return false;
    }

    private boolean supportsODUkOH() {
        switch (this.eqType) {
            case 274: 
            case 275: {
                return true;
            }
        }
        return false;
    }

    private Attribute getPortGroupModeAttr(int n, boolean bl) {
        int n2 = 0;
        if (n == 16 || (bl ? n == 15 : n == 14)) {
            n2 = 1;
        }
        return this.getAttributeValFor(this.cardModeKey, n2);
    }

    private synchronized void setCardWavelengths() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getExtraMfgInfo("SWL"));
        if (stringBuffer.length() == 0) {
            for (int i = 0; i < this.tunableWavelength.length; ++i) {
                this.tunableWavelength[i] = i == 0 ? this.getExtraMfgInfo("WL") : this.getExtraMfgInfo("WL" + i);
                if (this.tunableWavelength[i].length() > 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.tunableWavelength[i]);
                    stringBuffer.append(" nm");
                }
                db.info("WL" + i + "=" + this.tunableWavelength[i]);
            }
        }
        this.tunableWavelengthsLBL.setText(stringBuffer.toString());
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("calling applyChangesToModel");
        }
        try {
            Object object;
            this.setCursor(3);
            if (this.cardModeCB != null && (object = this.getCardModeFromCB()) != this.eqpmtModel.getCardOperMode()) {
                boolean bl;
                boolean bl2 = true;
                boolean bl3 = bl = this.eqpmtModel.getModuleModel() instanceof DwdmModuleModel && ((DwdmModuleModel)this.eqpmtModel.getModuleModel()).isPolluceCard();
                if (this.eqpmtModel.getState() != eEqState.NOT_PRESENT && !bl) {
                    String string = ErrorMsg.getString((EID)EMC.WID_CARD_MODE_CHANGE_WARNING) + "\n\nIs it OK to continue?";
                    bl2 = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)string, (String)"Change Card Mode");
                }
                if (!bl2) {
                    this.refresh();
                    return;
                }
                this.eqpmtModel.setCardOperMode((eCardOperMode)object);
            }
            if (this.admPeerCB != null) {
                object = new sCardPeerInfo(this.getPeerFromCB(this.admPeerCB), this.getRegenGroupNameFromTF());
                this.eqpmtModel.setAdmPeerGroupInfo((sCardPeerInfo)object);
            }
            if (this.regenPeerCB != null || this.squelchCB != null || this.odukOHCB != null || this.termModeCB != null) {
                object = this.getOTUPayload();
                if (object != null) {
                    ((DwdmOTULineModel)object).setDwdmCardConfig(this.getDwdmCardConfig());
                } else {
                    this.firstTrk.setDwdmCardConfig(this.getDwdmCardConfig());
                }
            }
        }
        catch (EMCProvisionError eMCProvisionError) {
            String string = eMCProvisionError.getMessage();
            if (this.eqpmtModel.isADMCard() && eMCProvisionError.getEID().equals(EMC.EID_CANNOT_DELETE_PARAM) && this.admPeerCB.getSelectedIndex() == 1) {
                string = "EID-" + eMCProvisionError.getEID().getId() + "\n\n" + ADM_GROUP_RULE_MSG;
            }
            if (this.eqpmtModel.isADMCard() && !eMCProvisionError.getEID().equals(EMC.EID_CANNOT_DELETE_PARAM)) {
                string = string + "\n\n";
                string = string + "So the peer group cannot be modified.";
            }
            this.refresh();
            throw new ConfigError(string);
        }
        catch (ResourceInUse resourceInUse) {
            this.refresh();
            throw new ConfigError(resourceInUse.getMessage() + "\n" + this.CARD_MODE_RULE_MSG);
        }
        catch (DetailedConfigError detailedConfigError) {
            String string = "";
            switch (detailedConfigError.dataElement) {
                case 2: {
                    string = this.DATA_RATE_RULE_MSG;
                    break;
                }
                case 3: {
                    string = this.TERM_MODE_RULE_MSG;
                    break;
                }
                case 4: {
                    string = this.WAVE_LENGTH_RULE_MSG;
                    break;
                }
                case 5: {
                    string = REGEN_GROUP_RULE_MSG;
                }
            }
            this.refresh();
            throw new ConfigError(detailedConfigError.getMessage() + "\n" + string);
        }
        finally {
            this.setCursor(0);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        DwdmOTULineModel dwdmOTULineModel;
        if (db.on()) {
            db.println("calling refreshFromModel");
        }
        if (this.cardModeCB != null) {
            int n = this.eqpmtModel.getCardOperMode().value();
            if (this.cardModePG1CB != null) {
                this.cardModePG1CB.setSelectedItem(this.getPortGroupModeAttr(n, true));
                this.cardModeCB.setSelectedItem(this.getPortGroupModeAttr(n, false));
            } else {
                this.cardModeCB.setSelectedItem(this.getAttributeValFor(this.cardModeKey, n));
            }
        }
        if (this.admPeerCB != null) {
            sCardPeerInfo sCardPeerInfo2 = this.eqpmtModel.getAdmPeerGroupInfo();
            this.nameTF.setText(sCardPeerInfo2.peerGroupName);
            this.nameTF.setEnabled(this.isUserAuthorized());
            this.curPeerIndex = sCardPeerInfo2.peerIndex;
            this.updateADMPeerCB();
            if (this.curPeerIndex != 0) {
                dwdmOTULineModel = this.etm.getEntityModelByIndex(this.curPeerIndex);
                this.admPeerCB.setSelectedItem(SlotHelper.getShortConcatenatedString((IEntityModel)dwdmOTULineModel, (char)'-'));
            } else {
                this.admPeerCB.setSelectedItem("None");
            }
        }
        sDwdmCardConfig sDwdmCardConfig2 = null;
        dwdmOTULineModel = this.getOTUPayload();
        if (dwdmOTULineModel != null) {
            sDwdmCardConfig2 = dwdmOTULineModel.getDwdmCardConfig();
        } else if (this.firstTrk != null) {
            sDwdmCardConfig2 = this.firstTrk.getDwdmCardConfig();
        }
        if (sDwdmCardConfig2 != null) {
            this.waveLength = sDwdmCardConfig2.wavelength;
            this.curPeerIndex = sDwdmCardConfig2.regenPeerCardIndex;
            if (this.squelchCB != null) {
                this.squelchCB.setSelectedItem(this.getAttributeValFor(this.squelchKey, sDwdmCardConfig2.aisSquelch.value()));
            }
            if (this.odukOHCB != null) {
                this.odukOHCB.setSelectedItem(this.getAttributeValFor(this.odukOHKey, sDwdmCardConfig2.pathMonitoring.value()));
            }
            if (this.regenPeerCB != null) {
                this.nameTF.setText(sDwdmCardConfig2.regenGroupName);
                this.updateRegenPeerCB();
                if (this.curPeerIndex != 0) {
                    IEntityModel iEntityModel = this.etm.getEntityModelByIndex(this.curPeerIndex);
                    this.regenPeerCB.setSelectedItem(SlotHelper.getShortConcatenatedString((IEntityModel)iEntityModel, (char)'-'));
                } else {
                    this.regenPeerCB.setSelectedItem("None");
                }
            }
            if (this.supportsTermMode()) {
                this.termModeCB.setSelectedItem(this.getAttributeValFor(this.termModeKey, sDwdmCardConfig2.termMode.value()));
            }
            if (this.admPeerCB == null) {
                this.updateFramingTypeLabel();
                this.updateTermModeRegenGroupControl();
            }
        }
        if (this.eqType == 182 || this.eqType == 276 || this.eqType == 181 || this.eqType == 274 || this.eqType == 275) {
            this.updateAISMode();
        }
        if (this.eqType == 274 || this.eqType == 275) {
            this.updateODUkOHMode();
        }
        this.setCardWavelengths();
        this.resetDirty();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.eqpmtModel.getModuleModel() instanceof DwdmModuleModel && ((DwdmModuleModel)this.eqpmtModel.getModuleModel()).isPolluceCard();
        Object object = actionEvent.getSource();
        if (object == this.regenPeerCB) {
            this.updateTermModeRegenGroupControl();
        } else if (object == this.termModeCB) {
            if (this.eqType == 182 || this.eqType == 276 || this.eqType == 181 || this.eqType == 274 || this.eqType == 275) {
                this.updateAISMode();
            }
            this.updateTermModeRegenGroupControl();
        } else {
            if (object == this.forceUpgrade) {
                String string = ErrorMsg.getString((EID)EMC.WID_CARD_MODE_FPGA_FORCE_UPDATE) + "\n\nOK to continue?";
                if (CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)string, (String)"Force FPGA Firmware Update")) {
                    try {
                        this.eqpmtModel.doCommand(eModuleOp.FORCE_FPGA_UPDATE);
                    }
                    catch (InvalidState invalidState) {
                        this.displayErrorDialog(this, new Exception(this.CARD_FPGA_UPDATE_MSG), CEMC.EID_FAIL_APPLY_CHANGES);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return;
            }
            if (bl && object == this.cardModeCB) {
                if (((Attribute)this.cardModeCB.getSelectedItem()).getIntValue() == 36) {
                    this.regenPeerCB.setEnabled(false);
                } else {
                    this.regenPeerCB.setEnabled(true);
                }
            }
        }
        this.setDirty();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        this.registerWithModel();
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
        this.unRegisterWithModel();
    }

    private Set getYCableProtectedModuleModel() {
        TreeSet<IModuleModel> treeSet = new TreeSet<IModuleModel>(new EntityModel.EntityModelComparator());
        Iterator iterator = this.emd.getYCableEntities().iterator();
        while (iterator.hasNext()) {
            treeSet.add(((EntityModel)iterator.next()).getModuleModel());
        }
        return treeSet;
    }

    private synchronized void updateRegenPeerCB() {
        Object object;
        DwdmTrkLineModel[] dwdmTrkLineModelArray;
        int n;
        DefaultComboBoxModel<String> defaultComboBoxModel;
        block10: {
            if (this.regenPeerCB == null) {
                return;
            }
            List list = this.etm.getCompatibleModuleModelForRegenGroup(this.eqpmtModel);
            Set set = this.getYCableProtectedModuleModel();
            defaultComboBoxModel = new DefaultComboBoxModel<String>();
            n = -1;
            defaultComboBoxModel.addElement("None");
            if (set.contains(this.eqpmtModel)) {
                dwdmTrkLineModelArray = new DwdmTrkLineModel[]{};
            } else {
                dwdmTrkLineModelArray = new DwdmTrkLineModel[list.size()];
                for (DwdmModuleModel dwdmModuleModel : list) {
                    dwdmTrkLineModelArray[++n] = dwdmModuleModel.getFirstTrunkLine();
                    if (dwdmModuleModel.hasRegenPeer() || set.contains(dwdmModuleModel)) continue;
                    defaultComboBoxModel.addElement(SlotHelper.getShortConcatenatedString((IEntityModel)dwdmModuleModel, (char)'-'));
                }
                object = null;
                if (this.curPeerIndex != 0) {
                    try {
                        object = this.etm.getEntityModelByIndex(this.curPeerIndex);
                        defaultComboBoxModel.addElement(SlotHelper.getShortConcatenatedString((IEntityModel)object, (char)'-'));
                    }
                    catch (Exception exception) {
                        if (!DwdmCardProvPane.db.on) break block10;
                        db.println("Exception" + exception.getStackTrace());
                    }
                }
            }
        }
        for (n = 0; n < this.peerFirstTrks.length; ++n) {
            this.peerFirstTrks[n].deleteObserver((Observer)((Object)this));
        }
        this.peerFirstTrks = dwdmTrkLineModelArray;
        for (n = 0; n < this.peerFirstTrks.length; ++n) {
            this.peerFirstTrks[n].addObserver((Observer)((Object)this));
        }
        object = this.regenPeerCB.getSelectedItem();
        this.regenPeerCB.removeActionListener(this);
        this.regenPeerCB.setModel(defaultComboBoxModel);
        this.regenPeerCB.addActionListener(this);
        if (object != null && this.regenPeerCB.getSelectedItem() != object) {
            this.regenPeerCB.setSelectedItem(object);
        }
    }

    private synchronized void updateADMPeerCB() {
        if (this.admPeerCB == null) {
            return;
        }
        List list = this.etm.getCompatibleModuleModelForADMGroup(this.eqpmtModel);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("None");
        for (DwdmModuleModel dwdmModuleModel : list) {
            if (this.eqpmtModel.getShelfId() != dwdmModuleModel.getShelfId()) continue;
            defaultComboBoxModel.addElement(SlotHelper.getShortConcatenatedString((IEntityModel)dwdmModuleModel, (char)'-'));
        }
        Object object = this.admPeerCB.getSelectedItem();
        this.admPeerCB.removeActionListener(this);
        this.admPeerCB.setModel(defaultComboBoxModel);
        this.admPeerCB.addActionListener(this);
        if (object != null && this.admPeerCB.getSelectedItem() != object) {
            this.admPeerCB.setSelectedItem(object);
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmCardProvPane;
    }

    private int getDataRate() {
        int n = -1;
        try {
            n = this.firstTrk.getDataRate();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        return n;
    }

    class WavelengthListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public WavelengthListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            boolean bl3 = false;
            for (int i = 0; i < DwdmCardProvPane.this.tunableWavelength.length && !(bl3 = this.maybeSetWavelength(string, DwdmCardProvPane.this.tunableWavelength[i], jList, bl, bl2)); ++i) {
            }
            if (!bl3) {
                this.setText(string);
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                } else {
                    this.setBackground(Color.lightGray);
                }
            }
            this.setForeground(Color.black);
            this.setEnabled(jList.isEnabled() && DwdmCardProvPane.this.isUserAuthorized());
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            return this;
        }

        private boolean maybeSetWavelength(String string, String string2, JList jList, boolean bl, boolean bl2) {
            if (string2 != null) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append(" nm");
                if (string.equals(stringBuffer.toString())) {
                    this.setText(string + " **");
                    if (bl) {
                        this.setBackground(jList.getSelectionBackground());
                    } else {
                        this.setBackground(Color.white);
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

