/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmOTULineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.GfpLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterlinkPortModel;
import cerent.cms.model.LexLineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.MrSlot;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PpmModel;
import cerent.cms.model.RmonLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardInventoryPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.MaintShowCmdPane;
import cerent.cms.ui.ObflPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.SoakMaintenancePane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmInfoMaintenancePane;
import cerent.cms.ui.dwdm.DwdmLineMaintenancePane;
import cerent.cms.ui.dwdm.DwdmPerfPane;
import cerent.cms.ui.dwdm.DwdmProvPane;
import cerent.cms.ui.dwdm.NxpAlsPane;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;

public class DwdmCardTabbedView
extends PluggableCardTabbedView
implements ITabName {
    private Map _payloadToClientModels;
    private Map _payloadToTrunkModels;
    protected List _rmonModels;
    private List _gfpModels;
    private List _lexModels;
    private List _otuModels;
    private List _wisModels;
    private List _trunkModels;

    public DwdmCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        moduleModel.addObserver(this);
    }

    @Override
    protected void init() {
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        this._payloadToClientModels = Collections.synchronizedMap(new TreeMap());
        this._payloadToTrunkModels = Collections.synchronizedMap(new TreeMap());
        this._interfaceContainers = Collections.synchronizedMap(new TreeMap());
        this._trunkModels = Collections.synchronizedList(new ArrayList());
        this.initPayloadMap(dwdmModuleModel.getDwdmCliLineModels(), this._payloadToClientModels);
        this.initPayloadMap(dwdmModuleModel.getAllDwdmTrkLineModels(), this._payloadToTrunkModels);
        DwdmOTULineModel[] dwdmOTULineModelArray = dwdmModuleModel.getDwdmOTULineModels();
        for (DwdmOTULineModel tdmLineModelArray2 : dwdmOTULineModelArray) {
            try {
                IEntityModel abstractCmsNoSuchEntityException = tdmLineModelArray2.getPortModel().getParent();
                if (abstractCmsNoSuchEntityException == null || !(abstractCmsNoSuchEntityException instanceof IPortContainer)) continue;
                this.addContainerMap(tdmLineModelArray2, (IPortContainer)abstractCmsNoSuchEntityException);
            }
            catch (AbstractCmsNoSuchEntityException n) {
                SDebug.printStackTrace((Throwable)n);
            }
        }
        InterfaceModel[] interfaceModelArray = dwdmModuleModel.getGfpLineModels();
        this._gfpModels = new ArrayList<InterfaceModel>(Arrays.asList(interfaceModelArray));
        this.getOM().addObservable((Observable[])interfaceModelArray);
        LexLineModel[] lexLineModelArray = dwdmModuleModel.getLexLineModels();
        this._lexModels = new ArrayList<LexLineModel>(Arrays.asList(lexLineModelArray));
        this.getOM().addObservable((Observable[])lexLineModelArray);
        this._otuModels = new ArrayList<DwdmOTULineModel>(Arrays.asList(dwdmModuleModel.getDwdmOTULineModels()));
        this.getOM().addObservable((Observable[])this._otuModels.toArray(new AbstractDwdmLineModel[0]));
        this._rmonModels = new ArrayList<IRmonModel>(Arrays.asList(dwdmModuleModel.getRmonModels()));
        TdmPortModel[] tdmPortModelArray = dwdmModuleModel.getWisPorts();
        TdmLineModel[] tdmLineModelArray = new TdmLineModel[tdmPortModelArray.length];
        int n = 0;
        for (TdmPortModel tdmPortModel : tdmPortModelArray) {
            tdmLineModelArray[n] = tdmPortModel.getTdmLineModel();
            ++n;
        }
        this._wisModels = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray));
        this.getOM().addObservable((Observable[])this._wisModels.toArray(new TdmLineModel[0]));
        this.getOM().addObservable((Observable)((Object)dwdmModuleModel.getMrSlot()));
        if (db.on()) {
            db.println("<init> found clientModels = " + dwdmModuleModel.getDwdmCliLineModels().length + " <init> found trunkModels = " + dwdmModuleModel.getAllDwdmTrkLineModels().length);
        }
        super.init();
    }

    private void initPayloadMap(AbstractDwdmLineModel[] abstractDwdmLineModelArray, Map map) {
        int n = abstractDwdmLineModelArray == null ? 0 : abstractDwdmLineModelArray.length;
        for (int i = 0; i < n; ++i) {
            InterfaceModel interfaceModel = abstractDwdmLineModelArray[i].getPayloadModel();
            if (interfaceModel != null) {
                if (db.on()) {
                    db.println("Add (Cli/Trk) 1 ---- Adding payload: " + interfaceModel + ", to OM");
                }
                this.getOM().addObservable((Observable)((Object)interfaceModel));
                if (db.on()) {
                    db.println("Add (Cli/Trk) 2 ---- Adding IfModel: " + interfaceModel + ", line model: " + abstractDwdmLineModelArray[i] + ", to map payload <-> line");
                }
                map.put(interfaceModel, abstractDwdmLineModelArray[i]);
                if (db.on()) {
                    db.println("Add (Cli/Trk) 3 ---- Adding IfModel: " + interfaceModel);
                }
                this.addContainerMap(interfaceModel);
                if (!(abstractDwdmLineModelArray[i] instanceof DwdmTrkLineModel) || ((DwdmModuleModel)this.getUiModel()).hasPluggableTrunk()) continue;
                if (db.on()) {
                    db.println("Add (Trk)     4 ---- Adding trunk port with payload: " + abstractDwdmLineModelArray[i] + ", to OM");
                }
                this.getOM().addObservable((Observable)((Object)abstractDwdmLineModelArray[i]));
                continue;
            }
            if (abstractDwdmLineModelArray[i] instanceof DwdmTrkLineModel) {
                DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)abstractDwdmLineModelArray[i];
                this.manageTrkPayload(dwdmTrkLineModel, map);
                continue;
            }
            db.println("Payload cannot be determined for line: " + abstractDwdmLineModelArray[i]);
            if (!db.on()) continue;
            SDebug.printStackTrace((Throwable)new Exception());
        }
    }

    private InterfaceModel[] getPayloadLinesArray() {
        ArrayList arrayList = new ArrayList(this._payloadToClientModels.keySet());
        arrayList.addAll(this._payloadToTrunkModels.keySet());
        return arrayList.toArray(new InterfaceModel[arrayList.size()]);
    }

    private DwdmCliLineModel[] getCliLinesArray() {
        return this._payloadToClientModels.values().toArray(new DwdmCliLineModel[0]);
    }

    private DwdmOTULineModel[] getOTULinesArray() {
        return this._otuModels.toArray(new DwdmOTULineModel[0]);
    }

    private DwdmTrkLineModel[] getTrkLinesArray() {
        DwdmTrkLineModel[] dwdmTrkLineModelArray = null;
        if (this._trunkModels.size() == 0) {
            dwdmTrkLineModelArray = this._payloadToTrunkModels.values().toArray(new DwdmTrkLineModel[this._payloadToTrunkModels.size()]);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.addAll(this._payloadToTrunkModels.values());
            for (DwdmTrkLineModel dwdmTrkLineModel : this._trunkModels) {
                if (arrayList.contains(dwdmTrkLineModel)) continue;
                arrayList.add(dwdmTrkLineModel);
            }
            dwdmTrkLineModelArray = arrayList.toArray(new DwdmTrkLineModel[0]);
        }
        return dwdmTrkLineModelArray;
    }

    private GfpLineModel[] getGfpLinesArray() {
        return this._gfpModels.toArray(new GfpLineModel[this._gfpModels.size()]);
    }

    private LexLineModel[] getLexLinesArray() {
        return this._lexModels.toArray(new LexLineModel[this._lexModels.size()]);
    }

    private IRmonModel[] getRmonModelsArray() {
        return this._rmonModels.toArray(new IRmonModel[this._rmonModels.size()]);
    }

    private TdmLineModel[] getWisLinesArray() {
        return this._wisModels.toArray(new TdmLineModel[0]);
    }

    private IPortContainer manageTrkPayload(DwdmTrkLineModel dwdmTrkLineModel, Map map) {
        IPortContainer iPortContainer;
        block17: {
            iPortContainer = null;
            if (dwdmTrkLineModel.isInterlink()) {
                InterlinkPortModel interlinkPortModel = null;
                try {
                    interlinkPortModel = (InterlinkPortModel)dwdmTrkLineModel.getPortModel();
                    if (interlinkPortModel != null) {
                        iPortContainer = (IPortContainer)interlinkPortModel.getParent();
                        if (db.on()) {
                            db.println("Add (Ilk) 1 ---- Adding payload interface: " + interlinkPortModel.getInterfaceModel() + ", to OM");
                        }
                        this.getOM().addObservable((Observable)((Object)((InterfaceModel)interlinkPortModel.getInterfaceModel())));
                        if (db.on()) {
                            db.println("Add (Ilk) 2 ---- Adding IfModel: " + dwdmTrkLineModel + ", to map payload <-> line");
                        }
                        map.put(dwdmTrkLineModel, dwdmTrkLineModel);
                        if (!this._interfaceContainers.containsValue(interlinkPortModel.getParent())) {
                            if (db.on()) {
                                db.println("Add (Ilk) 3 ---- Adding IfModel: " + dwdmTrkLineModel + ", container: " + interlinkPortModel.getParent() + ", to _interfaceContainers");
                            }
                            this._interfaceContainers.put(dwdmTrkLineModel, interlinkPortModel.getParent());
                            this.addContainerMap(dwdmTrkLineModel, (IPortContainer)interlinkPortModel.getParent());
                        } else if (db.on()) {
                            db.println("Add (Ilk) ---- Interlink IfModel " + dwdmTrkLineModel + " container " + interlinkPortModel.getParent() + " already present!!!!!");
                        }
                    } else if (db.on()) {
                        db.println("Got null Interlink payload.");
                    }
                    break block17;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Cannot determine Interlink port.");
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    break block17;
                }
            }
            if (!this._trunkModels.contains(dwdmTrkLineModel)) {
                if (db.on()) {
                    db.println("Add (Trk w/o payload, not Interlink) 1 ---- Adding line: " + dwdmTrkLineModel + ", to OM");
                }
                this.getOM().addObservable((Observable)((Object)dwdmTrkLineModel));
                if (db.on()) {
                    db.println("Add (Trk w/o payload, not Interlink) 2 ---- Adding IfModel: " + dwdmTrkLineModel + ", to Trk w/o payload, not Interlink)");
                }
                this._trunkModels.add(dwdmTrkLineModel);
                if (db.on()) {
                    db.println("Add (Trk w/o payload, not Interlink) 3 ---- Nothing to add to interface container");
                }
            }
        }
        return iPortContainer;
    }

    private IPortContainer updatePayloadMap(AbstractDwdmLineModel[] abstractDwdmLineModelArray, Map map) {
        int n;
        IPortContainer iPortContainer = null;
        int n2 = n = abstractDwdmLineModelArray == null ? 0 : abstractDwdmLineModelArray.length;
        if (n > map.size()) {
            AbstractDwdmLineModel abstractDwdmLineModel = null;
            InterfaceModel interfaceModel = null;
            for (int i = 0; i < n; ++i) {
                if (!map.containsValue(abstractDwdmLineModelArray[i])) {
                    Object object;
                    abstractDwdmLineModel = abstractDwdmLineModelArray[i];
                    int n3 = 0;
                    try {
                        n3 = abstractDwdmLineModel.getModuleModel().getEqType();
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    if (db.on()) {
                        db.println("Found new line = " + abstractDwdmLineModel);
                    }
                    if ((interfaceModel = abstractDwdmLineModel.getPayloadModel()) != null) {
                        if (db.on()) {
                            db.println("Found payload = " + interfaceModel);
                        }
                        try {
                            object = interfaceModel.getPortModel();
                            IEntityModel iEntityModel = object.getParent();
                            if (iEntityModel instanceof IPortContainer) {
                                iPortContainer = (IPortContainer)iEntityModel;
                                if (db.on()) {
                                    db.println("Add (Cli/Trk) 1 ---- Adding IfModel: " + interfaceModel + ", container: " + iPortContainer + ", to containers map");
                                }
                                this.addContainerMap(interfaceModel, iPortContainer);
                            } else if (db.on()) {
                                db.println("PortModel is " + object);
                                db.println("EntityModel is not a PortContainer! Found " + iEntityModel);
                            }
                            if (db.on()) {
                                db.println("Found pc = " + iPortContainer);
                                db.println("Add (Cli/Trk) 2 ---- Adding payload: " + interfaceModel + ", to OM");
                            }
                            this.getOM().addObservable((Observable)((Object)interfaceModel));
                            if (db.on()) {
                                db.println("Add (Cli/Trk) 3 ---- Adding IfModel: " + interfaceModel + ", line model: " + abstractDwdmLineModel + ", to map payload <-> line");
                            }
                            if (abstractDwdmLineModel instanceof DwdmTrkLineModel) {
                                this._payloadToTrunkModels.put(interfaceModel, abstractDwdmLineModel);
                                continue;
                            }
                            map.put(interfaceModel, abstractDwdmLineModel);
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            db.println("Caught NoSuchEntity in updatePayloadMap!");
                            if (!db.on()) continue;
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                        continue;
                    }
                    if (abstractDwdmLineModel instanceof DwdmTrkLineModel && n3 != 300 && n3 != 358) {
                        object = (DwdmTrkLineModel)abstractDwdmLineModelArray[i];
                        iPortContainer = this.manageTrkPayload((DwdmTrkLineModel)object, map);
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println("Payload not found");
                    continue;
                }
                if (!db.on()) continue;
                db.println("Found known line<->payload mapping");
            }
        }
        return iPortContainer;
    }

    @Override
    protected List addModel(Observable observable) {
        IRmonModel[] iRmonModelArray;
        Object object;
        int n;
        Object object2;
        TdmPortModel[] tdmPortModelArray2;
        Object object3;
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        List list = super.addModel(observable);
        Object object4 = null;
        InterfaceModel interfaceModel = null;
        boolean bl = false;
        int n2 = 0;
        if (observable instanceof DwdmModuleModel) {
            object3 = this.updatePayloadMap(dwdmModuleModel.getDwdmCliLineModels(), this._payloadToClientModels);
            tdmPortModelArray2 = this.updatePayloadMap(dwdmModuleModel.getAllDwdmTrkLineModels(), this._payloadToTrunkModels);
            if (db.on()) {
                db.println("DwdmModuleModel update in addModel - cliPc: " + object3 + " trkPc: " + tdmPortModelArray2);
            }
            boolean bl2 = bl = object3 != null || tdmPortModelArray2 != null;
            object4 = object3 != null ? object3 : tdmPortModelArray2;
        } else if (observable instanceof PpmModel || observable instanceof MrSlot) {
            object4 = (IPortContainer)((Object)observable);
            if (db.on()) {
                db.println("PpmModel or MrSlot update in addModel");
                db.println("Found pc = " + object4);
            }
            for (TdmPortModel[] tdmPortModelArray2 : object4.getContainedPorts()) {
                object2 = null;
                interfaceModel = (InterfaceModel)tdmPortModelArray2.getInterfaceModel();
                int n3 = n = interfaceModel != null && interfaceModel instanceof XPL2LineModel ? 1 : 0;
                if (interfaceModel != null && (n != 0 || !this._payloadToClientModels.containsKey(interfaceModel) && !this._payloadToTrunkModels.containsKey(interfaceModel))) {
                    if (db.on()) {
                        db.println("Found new payload = " + interfaceModel);
                    }
                    if (tdmPortModelArray2 instanceof InterlinkPortModel) {
                        bl = true;
                        object2 = this._payloadToTrunkModels;
                        object2.put(interfaceModel, interfaceModel);
                        this.getOM().addObservable((Observable)((Object)interfaceModel));
                        this.addContainerMap(interfaceModel, (IPortContainer)object4);
                        continue;
                    }
                    object = interfaceModel.getFirstLowerLayerModels();
                    if (object != null) {
                        if (object instanceof DwdmCliLineModel) {
                            if (db.on()) {
                                db.println("Update Client <-> payload map for line: " + object);
                            }
                            object2 = this._payloadToClientModels;
                        } else if (object instanceof DwdmTrkLineModel) {
                            if (db.on()) {
                                db.println("Update Trunk <-> payload for line: " + object);
                            }
                            object2 = this._payloadToTrunkModels;
                        } else {
                            db.println("Invalid lower layer found for: " + interfaceModel);
                            continue;
                        }
                        if (db.on()) {
                            db.println("Add (Cli/Trk) 1 ---- Adding payload: " + interfaceModel + ", to OM");
                        }
                        this.getOM().addObservable((Observable)((Object)interfaceModel));
                        if (db.on()) {
                            db.println("Add (Cli/Trk) 2 ---- Adding IfModel: " + interfaceModel + ", line model: " + object + ", to map payload <-> line");
                        }
                        object2.put(interfaceModel, object);
                        if (db.on()) {
                            db.println("Add (Cli/Trk) 3 ---- Adding IfModel: " + interfaceModel + ", container: " + object4 + ", to containers map");
                        }
                        this.addContainerMap(interfaceModel, (IPortContainer)object4);
                        bl = true;
                        continue;
                    }
                    if (interfaceModel instanceof DwdmOTULineModel) {
                        DwdmOTULineModel[] dwdmOTULineModelArray;
                        if (db.on()) {
                            db.println("DwdmOTULineModel update in addModel");
                        }
                        int n4 = n2 = (dwdmOTULineModelArray = dwdmModuleModel.getDwdmOTULineModels()) == null ? 0 : dwdmOTULineModelArray.length;
                        if (n2 > this._otuModels.size()) {
                            this._otuModels = new ArrayList<DwdmOTULineModel>(Arrays.asList(dwdmOTULineModelArray));
                            this.getOM().addObservable((Observable[])dwdmOTULineModelArray);
                            if (DwdmCardTabbedView.db.on) {
                                db.println("otuModel.size = " + this._otuModels.size());
                            }
                        }
                        this.addContainerMap(interfaceModel, (IPortContainer)object4);
                        bl = true;
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println("No lower layer yet, for payload: " + interfaceModel);
                    continue;
                }
                if (!db.on()) continue;
                db.println("Found known (or null) payload");
            }
        } else if (observable instanceof DwdmTrkLineModel) {
            if (db.on()) {
                db.println("DwdmTrkLineModel update in addModel");
            }
            if ((interfaceModel = ((DwdmTrkLineModel)((Object)observable)).getPayloadModel()) != null) {
                bl = true;
                if (db.on()) {
                    db.println("Add (Trk) 1 ---- Adding payload: " + interfaceModel + ", to OM");
                }
                this.getOM().addObservable((Observable)((Object)interfaceModel));
                if (db.on()) {
                    db.println("Add (Trk) 2 ---- Adding IfModel: " + interfaceModel + ", line model: " + observable + ", to _payloadToTrunkModels");
                }
                this._payloadToTrunkModels.put(interfaceModel, (DwdmTrkLineModel)((Object)observable));
                if (db.on()) {
                    db.println("Found trunk payload for " + observable);
                }
            } else if (db.on()) {
                db.println("Found known (or null) Trunk payload.");
            }
        }
        object3 = dwdmModuleModel.getGfpLineModels();
        int n5 = n2 = object3 == null ? 0 : ((Object)object3).length;
        if (n2 > this._gfpModels.size()) {
            this._gfpModels = new ArrayList(Arrays.asList(object3));
            this.getOM().addObservable((Observable[])object3);
            if (DwdmCardTabbedView.db.on) {
                db.println("gfpModel.size = " + this._gfpModels.size());
            }
        }
        tdmPortModelArray2 = dwdmModuleModel.getWisPorts();
        object2 = new TdmLineModel[tdmPortModelArray2.length];
        n = 0;
        object = tdmPortModelArray2;
        int n6 = ((TdmPortModel[])object).length;
        for (int i = 0; i < n6; ++i) {
            TdmPortModel tdmPortModel = object[i];
            object2[n] = tdmPortModel.getTdmLineModel();
            ++n;
        }
        n2 = ((TdmLineModel[])object2).length;
        if (n2 > this._wisModels.size()) {
            this._wisModels = new ArrayList(Arrays.asList(object2));
            this.getOM().addObservable((Observable[])object2);
            if (DwdmCardTabbedView.db.on) {
                db.println("wisModel.size = " + this._wisModels.size());
            }
            bl = true;
        }
        int n7 = n2 = (object = dwdmModuleModel.getLexLineModels()) == null ? 0 : ((TdmPortModel[])object).length;
        if (n2 > this._lexModels.size()) {
            this._lexModels = new ArrayList<TdmPortModel>(Arrays.asList(object));
            this.getOM().addObservable((Observable[])object);
            if (DwdmCardTabbedView.db.on) {
                db.println("lexModel.size = " + this._lexModels.size());
            }
        }
        if (bl) {
            if (db.on()) {
                db.println("Sending DwdmLineUpdate...");
                db.println("PortContainer: " + object4);
                db.println("Cli lines: " + this.getCliLinesArray().length);
                db.println("OTU lines: " + this.getOTULinesArray().length);
                db.println("Trk lines: " + this.getTrkLinesArray().length);
                db.println("Payloads:  " + this.getPayloadLinesArray().length);
            }
            list.add(new DwdmLineUpdate(this.getCliLinesArray(), this.getOTULinesArray(), this.getPayloadLinesArray(), this.getTrkLinesArray(), this.getWisLinesArray(), (IPortContainer)object4));
        }
        int n8 = n2 = (iRmonModelArray = dwdmModuleModel.getRmonModels()) == null ? 0 : iRmonModelArray.length;
        if (n2 > this._rmonModels.size()) {
            this._rmonModels = new ArrayList<IRmonModel>(Arrays.asList(iRmonModelArray));
            if (DwdmCardTabbedView.db.on) {
                db.println("rmonModels.size = " + this._rmonModels.size());
                db.println("Sending RmonLineUpdate...");
            }
            list.add(new RmonLineUpdate(iRmonModelArray));
        }
        return list;
    }

    @Override
    protected List removeModel(Observable observable) {
        boolean bl = false;
        List list = super.removeModel(observable);
        IPortContainer iPortContainer = null;
        if (db.on() && (observable instanceof InterfaceModel || observable instanceof InterlinkPortModel)) {
            db.println("Remove (Cli/Trk/Ilk) 1 ---- removing: " + observable + ", from OM");
        }
        this.getOM().removeObservable(observable);
        if (observable instanceof InterfaceModel) {
            if (db.on()) {
                db.println("Remove (Cli/Trk) 2 ---- removing: " + observable + ", from containers map");
            }
            iPortContainer = (IPortContainer)this.removeContainerMap((IInterfaceModel)observable);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (observable instanceof GfpLineModel) {
                bl2 = this._gfpModels.remove(observable);
            }
            if (observable instanceof TdmLineModel) {
                bl3 = this._wisModels.remove(observable);
            }
            if (observable instanceof LexLineModel) {
                bl4 = this._lexModels.remove(observable);
            }
            if (observable instanceof DwdmOTULineModel) {
                if (db.on()) {
                    db.println("Remove OTU  ---- removing: " + observable);
                }
                bl5 = this._otuModels.remove(observable);
            }
            boolean bl6 = bl = bl2 || bl3 || bl4 || bl5;
        }
        if (iPortContainer != null) {
            if (db.on()) {
                db.println("Remove (Cli/Trk) 3 ---- removing: " + observable + ", from payload <-> Line map");
            }
            this._payloadToClientModels.remove(observable);
            this._payloadToTrunkModels.remove(observable);
            bl = true;
        } else if (this._payloadToTrunkModels.containsKey(observable)) {
            if (db.on()) {
                db.println("Remove (Trk)     3 ---- removing: " + observable + ", from payload <-> Line map");
            }
            this._payloadToTrunkModels.remove(observable);
        }
        if (bl) {
            if (db.on()) {
                db.println("Sending DwdmLineUpdate in removeModel");
                db.println("PortContainer: " + iPortContainer);
                db.println("Cli lines: " + this.getCliLinesArray().length);
                db.println("OTU lines: " + this.getOTULinesArray().length);
                db.println("Trk lines: " + this.getTrkLinesArray().length);
                db.println("Payloads:  " + this.getPayloadLinesArray().length);
            }
            list.add(new DwdmLineUpdate(this.getCliLinesArray(), this.getOTULinesArray(), this.getPayloadLinesArray(), this.getTrkLinesArray(), this.getWisLinesArray(), iPortContainer));
        }
        if (observable instanceof ISupportsRMON) {
            this._rmonModels.remove(((ISupportsRMON)((Object)observable)).getRmonModel());
            list.add(new RmonLineUpdate(this.getRmonModelsArray()));
        }
        return list;
    }

    @Override
    public void showTabs() {
        this.addTab("Alarms", (Component)this.getAlarmTab());
        this.addTab("Conditions", (Component)this.getConditionsTab());
        this.addTab("History", (Component)this.getEventTab());
        this.addTab("Circuits", (Component)this.getCircuitTab());
        this.addTab("Provisioning", (Component)this.getProvTab());
        this.addTab("Maintenance", (Component)this.getMaintenanceTab());
        this.addTab("Performance", (Component)this.getPerformanceTab());
    }

    @Override
    public Pane getMaintenanceTab() {
        return new AbstractSubTabbedPane("Maintenance", (TabbedView)this){

            @Override
            public void createSubTabs() {
                AbstractDwdmLineModel[] abstractDwdmLineModelArray;
                Object object;
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
                DwdmCliLineModel[] dwdmCliLineModelArray = DwdmCardTabbedView.this.getCliLinesArray();
                DwdmTrkLineModel[] dwdmTrkLineModelArray = DwdmCardTabbedView.this.getTrkLinesArray();
                DwdmOTULineModel[] dwdmOTULineModelArray = DwdmCardTabbedView.this._otuModels.toArray(new DwdmOTULineModel[0]);
                int n = dwdmCliLineModelArray.length;
                int n2 = dwdmTrkLineModelArray.length;
                int n3 = dwdmOTULineModelArray.length;
                InterfaceModel[] interfaceModelArray = new AbstractDwdmLineModel[n + n2 + n3];
                System.arraycopy(dwdmCliLineModelArray, 0, interfaceModelArray, 0, n);
                System.arraycopy(dwdmTrkLineModelArray, 0, interfaceModelArray, n, n2);
                System.arraycopy(dwdmOTULineModelArray, 0, interfaceModelArray, n + n2, n3);
                dwdmModuleModel.sortLineModels((AbstractDwdmLineModel[])interfaceModelArray);
                InterfaceModel[] interfaceModelArray2 = interfaceModelArray;
                InterfaceModel[] interfaceModelArray3 = null;
                boolean bl = false;
                if (interfaceModelArray2 != null && interfaceModelArray2.length > 0) {
                    object = new ArrayList<AbstractDwdmLineModel>(Arrays.asList(interfaceModelArray2));
                    abstractDwdmLineModelArray = ((ArrayList)object).iterator();
                    while (abstractDwdmLineModelArray.hasNext()) {
                        AbstractDwdmLineModel abstractDwdmLineModel = abstractDwdmLineModelArray.next();
                        try {
                            if (abstractDwdmLineModel.getModuleModel().getEqType() != 293 || abstractDwdmLineModel.getDataRate() != 39) continue;
                            abstractDwdmLineModelArray.remove();
                            bl = true;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                        catch (WrongInterfaceType wrongInterfaceType) {
                            SDebug.printStackTrace((Throwable)wrongInterfaceType);
                        }
                    }
                    interfaceModelArray3 = ((ArrayList)object).toArray(new InterfaceModel[((ArrayList)object).size()]);
                }
                object = null;
                object = bl ? new NxpAlsPane("ALS", this.subTabs, interfaceModelArray3) : new NxpAlsPane("ALS", this.subTabs, interfaceModelArray);
                interfaceModelArray = dwdmModuleModel.removeIlkTrkLineModels((AbstractDwdmLineModel[])interfaceModelArray);
                this.subTabs.addTab("Loopback", (Component)((Object)new DwdmLineMaintenancePane("Loopback", this.subTabs, (AbstractDwdmLineModel[])interfaceModelArray)));
                this.subTabs.addTab("ALS", (Component)object);
                this.subTabs.addTab("Info", (Component)((Object)new DwdmInfoMaintenancePane("Info", this.subTabs)));
                abstractDwdmLineModelArray = dwdmModuleModel.removeNonAINSLineModels((AbstractDwdmLineModel[])interfaceModelArray);
                this.subTabs.addTab("AINS Soak", (Component)this.getSoakPane(abstractDwdmLineModelArray, !dwdmModuleModel.isMxpMr25G()));
                this.subTabs.addTab("Protection", (Component)CardTabbedView.getProtectionPane(this.subTabs));
                if (dwdmModuleModel.isADMCard()) {
                    this.subTabs.addTab("Path Trace", (Component)CardTabbedView.getPathTracePane(interfaceModelArray, this.subTabs));
                }
                if (((ModuleModel)this.getUiModel()).isOFBLSupported()) {
                    this.subTabs.addTab("OBFL", (Component)((Object)new ObflPane("OBFL", this.subTabs, (ModuleModel)this.getUiModel())));
                }
                if (((DwdmModuleModel)this.getUiModel()).isPolluceCard()) {
                    this.subTabs.addTab("Show Commands", (Component)((Object)new MaintShowCmdPane("Show Commands", this.subTabs)));
                }
            }

            private Pane getSoakPane(AbstractDwdmLineModel[] abstractDwdmLineModelArray, boolean bl) {
                return new SoakMaintenancePane("AINS Soak", this.subTabs, abstractDwdmLineModelArray, bl){

                    @Override
                    protected void refreshMyLines(Object object) {
                        DwdmModuleModel dwdmModuleModel;
                        AbstractDwdmLineModel[] abstractDwdmLineModelArray;
                        if (object instanceof DwdmLineUpdate && (abstractDwdmLineModelArray = (dwdmModuleModel = (DwdmModuleModel)this.getUiModel()).removeIlkTrkLineModels(((DwdmLineUpdate)object).getDwdmLineModels())) != null && (abstractDwdmLineModelArray = dwdmModuleModel.removeNonAINSLineModels(abstractDwdmLineModelArray)) != null) {
                            this.models = abstractDwdmLineModelArray;
                            this.dataModel.refreshMyLines(this.models);
                        }
                    }
                };
            }
        };
    }

    @Override
    public Pane getPerformanceTab() {
        return new DwdmPerfPane("Performance", this);
    }

    @Override
    public Pane getProvTab() {
        return new DwdmProvPane("Provisioning", this);
    }

    public Pane getInventoryTab() {
        return new CardInventoryPane("Inventory", this);
    }

    @Override
    public void destroy() {
        this._payloadToClientModels.clear();
        this._payloadToTrunkModels.clear();
        this._gfpModels.clear();
        this._lexModels.clear();
        this._rmonModels.clear();
        this.getOM().removeObservable((Observable[])this._trunkModels.toArray(new DwdmTrkLineModel[this._trunkModels.size()]));
        this._trunkModels.clear();
        this.getUiModel().deleteObserver((Observer)this);
        super.destroy();
    }
}

