/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.DwdmLineTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DwdmG709LineProvPane
extends NodeProvPane
implements TableModelListener {
    protected DwdmLineTableModel dataModel;
    protected DwdmModuleModel eqpmtModel;
    protected AbstractDwdmLineModel[] lineModels;
    protected static final SDebug db = new SDebug("DwdmLineProvPane");

    public DwdmG709LineProvPane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(string, tabbedView);
        this.lineModels = abstractDwdmLineModelArray;
    }

    protected void init() {
        this.eqpmtModel = (DwdmModuleModel)this.getUiModel();
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane, "Center");
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.registerWithModel();
        this.registerForLineUpdates();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(DwdmLineTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        String string = "EFec";
        String string2 = null;
        String string3 = null;
        switch (this.eqpmtModel.getEqType()) {
            case 182: 
            case 276: {
                string2 = "mxpMappingType";
                break;
            }
            case 243: 
            case 282: {
                string2 = "mappingTypeSynch";
                break;
            }
            case 181: 
            case 273: 
            case 274: 
            case 275: {
                string2 = ((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty() && ((EntityModel)this.getUiModel()).getDescendantsOfEqType(326).isEmpty() ? "txpMappingType" : "otuMappingType";
                string = "EFec";
                break;
            }
            case 271: 
            case 272: {
                string = "EFec";
                break;
            }
            case 300: 
            case 301: 
            case 356: 
            case 358: {
                string = "EFecNoDisable";
                break;
            }
            case 293: {
                string3 = "otu2xpMappingType";
                string = "EFec";
                break;
            }
            default: {
                string = "Fec";
            }
        }
        this.setAttrCellEditor(2, string);
        if (string2 == null) {
            this.removeColumn(5);
        } else {
            this.setAttrCellEditor(5, string2);
        }
        if (((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty()) {
            this.setAttrCellEditor(1, "G%7%0%9OTN");
        } else {
            this.setAttrCellEditor(1, "G%7%0%9ENABLE");
        }
        if (string3 == null) {
            this.removeColumn(6);
        } else {
            this.setAttrCellEditor(6, string3);
        }
        this.setAttrCellEditor(4, "declareSdBerLevel");
    }

    protected void setAttrCellEditor(int n, String string) {
        this.setAttrCellEditor(n, string, -1);
    }

    protected void setAttrCellEditor(int n, String string, int n2) {
        TableColumn tableColumn = this.table.getColumn(DwdmLineTableModel.columnNames[n]);
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            if (n2 == -1) {
                tableColumn.setPreferredWidth(tableColumn.getWidth());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            db.println("WARNING: cannot find attributes for " + string + "\nPlease edit ElementDefaults.java");
            this.table.removeColumn(tableColumn);
        }
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(DwdmLineTableModel.columnNames[n]);
        this.table.removeColumn(tableColumn);
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected JComboBox getPJMonitorCombo() {
        JComboBox jComboBox = new JComboBox();
        return jComboBox;
    }

    protected DwdmLineTableModel getDataModel() {
        return new DwdmLineTableModel(this.lineModels);
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        try {
            this.dataModel.applyToModel();
            this.resetDirty();
        }
        catch (Exception exception) {
            this.refresh();
            throw exception;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if ((this.eqpmtModel.getEqType() == 181 || this.eqpmtModel.getEqType() == 274 || this.eqpmtModel.getEqType() == 274) && tableModelEvent.getColumn() == 1) {
            int n = this.table.getEditingRow();
            this.enableAySyMapColumn(n);
        }
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    private void enableAySyMapColumn(int n) {
        Attribute[] attributeArray;
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        TableColumn tableColumn = this.table.getColumn(DwdmLineTableModel.columnNames[5]);
        String string = this.dataModel.getValueAt(n, 1).toString();
        if (string == (attributeArray = this.getAttributeArray("G%7%0%9OTN"))[0].toString()) {
            defaultTableCellRenderer.setEnabled(false);
        } else {
            defaultTableCellRenderer.setEnabled(true);
        }
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        this.table.updateUI();
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                DwdmG709LineProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In DwdmLineProvPane changeMessage cannot find Model " + observable);
        }
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unregisterWithModel() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void dispose() {
        db.info("Called dispose");
        this.unregisterWithModel();
        super.dispose();
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        if (DwdmModuleModel.isTxp10ECard(this.eqpmtModel.getEqType())) {
            for (int i = 0; i < this.lineModels.length; ++i) {
                this.enableAySyMapColumn(i);
            }
        }
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.getDwdmOTNSupportedLineModels();
        if (dwdmModuleModel.isADMCard()) {
            abstractDwdmLineModelArray = dwdmModuleModel.getAdmDwdmTrkLineModels();
        }
        this.lineModels = dwdmModuleModel.isPolluceCard() || ((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty() && ((EntityModel)this.getUiModel()).getDescendantsOfEqType(326).isEmpty() ? abstractDwdmLineModelArray : dwdmModuleModel.getDwdmLineModels();
        if (this.dataModel == null) {
            this.init();
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmG709LineProvPane;
    }

    @Override
    public void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        this.lineModels = dwdmLineUpdate.getDwdmOTNSupportLineModels();
        if (this.getUiModel() instanceof DwdmModuleModel && !((DwdmModuleModel)this.getUiModel()).isPolluceCard()) {
            DwdmModuleModel dwdmModuleModel;
            IModel iModel;
            this.lineModels = ((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty() && ((EntityModel)this.getUiModel()).getDescendantsOfEqType(326).isEmpty() ? ((iModel = this.getUiModel()) instanceof DwdmModuleModel ? ((dwdmModuleModel = (DwdmModuleModel)iModel).isADMCard() ? dwdmModuleModel.removeIlkTrkLineModels(dwdmModuleModel.getAdmDwdmTrkLineModels()) : dwdmModuleModel.removeIlkTrkLineModels(dwdmLineUpdate.getDwdmTrkLineModels())) : dwdmLineUpdate.getDwdmTrkLineModels()) : dwdmLineUpdate.getDwdmLineModels();
        }
        this.dataModel.refreshMyLines(this.lineModels);
    }
}

