/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.IOTULineModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.MrSlot;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.TraceMode;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MutablePortsProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.Dwdm40GPathProvPane;
import cerent.cms.ui.dwdm.DwdmCardDualPane;
import cerent.cms.ui.dwdm.DwdmCardProvPane;
import cerent.cms.ui.dwdm.DwdmG709LineProvPane;
import cerent.cms.ui.dwdm.DwdmLineThresholdPane;
import cerent.cms.ui.dwdm.DwdmPayloadLinePane;
import cerent.cms.ui.dwdm.FECThresholdPane;
import cerent.cms.ui.dwdm.FRRProvPane;
import cerent.cms.ui.dwdm.OTU2xpPathProvPane;
import cerent.cms.ui.dwdm.OpticalThresholdPane;
import cerent.cms.ui.dwdm.OtnThresholdPane;
import cerent.cms.ui.dwdm.Otu2xpCardProvPane;
import cerent.cms.ui.ppm.PpmProvPane;
import cerent.cms.ui.trace.GenericTraceProvPane;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class DwdmProvPane
extends AbstractSubTabbedPane
implements ITabName {
    private static final String OTN_LINE_PROV_TAB = "OTN Lines";
    private static final String OTN_PROVISIONING_TAB = "OTN";

    public DwdmProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        if (((DwdmModuleModel)this.getUiModel()).getEqType() == 293 || ((DwdmModuleModel)this.getUiModel()).isPolluceCard()) {
            this.registerLineModels((DwdmModuleModel)this.getUiModel());
        }
    }

    public void registerLineModels(DwdmModuleModel dwdmModuleModel) {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.getDwdmLineModels();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (abstractDwdmLineModelArray[i] == null) continue;
            abstractDwdmLineModelArray[i].addObserver((Observer)((Object)this));
        }
        if (dwdmModuleModel.isPolluceCard()) {
            TdmPortModel[] tdmPortModelArray;
            for (TdmPortModel tdmPortModel : tdmPortModelArray = dwdmModuleModel.getWisPorts()) {
                tdmPortModel.getITdmLineModel().addObserver((Observer)((Object)this));
            }
        }
    }

    public void unregisterLineModels(DwdmModuleModel dwdmModuleModel) {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.getDwdmLineModels();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (abstractDwdmLineModelArray[i] == null) continue;
            abstractDwdmLineModelArray[i].deleteObserver((Observer)((Object)this));
        }
        if (dwdmModuleModel.isPolluceCard()) {
            TdmPortModel[] tdmPortModelArray;
            for (TdmPortModel tdmPortModel : tdmPortModelArray = dwdmModuleModel.getWisPorts()) {
                tdmPortModel.getITdmLineModel().deleteObserver((Observer)((Object)this));
            }
        }
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        db.info("Got an Update Message for " + observable);
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                DwdmProvPane.this.refreshTabs();
            }
        };
    }

    private void refreshTabs() {
        int n = this.subTabs.indexOfTab(OTN_PROVISIONING_TAB);
        if (n > -1) {
            TabbedView tabbedView;
            int n2 = this.subTabs.getSelectedIndex();
            Component component = this.subTabs.getSelectedComponent();
            int n3 = -1;
            if (component instanceof Pane && (tabbedView = ((Pane)component).getSubTabs()) != null && tabbedView.getTabCount() > 0) {
                n3 = tabbedView.getSelectedIndex();
            }
            this.subTabs.removeTabAt(n);
            this.subTabs.insertTab(OTN_PROVISIONING_TAB, null, (Component)this.getOTNProvTab(this.subTabs), "", n);
            if (n2 > -1) {
                this.subTabs.setSelectedIndex(n2);
                component = this.subTabs.getSelectedComponent();
                if (component instanceof Pane && (tabbedView = ((Pane)component).getSubTabs()) != null && n3 > -1 && tabbedView.getTabCount() > 0) {
                    tabbedView.setSelectedIndex(n3);
                }
            }
        }
    }

    @Override
    public void dispose() {
        db.info("Called dispose");
        this.unregisterLineModels((DwdmModuleModel)this.getUiModel());
        super.dispose();
    }

    @Override
    protected void createSubTabs() {
        boolean bl;
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        this.subTabs.addTab("Line", (Component)((Object)new DwdmPayloadLinePane("Line", this.subTabs, dwdmModuleModel)));
        if (dwdmModuleModel.getEqType() == 293) {
            this.subTabs.addTab("Path", (Component)((Object)new OTU2xpPathProvPane("Path", this.subTabs, dwdmModuleModel)));
        }
        boolean bl2 = bl = dwdmModuleModel.getEqType() == 356 || dwdmModuleModel.getEqType() == 301;
        if (bl) {
            this.subTabs.addTab("Path", (Component)((Object)new Dwdm40GPathProvPane("Path", this.subTabs, dwdmModuleModel)));
        }
        this.subTabs.addTab("Line Thresholds", (Component)((Object)new DwdmLineThresholdPane("Line Thresholds", this.subTabs, dwdmModuleModel)));
        this.subTabs.addTab("Optics Thresholds", (Component)((Object)new OpticalThresholdPane("Optics Thresholds", this.subTabs, dwdmModuleModel)));
        if (dwdmModuleModel.supportsOTN()) {
            this.subTabs.addTab(OTN_PROVISIONING_TAB, (Component)this.getOTNProvTab(this.subTabs));
        }
        if (dwdmModuleModel.supportPPM()) {
            if (dwdmModuleModel.isADMCard()) {
                this.subTabs.addTab("Pluggable Port Modules", (Component)((Object)new PpmProvPane("Pluggable Port Modules", this.subTabs, true)));
            } else {
                this.subTabs.addTab("Pluggable Port Modules", (Component)((Object)new PpmProvPane("Pluggable Port Modules", this.subTabs, false)));
            }
        } else {
            MrSlot mrSlot = dwdmModuleModel.getMrSlot();
            this.subTabs.addTab("Data Rate Selection", (Component)((Object)new MutablePortsProvPane("Data Rate Selection", this.subTabs, new IPortContainer[]{mrSlot}, mrSlot.getEqType(), false, CSHelpConst.MrPortProvPane, db)));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        if (dwdmModuleModel.getEqType() == 293) {
            this.subTabs.addTab("Card", (Component)((Object)new Otu2xpCardProvPane("Card", this.subTabs)));
        } else {
            this.subTabs.addTab("Card", (Component)((Object)new DwdmCardProvPane("Card", this.subTabs)));
        }
    }

    private Pane getOTNProvTab(TabbedView tabbedView) {
        return new AbstractSubTabbedPane(OTN_PROVISIONING_TAB, tabbedView){
            private boolean panesBuilt;
            private Pane otnLineTab;
            private Pane g709ThrTab;
            private Pane fecThrTab;
            private Pane ttiPane;
            private Pane frrPane;
            private AbstractDwdmLineModel[] _trunkModels;
            private DwdmModuleModel mm;
            {
                this.panesBuilt = false;
            }

            @Override
            public void createSubTabs() {
                this.mm = (DwdmModuleModel)this.getUiModel();
                this._trunkModels = this.mm.isADMCard() ? this.mm.getAdmDwdmTrkLineModels() : this.mm.getDwdmOTNSupportedLineModels();
                if (!this.panesBuilt) {
                    AbstractDwdmLineModel[] abstractDwdmLineModelArray = this.mm.getDwdmLineModels();
                    this.otnLineTab = this.getOTNLineTab(abstractDwdmLineModelArray);
                    this.g709ThrTab = this.getOtnThresholdsTab(this._trunkModels);
                    this.fecThrTab = this.getFECThresholdsTab(this._trunkModels);
                    ArrayList<IOTULineModel> arrayList = new ArrayList<IOTULineModel>();
                    for (AbstractDwdmLineModel abstractDwdmLineModel : this._trunkModels) {
                        try {
                            arrayList.add(abstractDwdmLineModel.getIOTULineModel());
                        }
                        catch (WrongInterfaceType wrongInterfaceType) {
                            SDebug.printStackTrace((Throwable)wrongInterfaceType);
                        }
                    }
                    this.ttiPane = this.getTTITab(arrayList.toArray(new IGenericTraceLine[0]));
                    if (this.mm.getEqType() == 293) {
                        this.frrPane = this.getFRRTab(this._trunkModels);
                    }
                    this.panesBuilt = true;
                }
                this.setupTabs();
                if (this.mm.hasPluggableTrunk()) {
                    if (db.on()) {
                        db.println("Registering for pluggable trunk line update");
                    }
                    this.registerWithModel();
                }
            }

            private void setupTabs() {
                this.subTabs.addTab(DwdmProvPane.OTN_LINE_PROV_TAB, (Component)this.otnLineTab);
                this.subTabs.addTab("ITU-T G.709 Thresholds", (Component)this.g709ThrTab);
                this.subTabs.addTab("FEC Thresholds", (Component)this.fecThrTab);
                if (this._trunkModels.length > 0) {
                    this.subTabs.addTab("Trail Trace Identifier", (Component)this.ttiPane);
                    if (this.mm.getEqType() == 293) {
                        this.subTabs.addTab("Proactive Protection Regen", (Component)this.frrPane);
                    }
                }
            }

            private Pane getOTNLineTab(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
                return new DwdmG709LineProvPane(DwdmProvPane.OTN_LINE_PROV_TAB, this.subTabs, abstractDwdmLineModelArray);
            }

            private Pane getOtnThresholdsTab(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, abstractDwdmLineModelArray, new OtnThresholdPane("ITU-T G.709 Thresholds", this.subTabs, abstractDwdmLineModelArray), 4);
            }

            private Pane getFECThresholdsTab(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, abstractDwdmLineModelArray, new FECThresholdPane("FEC Thresholds", this.subTabs, abstractDwdmLineModelArray), 4);
            }

            private Pane getTTITab(IGenericTraceLine[] iGenericTraceLineArray) {
                return new GenericTraceProvPane("Trail Trace Identifier", this.subTabs, TraceMode.TTI, iGenericTraceLineArray, 1);
            }

            private Pane getFRRTab(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
                return new FRRProvPane("Proactive Protection Regen", this.subTabs, abstractDwdmLineModelArray);
            }

            @Override
            protected void refreshMyLines(Object object) {
                if (object instanceof DwdmLineUpdate) {
                    DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
                    AbstractDwdmLineModel[] abstractDwdmLineModelArray = this.mm.isADMCard() ? this.mm.removeIlkTrkLineModels(this.mm.getAdmDwdmTrkLineModels()) : dwdmLineUpdate.getDwdmOTNSupportLineModels();
                    if (abstractDwdmLineModelArray.length != this._trunkModels.length) {
                        if (db.on()) {
                            db.println("Refreshing " + this.getFullName() + " pm subtabs for change in trunk number, from " + this._trunkModels.length + " to " + abstractDwdmLineModelArray.length);
                        }
                        this._trunkModels = abstractDwdmLineModelArray;
                        if (this.mm.getEqType() == 293 || this.mm.isPolluceCard()) {
                            DwdmProvPane.this.registerLineModels(this.mm);
                        }
                        this.subTabs.removeAll();
                        this.setupTabs();
                    }
                }
            }
        };
    }
}

