/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.WLenSelectorPopup;
import cerent.cms.ui.dwdm.DwdmTrkMlseTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DwdmTrkMlsePane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected static final SDebug db = new SDebug("DwdmTrkMlsePane");
    protected DwdmTrkMlseTableModel dataModel;
    protected DwdmModuleModel eqpmtModel;
    protected DwdmTrkLineModel[] lineModels;
    protected int numLines;
    private boolean notInited = true;
    private WLenSelectorPopup.DefaultWLDialogValue dv;
    private final int INVALID_INDEX = -1;

    public DwdmTrkMlsePane(String string, TabbedView tabbedView, DwdmTrkLineModel[] dwdmTrkLineModelArray) {
        super(string, tabbedView);
        this.lineModels = dwdmTrkLineModelArray;
        this.numLines = dwdmTrkLineModelArray.length;
        this.eqpmtModel = (DwdmModuleModel)this.getUiModel();
        this.dataModel = this.getDataModel();
    }

    protected void init() {
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.notInited = false;
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setPreferredWidth(150);
        Attribute[] attributeArray = this.getAttributeArray("G%7%0%9OTN");
        tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Attribute>(attributeArray)));
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    protected DwdmTrkMlseTableModel getDataModel() {
        return new DwdmTrkMlseTableModel(this.lineModels);
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1 && this.dataModel != null) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In DwdmTrkMlsePane changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
        this.unRegisterWithModel();
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                DwdmTrkMlsePane.this.refreshLine(observable);
            }
        };
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmTrkMlsePane;
    }
}

