/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Dwdm.eRevertThreshold;
import cerent.cms.idl.Dwdm.eTriggerThreshold;
import cerent.cms.idl.Dwdm.sProactiveProtectionConfig;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.awt.Frame;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class FRRProvTableModel
extends AbstractTableModel {
    private boolean[] rowDirty;
    protected sProactiveProtectionConfig[] frrConfigVals = null;
    public static final String[] columnNames = new String[]{"Port ", "Trigger Threshold", "Trigger Window (ms)", "Revert Threshold", "Revert Window (ms)"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int TRIGGER_THRESHOLD_INDEX = 1;
    public static final int TRIGGER_WINDOW_INDEX = 2;
    public static final int REVERT_THRESHOLD_INDEX = 3;
    public static final int REVERT_WINDOW_INDEX = 4;
    protected int numLines;
    protected AbstractDwdmLineModel[] models;
    protected EntityCellRenderer myPortRenderer;
    protected String[] portNames;
    protected ModuleModel eqpmtModel;
    private static final SDebug db = new SDebug("FRRProvTableModel");

    public FRRProvTableModel(ModuleModel moduleModel, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        this.eqpmtModel = moduleModel;
        this.models = abstractDwdmLineModelArray;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.init();
    }

    private void init() {
        this.numLines = this.models.length;
        this.portNames = new String[this.numLines];
        this.rowDirty = new boolean[this.numLines];
        this.frrConfigVals = new sProactiveProtectionConfig[this.numLines];
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        this.models = abstractDwdmLineModelArray;
        this.init();
        this.fireTableDataChanged();
        if (db.on()) {
            db.println("Refreshing the table lines...");
            db.println("New models = " + this.models);
        }
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    protected Attribute getTriggerThreshold(int n) {
        if (this.frrConfigVals[n] == null) {
            try {
                this.frrConfigVals[n] = this.models[n].getIOTULineModel().getProactiveProtectionConfig();
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting Trigger Threshold:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.severe("Error in getting Trigger Threshold:" + wrongInterfaceType.toString());
            }
        }
        int n2 = this.frrConfigVals[n].triggerThreshold.value();
        Attribute attribute = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal("declFRRTriggerThreshold", n2);
        db.fine("Trigger Threshold Index is " + n2);
        return attribute;
    }

    protected Integer getTriggerWindow(int n) {
        if (this.frrConfigVals[n] == null) {
            try {
                this.frrConfigVals[n] = this.models[n].getIOTULineModel().getProactiveProtectionConfig();
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting Trigger Window:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.severe("Error in getting Trigger Window:" + wrongInterfaceType.toString());
            }
        }
        Integer n2 = new Integer(this.frrConfigVals[n].triggerWindow);
        db.fine("Trigger window  is " + n2);
        return n2;
    }

    protected Attribute getRevertThreshold(int n) {
        if (this.frrConfigVals[n] == null) {
            try {
                this.frrConfigVals[n] = this.models[n].getIOTULineModel().getProactiveProtectionConfig();
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting revert Threshold:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.severe("Error in getting revert Threshold:" + wrongInterfaceType.toString());
            }
        }
        int n2 = this.frrConfigVals[n].revertThreshold.value();
        Attribute attribute = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal("declFRRRevertThreshold", n2);
        db.fine("revert Threshold Index is " + n2);
        return attribute;
    }

    protected Integer getRevertWindow(int n) {
        if (this.frrConfigVals[n] == null) {
            try {
                this.frrConfigVals[n] = this.models[n].getIOTULineModel().getProactiveProtectionConfig();
            }
            catch (NoSuchInterface noSuchInterface) {
                db.severe("Error in getting revert Window:" + noSuchInterface.toString());
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.severe("Error in getting revert Window:" + wrongInterfaceType.toString());
            }
        }
        Integer n2 = new Integer(this.frrConfigVals[n].revertWindow);
        db.fine("revert window  is " + n2);
        return n2;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        db.fine("Change in value " + n + " " + n2);
        switch (n2) {
            case 1: {
                Attribute attribute = (Attribute)object;
                eTriggerThreshold eTriggerThreshold2 = eTriggerThreshold.from_int(attribute.getIntValue());
                if (eTriggerThreshold2 == this.frrConfigVals[n].triggerThreshold) {
                    return;
                }
                this.frrConfigVals[n].triggerThreshold = eTriggerThreshold2;
                break;
            }
            case 2: {
                if (object instanceof Integer) {
                    this.frrConfigVals[n].triggerWindow = (Integer)object;
                    break;
                }
                this.displayInvalidNumberDialog(2);
                break;
            }
            case 3: {
                Attribute attribute = (Attribute)object;
                eRevertThreshold eRevertThreshold2 = eRevertThreshold.from_int(attribute.getIntValue());
                if (eRevertThreshold2 == this.frrConfigVals[n].revertThreshold) {
                    return;
                }
                this.frrConfigVals[n].revertThreshold = eRevertThreshold2;
                break;
            }
            case 4: {
                if (object instanceof Integer) {
                    this.frrConfigVals[n].revertWindow = (Integer)object;
                    break;
                }
                this.displayInvalidNumberDialog(4);
                return;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private void displayInvalidNumberDialog(int n) {
        JOptionPane.showMessageDialog(this.getFrame(), "An invalid number was entered in column " + this.getColumnName(n) + ".", "Invalid Number Entered", 0);
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.models != null && this.numLines > 0 && n2 != 0;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 2: 
            case 4: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType {
        IPortModel iPortModel = this.models[n] instanceof AbstractDwdmLineModel ? (this.models[n].getPayloadModel() != null ? this.models[n].getPayloadModel().getPortModel() : this.models[n].getPortModel()) : this.models[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return this.getTriggerThreshold(n);
                }
                case 3: {
                    return this.getRevertThreshold(n);
                }
                case 2: {
                    return this.getTriggerWindow(n);
                }
                case 4: {
                    return this.getRevertWindow(n);
                }
            }
        }
        catch (Exception exception) {
            db.severe("getValueAt: Error in getting values " + exception);
        }
        return "N/A";
    }

    private void resetLineCache(int n) {
        this.portNames[n] = null;
        this.frrConfigVals[n] = null;
        this.rowDirty[n] = false;
    }

    public void refreshLineFromModel(int n) throws AnnotatedException {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        try {
            this.frrConfigVals[n] = this.models[n].getIOTULineModel().getProactiveProtectionConfig();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("An error occurred while refreshing row " + (n + 1) + ".", exception);
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        db.fine("refreshing table from model");
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            this.models[i].getIOTULineModel().setProactiveProtectionConfig(this.frrConfigVals[i]);
            this.rowDirty[i] = false;
        }
    }

    protected Frame getFrame() {
        return this.eqpmtModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }
}

