/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;

public class OTU2HoSonetTableModel
extends TdmTableModel {
    public String[] columnNames;
    protected INodeModel node;
    protected TdmHoModel[] hoModels;
    protected EntityCellRenderer myPortRenderer;
    protected String[] portNums;
    protected boolean[][] isDirty;
    protected boolean isSonet;
    private Attribute[] sfBerLevel;
    private Attribute[] sdBerLevel;
    private String sdString;
    private String sfString;
    public static final int PORTNUMBER_INDEX = 0;
    public static final int SFBERLEVEL_INDEX = 1;
    public static final int SDBERLEVEL_INDEX = 2;
    protected static final int NUM_OF_COLUMNS = 3;
    private static final SDebug db = new SDebug("OTU2HoSonetTableModel");

    public OTU2HoSonetTableModel(INodeModel iNodeModel, TdmHoModel[] tdmHoModelArray) {
        super(iNodeModel);
        this.hoModels = tdmHoModelArray;
        this.node = iNodeModel;
        this.myPortRenderer = new EntityCellRenderer(false);
        String[] stringArray = new String[]{"Port", "SF BER", "SD BER"};
        this.columnNames = stringArray;
        this.init();
    }

    protected void init() {
        this.numLines = this.hoModels.length;
        this.portNums = new String[this.numLines];
        this.sfBerLevel = new Attribute[this.numLines];
        this.sdBerLevel = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.sdString = "declareSdBerLevel";
        this.sfString = "declareSfBerLevel";
        this.resetDirtyBits();
        this.isSonet = this.node.getTdmProtocolTypeObj().isSonet();
    }

    private int getSfBerLevel(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getSfBerLevelIndex(n).getIntValue();
    }

    private int getSdBerLevel(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getSdBerLevelIndex(n).getIntValue();
    }

    private Attribute getSdBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sdBerLevel[n] == null) {
            this.sdBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sdString, this.hoModels[n].getHoSfSdModel().getSdBerLevel());
        }
        return this.sdBerLevel[n];
    }

    private Attribute getSfBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sfBerLevel[n] == null) {
            this.sfBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sfString, this.hoModels[n].getHoSfSdModel().getSfBerLevel());
        }
        return this.sfBerLevel[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.hoModels != null && this.numLines > 0 && n2 != 0 && AbstractPane.isUserAuthorized(this.hoModels[0], SecurityLevel.PROVISIONING) && n != 1;
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.node.getTdmProtocolType(), this.getTerms());
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block9: {
            if (n < 0 || n >= this.getRowCount()) {
                if (db.on()) {
                    db.println("Array index out of bounds in getValueAt");
                }
                return null;
            }
            try {
                switch (n2) {
                    case 0: {
                        return this.getPortNum(n);
                    }
                    case 1: {
                        return this.getSfBerLevelIndex(n);
                    }
                    case 2: {
                        return this.getSdBerLevelIndex(n);
                    }
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in getValueAt");
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    protected String getPortNum(int n) {
        block3: {
            if (this.portNums[n] == null) {
                try {
                    this.portNums[n] = PortHelper.getPortNumAndTypeString((IPortModel)this.hoModels[n].getPortModel(), (boolean)false, (boolean)true);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Caught NoSuchEntity in getPortNum!");
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return this.portNums[n];
    }

    public void refreshMyLines(TdmHoModel[] tdmHoModelArray) {
        this.hoModels = tdmHoModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNums[n] = null;
        this.sfBerLevel[n] = null;
        this.sdBerLevel[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    @Override
    public int getRowCount() {
        return this.hoModels.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    public void applyToModel() throws AnnotatedException, NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            try {
                if (this.isDirty(i, 1)) {
                    this.hoModels[i].getHoSfSdModel().setSfBerLevel((short)this.getSfBerLevel(i));
                }
                if (!this.isDirty(i, 2)) continue;
                this.hoModels[i].getHoSfSdModel().setSdBerLevel((short)this.getSdBerLevel(i));
                continue;
            }
            catch (Exception exception) {
                throw new AnnotatedException("An error occurred while applying changes to row " + (i + 1) + ".", exception);
            }
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        try {
            switch (n2) {
                case 1: {
                    this.sfBerLevel[n] = (Attribute)object;
                    break;
                }
                case 2: {
                    this.sdBerLevel[n] = (Attribute)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in setValueAt");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }
}

