/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sTime;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ElementPmCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.OpticsPmHistTableModel;
import cerent.cms.ui.dwdm.OpticsPmPane;
import cerent.cms.ui.dwdm.OpticsPmTableModel;
import cerent.cms.ui.tnc.TNCOpticsPmHistTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IAsyncObserver;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class OpticsPmHistPane
extends OpticsPmPane
implements IAsyncObserver,
Runnable,
PropertyChangeListener {
    private String intervalStr = "15-minute";
    private String statusString;
    private JobStatus jobStatus;
    private ElementPmCellRenderer pmCellRenderer;
    private TableColumn colZero = null;
    private JTable table2 = null;
    private static final SDebug db = new SDebug("OpticsPmHistPane");

    public OpticsPmHistPane(String string, TabbedView tabbedView, IOpticsPmModel[] iOpticsPmModelArray) {
        super(string, tabbedView, iOpticsPmModelArray);
    }

    @Override
    protected void localInit() {
        this.setLayout(new BorderLayout());
        this.table = new UTable((TableModel)this.dataModel);
        this.pmCellRenderer = new ElementPmCellRenderer();
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(Long.class, this.pmCellRenderer);
        this.table.setDefaultRenderer(String.class, this.pmCellRenderer);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table2 = new UTable((TableModel)this.dataModel);
        ((UTable)this.table2).setExportable(false);
        this.table2.getTableHeader().setUpdateTableInRealTime(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        this.colZero = tableColumnModel.getColumn(0);
        tableColumnModel.removeColumn(this.colZero);
        this.colZero.setPreferredWidth(this.widths[0]);
        this.colZero.setMinWidth(this.widths[0]);
        defaultTableColumnModel.addColumn(this.colZero);
        this.colZero.addPropertyChangeListener(this);
        this.table.setColumnModel(tableColumnModel);
        this.table2.setColumnModel(defaultTableColumnModel);
        this.table2.setPreferredScrollableViewportSize(new Dimension(this.colZero.getPreferredWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
        this.table2.getTableHeader().setReorderingAllowed(false);
        this.table2.setAutoCreateColumnsFromModel(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(false);
        this.table2.setCellSelectionEnabled(false);
        this.table2.setRowSelectionAllowed(false);
        uScrollPane.setRowHeaderView((Component)this.table2);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)this.table2.getTableHeader());
        JPanel jPanel = OpticsPmHistPane.createVerticalPanel(null);
        uScrollPane.setAlignmentX(0.0f);
        jPanel.add((Component)uScrollPane);
        this.add(jPanel, "Center");
        this.add(this.createButtonBar(true), "South");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    protected OpticsPmTableModel createDataModel() {
        block4: {
            if (this.opticsModels[0] != null) {
                try {
                    if (this.opticsModels[0].getInterfaceModel().getModuleModel().getEqType() == 330) {
                        return new TNCOpticsPmHistTableModel(this, this.nmd);
                    }
                    return new OpticsPmHistTableModel(this, this.nmd);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return null;
    }

    public void fixedUpColumn() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < 1; ++i) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        this.table.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshPB) {
            this.refreshNow();
        } else if (object == this.clearPB) {
            try {
                this.setCursor(3);
                int n = this.portCB.getSelectedIndex();
                if (this.opticsModels[0] != null && this.opticsModels[0].getInterfaceModel().getModuleModel().getEqType() == 330) {
                    ((TNCOpticsPmHistTableModel)this.dataModel).clear(this.opticsModels[n], this);
                }
                ((OpticsPmHistTableModel)this.dataModel).clear(this.opticsModels[n], this);
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_CLEAR_STATS);
            }
            finally {
                this.setCursor(0);
            }
        } else if (object == this.minuteRB) {
            block25: {
                try {
                    if (this.opticsModels[0] != null && this.opticsModels[0].getInterfaceModel().getModuleModel().getEqType() == 330) {
                        ((TNCOpticsPmHistTableModel)this.dataModel).setIntervalType(eIntervalType.INTERVAL_15_MIN);
                    } else {
                        ((OpticsPmHistTableModel)this.dataModel).setIntervalType(eIntervalType.INTERVAL_15_MIN);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block25;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            this.intervalStr = "15-minute";
            this.refreshNow();
        } else if (object == this.dayRB) {
            block26: {
                try {
                    if (this.opticsModels[0] != null && this.opticsModels[0].getInterfaceModel().getModuleModel().getEqType() == 330) {
                        ((TNCOpticsPmHistTableModel)this.dataModel).setIntervalType(eIntervalType.INTERVAL_DAY);
                    } else {
                        ((OpticsPmHistTableModel)this.dataModel).setIntervalType(eIntervalType.INTERVAL_DAY);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block26;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            this.intervalStr = "1-day";
            this.refreshNow();
        } else if (object == this.portCB) {
            this.refreshNow();
        } else if (db.on()) {
            db.println("actionPerformed by unknown component");
        }
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        int n = Preferences.instance().getInt(this.autoRefreshPrefPath, this.autoRefreshPrefKey, 0);
        if (null != this.refreshComboBox) {
            int n2 = this.getIndexForMillis(n);
            this.refreshComboBox.setSelectedIndex(n2);
            if (null != this.refreshTimer) {
                if (0 == n2) {
                    if (db.on()) {
                        db.println("Stopping auto-refresh timer.A");
                    }
                    this.refreshTimer.stop();
                } else if (!this.refreshTimer.isRunning()) {
                    if (db.on()) {
                        db.println("Starting auto-refresh timer.B delay = " + this.refreshTimer.getDelay());
                    }
                    this.refreshTimer.start();
                } else if (db.on()) {
                    db.println("refreshTimer was already running with delay = " + this.refreshTimer.getDelay());
                }
            }
        }
        this.refreshNow();
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (null != this.refreshComboBox) {
            this.saveAutoRefreshPref();
        }
        if (null != this.refreshTimer) {
            if (db.on()) {
                db.println("Stopping auto-refresh timer.B");
            }
            this.refreshTimer.stop();
        }
        super.leavingPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshNow() {
        try {
            this.setCursor(3);
            if (this.portCB.getSelectedIndex() != -1) {
                int n = this.portCB.getSelectedIndex();
                if (this.opticsModels[0] != null && this.opticsModels[0].getInterfaceModel().getModuleModel().getEqType() == 330) {
                    ((TNCOpticsPmHistTableModel)this.dataModel).refresh(this.opticsModels[n], this);
                } else {
                    ((OpticsPmHistTableModel)this.dataModel).refresh(this.opticsModels[n], this);
                }
                this.updateTimeLabel(n);
            } else {
                if (this.opticsModels[0] != null) {
                    if (this.opticsModels[0].getInterfaceModel().getModuleModel().getEqType() == 330) {
                        ((TNCOpticsPmHistTableModel)this.dataModel).refresh(null, this);
                    }
                } else {
                    ((OpticsPmHistTableModel)this.dataModel).refresh(null, this);
                }
                this.dateLB.setText("");
            }
        }
        catch (InternalCommError internalCommError) {
            if (db.on()) {
                db.println("Caught InternalCommError in refreshNow!");
                SDebug.printStackTrace((Throwable)internalCommError);
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Caught NoSuchInterface in refreshNow!");
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught " + exception + " in OpticsPmHistPane.refreshNow");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        finally {
            this.setCursor(0);
        }
    }

    @Override
    protected void updateTimeLabel() {
        this.updateTimeLabel(this.portCB.getSelectedIndex());
    }

    protected void updateTimeLabel(int n) {
        sTime sTime2;
        try {
            sTime2 = this.nmd.getTime();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            sTime2 = new sTime(0, 0, 0, 1, 1, 1970, false);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(sTime2.year, sTime2.month - 1, sTime2.day, sTime2.hour, sTime2.minute, sTime2.second);
        if (this.dateLB != null) {
            this.dateLB.setText(this.intervalStr + ", near-end registers for port #" + (n + 1) + " at " + DateFormat.getDateTimeInstance(1, 1).format(gregorianCalendar.getTime()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.table2 == null || this.colZero == null) {
            db.severe("propertyChange() : on disposed table model");
        } else {
            this.table2.setPreferredScrollableViewportSize(new Dimension(this.colZero.getWidth() + this.table2.getColumnModel().getColumnMargin(), 0));
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.OpticsPmHistPane;
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void dispose() {
        block5: {
            if (this.dataModel != null) {
                try {
                    if (this.opticsModels[0] != null && this.opticsModels[0].getInterfaceModel().getModuleModel().getEqType() == 330) {
                        ((TNCOpticsPmHistTableModel)this.dataModel).dispose();
                    } else {
                        ((OpticsPmHistTableModel)this.dataModel).dispose();
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("Caught " + exception + " in OpticsPmHistPane.refreshNow");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        super.dispose();
    }

    public void asyncUpdate(Object object, JobStatus jobStatus) {
        this.statusString = (String)object;
        this.jobStatus = jobStatus;
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        if (this.jobStatus == JobStatus.JOB_COMPLETE) {
            if (this.portCB.getSelectedIndex() != -1) {
                this.updateTimeLabel(this.portCB.getSelectedIndex());
            }
        } else if (this.statusString != null) {
            this.dateLB.setText("Retrieving " + this.statusString + "...");
        }
    }
}

