/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.PmPane;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.OtnPmTableModel;
import cerent.util.SDebug;

public class OtnPmPane
extends PmPane {
    private AbstractDwdmLineModel[] trunkLines;
    private static final SDebug db = new SDebug("OtnPmPane");

    public OtnPmPane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(string, tabbedView);
        this.trunkLines = abstractDwdmLineModelArray;
        if (db.on()) {
            db.println("<init>");
        }
        if (((DwdmModuleModel)this.getUiModel()).hasPluggableTrunk()) {
            if (db.on()) {
                db.println("Registering for pluggable trunk line update");
            }
            this.registerWithModel();
        }
        this.init();
    }

    @Override
    protected void refreshMyLines(Object object) {
        if (object instanceof DwdmLineUpdate) {
            DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
            DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
            boolean bl = false;
            if (dwdmModuleModel.isPolluceCard()) {
                AbstractDwdmLineModel[] abstractDwdmLineModelArray = dwdmModuleModel.removeIlkTrkLineModels(dwdmLineUpdate.getDwdmLineModels());
                if (abstractDwdmLineModelArray.length != this.trunkLines.length) {
                    bl = true;
                    if (db.on()) {
                        db.println("Refreshing " + this.getFullName() + " for change in trunks number, from " + this.trunkLines.length + " to " + abstractDwdmLineModelArray.length);
                    }
                    this.trunkLines = abstractDwdmLineModelArray;
                }
            } else {
                DwdmTrkLineModel[] dwdmTrkLineModelArray = dwdmModuleModel.removeIlkTrkLineModels(dwdmLineUpdate.getDwdmTrkLineModels());
                if (dwdmTrkLineModelArray.length != this.trunkLines.length) {
                    bl = true;
                    if (db.on()) {
                        db.println("Refreshing " + this.getFullName() + " for change in trunks number, from " + this.trunkLines.length + " to " + dwdmTrkLineModelArray.length);
                    }
                    this.trunkLines = dwdmTrkLineModelArray;
                }
            }
            if (bl) {
                if (db.on()) {
                    db.println("Updating " + this.getTable().getModel());
                }
                ((PmTableModel)this.getTable().getModel()).refreshMyLines(this.trunkLines);
                this.refreshNow();
            }
        }
    }

    @Override
    protected PmTableModel createDataModel() {
        if (db.on()) {
            db.println("createDataModel");
        }
        OtnPmTableModel otnPmTableModel = new OtnPmTableModel(this.trunkLines, (NodeModelDelegate)this.getUiModel().getNodeModel());
        otnPmTableModel.addTableModelListener(this);
        return otnPmTableModel;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.OtnPmPane;
    }
}

