/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.GeneralPmThresholdsPane;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.OtnThresholdTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class OtnThresholdProvPane
extends GeneralPmThresholdsPane
implements TableModelListener {
    AbstractDwdmLineModel[] models;
    OtnThresholdTableModel dataModel;
    eIntervalType intervalType = null;
    boolean nearEnd = false;
    eMonitorType monitorType = null;
    int numLines;
    boolean notInited = true;
    protected static final SDebug db = new SDebug("OtnThresholdProvPane");

    public OtnThresholdProvPane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray, eIntervalType eIntervalType2, boolean bl, eMonitorType eMonitorType2) {
        super(string, tabbedView);
        this.models = abstractDwdmLineModelArray;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.monitorType = eMonitorType2;
        this.init();
    }

    protected void init() {
        this.numLines = this.models.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(OtnThresholdTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.notInited = false;
    }

    @Override
    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].addObserver((Observer)((Object)this));
        }
    }

    @Override
    protected ResettablePmThresholdsTableModel dataModel() {
        return this.dataModel;
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        super.leavingPage();
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.notInited = true;
        super.destroy();
    }

    protected void removeColumn(int n) {
        String string = OtnThresholdTableModel.columnNames[n];
        TableColumn tableColumn = this.table.getColumn(string);
        this.table.removeColumn(tableColumn);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                OtnThresholdProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.models).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            try {
                this.dataModel.refreshLineFromModel(n);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ROW_PARAM_1, (Object)Integer.toString(n + 1));
            }
        } else if (db.on()) {
            db.println("changeMessage cannot find Model " + observable);
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    protected OtnThresholdTableModel getDataModel() {
        return new OtnThresholdTableModel(this.models, this.intervalType, this.nearEnd, this.monitorType);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.OtnThresholdProvPane;
    }
}

