/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.idl.Dwdm.sOTNThresholds;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;

public class OtnThresholdTableModel
extends DwdmTableModel
implements ResettablePmThresholdsTableModel {
    public static final String[] columnNames = new String[]{"Port", "ES", "SES", "UAS", "BBE", "FC"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int ES_INDEX = 1;
    public static final int SES_INDEX = 2;
    public static final int UAS_INDEX = 3;
    public static final int BBE_INDEX = 4;
    public static final int FC_INDEX = 5;
    eIntervalType intervalType = null;
    boolean nearEnd = false;
    eMonitorType monitorType = null;
    protected sOTNThresholds[] thresholdsVal;
    private boolean[] rowDirty;
    private static final SDebug db = new SDebug("OtnThresholdTableModel");

    public OtnThresholdTableModel(AbstractDwdmLineModel[] abstractDwdmLineModelArray, eIntervalType eIntervalType2, boolean bl, eMonitorType eMonitorType2) {
        super(db, abstractDwdmLineModelArray);
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.monitorType = eMonitorType2;
        this.refreshMyLines(abstractDwdmLineModelArray);
    }

    @Override
    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        eEqType eEqType2 = this.model[n].getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.model[n].getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefOtnThr(eEqType2, eEqType3, this.nearEnd, this.intervalType, this.monitorType);
    }

    @Override
    public void setThresholdValue(int n, Object object) {
        if (object instanceof sOTNThresholds) {
            this.thresholdsVal[n] = (sOTNThresholds)object;
        }
    }

    @Override
    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    @Override
    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sOTNThresholds[this.numLines];
    }

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.isProtectedTrunkPort(n) && !this.isProtected40GOTUPort(n)) {
            return n2 > 0;
        }
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.thresholdsVal[n].es);
                }
                case 2: {
                    return new Integer(this.thresholdsVal[n].ses);
                }
                case 3: {
                    return new Integer(this.thresholdsVal[n].uas);
                }
                case 4: {
                    return new Integer(this.thresholdsVal[n].bbe);
                }
                case 5: {
                    return new Integer(this.thresholdsVal[n].fc);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OtnThresholdTableModel: error in getValueAt" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        int n3 = (Integer)object;
        sOTNThresholds sOTNThresholds2 = this.thresholdsVal[n];
        try {
            switch (n2) {
                case 1: {
                    if (sOTNThresholds2.es == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_0 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "ES", object.toString());
                    sOTNThresholds2.es = n3;
                    break;
                }
                case 2: {
                    if (sOTNThresholds2.ses == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_1 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "SES", object.toString());
                    sOTNThresholds2.ses = n3;
                    break;
                }
                case 3: {
                    if (sOTNThresholds2.uas == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_2 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "UAS", object.toString());
                    sOTNThresholds2.uas = n3;
                    break;
                }
                case 4: {
                    if (sOTNThresholds2.bbe == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_3 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "BBE", object.toString());
                    sOTNThresholds2.bbe = n3;
                    break;
                }
                case 5: {
                    if (sOTNThresholds2.fc == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_4 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "FC", object.toString());
                    sOTNThresholds2.fc = n3;
                    break;
                }
                default: {
                    return;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ProvisionError provisionError) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
    }

    public void refreshFromModel() throws Exception {
        this.numLines = this.model.length;
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) throws Exception {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        try {
            this.thresholdsVal[n] = this.model[n].getIOTULineModel().getOTNThresholds(this.nearEnd, this.intervalType, this.monitorType);
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("An error occurred while refreshing row " + (n + 1) + ".", exception);
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
    }

    public void applyToModel() throws Exception {
        if (db.on()) {
            db.println("applyToModel");
        }
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.isRowDirty(n)) continue;
                this.model[n].getIOTULineModel().setOTNThresholds(this.thresholdsVal[n], this.nearEnd, this.intervalType, this.monitorType);
                this.rowDirty[n] = false;
            }
        }
        catch (ConfigError configError) {
            throw new AnnotatedException("The value(s) in row " + (n + 1) + " is/are not in a valid range.", (Exception)((Object)configError));
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }
}

