/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e1;

import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.e13.E13LineTableModel;
import cerent.util.SDebug;

public class E1LineTableModel
extends E13LineTableModel {
    private static final SDebug db = new SDebug("E1LineTableModel");
    public static final int ENABLERETIMING_INDEX = 13;
    public static final int PROVIDESSYNC_INDEX = 14;
    public static final int SYNCMESSAGEIN_INDEX = 15;
    public static final int SENDDONOTUSE_INDEX = 16;
    public static final int E1SABIT_INDEX = 17;
    public static final int ADMINSSM_INDEX = 18;
    public static final int E1_LAST_COLUMN = 18;
    private sLineSyncConfig[] syncConfig;
    private Attribute[] saBit;
    private Boolean[] retimingEnabled;
    public static final String[] e1ColumnNames = new String[19];

    public E1LineTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        super(iNodeModel, ds123LineModelArray);
        this.retimingEnabled = new Boolean[this.numLines];
        this.syncConfig = new sLineSyncConfig[this.numLines];
        this.saBit = new Attribute[this.numLines];
    }

    @Override
    public int getRangeFor(int n) {
        return 0;
    }

    @Override
    protected Attribute getLineLengthAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("E1N_LINE_CARD.Line Length", n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.model == null || this.numLines == 0) {
            return false;
        }
        try {
            if (!AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) || this.model[0].getModuleModel().isProtectModule()) {
                return false;
            }
            return n2 != 0 && n2 != 8 && n2 != 9;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("isCellEditable");
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return false;
        }
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(n);
    }

    @Override
    public int getColumnCount() {
        return e1ColumnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return e1ColumnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 14: {
                    return this.getProvidesSyncFromCard(n);
                }
                case 15: {
                    return this.getSyncMessageIn(n);
                }
                case 16: {
                    return this.getSendDoNotUse(n);
                }
                case 17: {
                    return this.getE1SaBit(n);
                }
                case 18: {
                    return this.getAdminSsm(n);
                }
                case 13: {
                    return this.getRetimingEnabled(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            db.println("Caught exception: " + n2);
            db.println("Caught exception in getValueAt: " + exception);
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 13: {
                if ((Boolean)object == this.retimingEnabled[n]) {
                    return;
                }
                this.retimingEnabled[n] = (Boolean)object;
                break;
            }
            case 15: {
                boolean bl = (Boolean)object;
                if (bl == this.syncConfig[n].syncMessageIn) {
                    return;
                }
                this.syncConfig[n].syncMessageIn = bl;
                break;
            }
            case 16: {
                boolean bl = (Boolean)object;
                if (bl == this.syncConfig[n].sendDoNotUse) {
                    return;
                }
                this.syncConfig[n].sendDoNotUse = bl;
                break;
            }
            case 17: {
                if (this.saBit[n] == object) {
                    return;
                }
                this.saBit[n] = (Attribute)object;
                break;
            }
            case 18: {
                int n3 = 0;
                try {
                    n3 = ((Attribute)object).getIntValue();
                }
                catch (NullPointerException nullPointerException) {
                    db.println("Null value in Ds1LineTableModel");
                    return;
                }
                if (n3 == this.syncConfig[n].adminSSM.value()) {
                    return;
                }
                this.syncConfig[n].adminSSM = eQualityLevel.from_int(n3);
                break;
            }
        }
        super.setValueAt(object, n, n2);
    }

    protected sLineSyncConfig getSyncConfig(int n) throws NoSuchInterface, UnsupportedOperation {
        if (this.syncConfig[n] == null) {
            this.syncConfig[n] = ((Ds1LineModel)this.model[n]).getSyncConfig();
        }
        return this.syncConfig[n];
    }

    private Boolean getProvidesSyncFromCard(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).providesSyncFromCard);
    }

    private Boolean getSyncMessageIn(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).syncMessageIn);
    }

    private Boolean getSendDoNotUse(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).sendDoNotUse);
    }

    private Attribute getAdminSsm(int n) throws NoSuchInterface, UnsupportedOperation, AbstractCmsNoSuchEntityException {
        int n2 = this.getSyncConfig((int)n).adminSSM.value();
        return this.getAttributeMap().getAttributeForVal("timingSdhSsmQuality", this.getSyncConfig((int)n).adminSSM.value());
    }

    protected Attribute getSaBitAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("fullSetTimingBitsSabit", n);
    }

    protected Attribute getE1SaBit(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.saBit[n] == null) {
            eSaBit eSaBit2 = ((Ds1LineModel)this.model[n]).getE1SaBit();
            this.saBit[n] = this.getSaBitAttributeFor(eSaBit2.value());
        }
        return this.saBit[n];
    }

    protected Boolean getRetimingEnabled(int n) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType {
        if (this.retimingEnabled[n] == null) {
            this.retimingEnabled[n] = new Boolean(((Ds1LineModel)this.model[n]).getDs1RetimingEnabled());
        }
        return this.retimingEnabled[n];
    }

    @Override
    public void refreshFromModel() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            this.syncConfig[i] = null;
            this.retimingEnabled[i] = null;
            this.saBit[i] = null;
        }
        super.refreshFromModel();
    }

    @Override
    public void refreshLineFromModel(int n) {
        this.syncConfig[n] = null;
        this.retimingEnabled[n] = null;
        this.saBit[n] = null;
        super.refreshLineFromModel(n);
    }

    static {
        System.arraycopy(E13LineTableModel.columnNames, 0, e1ColumnNames, 0, E13LineTableModel.columnNames.length);
        E1LineTableModel.e1ColumnNames[14] = "ProvidesSync";
        E1LineTableModel.e1ColumnNames[15] = "SyncMsgIn";
        E1LineTableModel.e1ColumnNames[16] = "Send DoNotUse";
        E1LineTableModel.e1ColumnNames[17] = "SA Bit";
        E1LineTableModel.e1ColumnNames[18] = "Admin SSM";
        E1LineTableModel.e1ColumnNames[13] = "Enable Retiming";
    }
}

