/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.e13;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.InterfaceModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.GeneralPmThresholdsPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PmThresholdButtonPanel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.HoPathPmThresholdsPane;
import cerent.cms.ui.sonet.LoPathPmThresholdsPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public abstract class E13SdhPmThresholdsPane
extends AbstractPane {
    protected InterfaceModel[] models;
    protected SdhThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected GeneralPmThresholdsPane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String FE_VT_1DAY_PANEL = "FE_VT_1DAY";
    protected static final String FE_VT_15MIN_PANEL = "FE_VT_15MIN";
    protected static final String FE_STS_1DAY_PANEL = "FE_STS_1DAY";
    protected static final String FE_STS_15MIN_PANEL = "FE_STS_15MIN";
    protected static final String NE_VT_1DAY_PANEL = "NE_VT_1DAY";
    protected static final String NE_VT_15MIN_PANEL = "NE_VT_15MIN";
    protected static final String NE_STS_1DAY_PANEL = "NE_STS_1DAY";
    protected static final String NE_STS_15MIN_PANEL = "NE_STS_15MIN";
    protected static final int FE_VT_1DAY = 7;
    protected static final int FE_VT_15MIN = 6;
    protected static final int FE_STS_1DAY = 5;
    protected static final int FE_STS_15MIN = 4;
    protected static final int NE_VT_1DAY = 3;
    protected static final int NE_VT_15MIN = 2;
    protected static final int NE_STS_1DAY = 1;
    protected static final int NE_STS_15MIN = 0;
    private static final SDebug db = new SDebug("Pane.E13SdhPmThresholdsPane");

    public E13SdhPmThresholdsPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray) {
        super(string, tabbedView);
        this.models = interfaceModelArray;
        this.panes = new GeneralPmThresholdsPane[8];
        this.initializeLayout();
        this.showPanel(2);
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "North");
        this.add(this.getTablePanel(), "Center");
    }

    protected SdhThresholdButtonPanel getButtonPanel() {
        this.buttonPanel = new SdhThresholdButtonPanel();
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        return this.tablePanel;
    }

    protected HoPathPmThresholdsPane getHoPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new HoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, this.getStsLevel(), true);
    }

    protected LoPathPmThresholdsPane getLoPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new LoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, this.getVtLevel());
    }

    protected abstract int getVtLevel();

    protected abstract int getStsLevel();

    protected boolean showVts() {
        return true;
    }

    protected boolean showFarEnd() {
        return true;
    }

    protected GeneralPmThresholdsPane createAndAddPanel(int n) {
        GeneralPmThresholdsPane generalPmThresholdsPane = this.panes[n];
        if (generalPmThresholdsPane == null) {
            switch (n) {
                case 7: {
                    generalPmThresholdsPane = this.getLoPathPmThresholdsPane(FE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
                    break;
                }
                case 6: {
                    generalPmThresholdsPane = this.getLoPathPmThresholdsPane(FE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
                    break;
                }
                case 5: {
                    generalPmThresholdsPane = this.getHoPathPmThresholdsPane(FE_STS_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
                    break;
                }
                case 4: {
                    generalPmThresholdsPane = this.getHoPathPmThresholdsPane(FE_STS_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
                    break;
                }
                case 3: {
                    generalPmThresholdsPane = this.getLoPathPmThresholdsPane(NE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
                    break;
                }
                case 2: {
                    generalPmThresholdsPane = this.getLoPathPmThresholdsPane(NE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
                    break;
                }
                case 1: {
                    generalPmThresholdsPane = this.getHoPathPmThresholdsPane(NE_STS_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
                    break;
                }
                default: {
                    generalPmThresholdsPane = this.getHoPathPmThresholdsPane(NE_STS_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
                }
            }
            this.panes[n] = generalPmThresholdsPane;
            this.tablePanel.add((Component)((Object)generalPmThresholdsPane), generalPmThresholdsPane.getName());
        }
        return generalPmThresholdsPane;
    }

    protected void showPanel(int n) {
        block5: {
            try {
                if (this.currentPane != null) {
                    this.currentPane.leavingPage();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Error in leavingPage");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        GeneralPmThresholdsPane generalPmThresholdsPane = this.createAndAddPanel(n);
        try {
            generalPmThresholdsPane.enteringPage();
        }
        catch (Exception exception) {
            db.finest("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, generalPmThresholdsPane.getName());
        this.currentPane = generalPmThresholdsPane;
    }

    @Override
    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    @Override
    public void leavingPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
    }

    @Override
    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (this.panes[i] == null) continue;
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected class SdhThresholdButtonPanel
    extends PmThresholdButtonPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JRadioButton buttonVt;
        public JRadioButton buttonSts;
        public ButtonGroup periodButtonGroup;
        public ButtonGroup endButtonGroup;
        public ButtonGroup secStsButtonGroup;
        protected int FE_MASK = 4;
        protected int VT_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public SdhThresholdButtonPanel() {
            this.initialize();
            if (!E13SdhPmThresholdsPane.this.showVts()) {
                this.buttonVt.setEnabled(false);
            }
            if (!E13SdhPmThresholdsPane.this.showFarEnd()) {
                this.buttonFE.setEnabled(false);
            }
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.buttonVt = new JRadioButton("VC LO", true);
            this.buttonSts = new JRadioButton("VC4");
            this.secStsButtonGroup = new ButtonGroup();
            this.secStsButtonGroup.add(this.buttonVt);
            this.secStsButtonGroup.add(this.buttonSts);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.endButtonGroup = new ButtonGroup();
            this.endButtonGroup.add(this.buttonNE);
            this.endButtonGroup.add(this.buttonFE);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buttonNE, "North");
            jPanel.add((Component)this.buttonFE, "South");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)this.buttonVt, "North");
            jPanel3.add((Component)this.buttonSts, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.addShowButton();
            this.addResetToDefaultButton();
            this.setPreferredSize(new Dimension(800, 50));
        }

        @Override
        protected int getUserRadioButtonChoiceMask() {
            int n = 0;
            if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                n |= this.FE_MASK;
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                n |= this.ONE_DAY_MASK;
            }
            if (this.secStsButtonGroup.getSelection() == this.buttonVt.getModel()) {
                n |= this.VT_MASK;
            }
            return n;
        }

        @Override
        protected GeneralPmThresholdsPane getPanel(int n) {
            return E13SdhPmThresholdsPane.this.createAndAddPanel(n);
        }

        @Override
        protected void displayPanel(int n) {
            E13SdhPmThresholdsPane.this.showPanel(n);
        }
    }
}

