/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.ConditionsPane;
import cerent.cms.ui.event.FilterDialog;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Date;

public abstract class ElementConditionsPane
extends ConditionsPane {
    protected NodeModelDelegate model;
    private static final SDebug db = new SDebug("ElementConditionsPane");

    public ElementConditionsPane(String string, NodeModelDelegate nodeModelDelegate, TabbedView tabbedView, IEventPanelController iEventPanelController, SDebug sDebug) {
        super(string, nodeModelDelegate, tabbedView, iEventPanelController, sDebug);
        this.model = nodeModelDelegate;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected void showFilterDialog() {
        try {
            INodeModel[] iNodeModelArray = new INodeModel[]{(INodeModel)this.uiModel};
            this.eventFilter.setNodeModel(iNodeModelArray);
            new FilterDialog(this, this.eventFilter, "Condition Filter").show();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        ArrayList arrayList = this.model.getCachedConditionList();
        if (arrayList != null) {
            boolean bl = false;
            Date date = (Date)arrayList.get(0);
            if (date != null) {
                if (this.lastUpdate == null) {
                    bl = true;
                } else if (date.compareTo(this.lastUpdate) > 0) {
                    bl = true;
                }
            }
            if (db.on()) {
                db.println("cachedDate: " + date + " vs lastUpdate: " + this.lastUpdate);
            }
            if (bl) {
                this.updateWatchLabel(date);
                boolean bl2 = (Boolean)arrayList.get(1);
                if (this.excludeSuppressed != bl2) {
                    this.suppressedCB.doClick();
                }
                this.arrayList.clear();
                this.filteredArrayList.clear();
                ArrayList arrayList2 = (ArrayList)arrayList.get(2);
                this.registerNewConditions(this.filterConditions(arrayList2));
                this.rowSource.dataSourceChanged();
                if (db.on()) {
                    db.println("Cache update, exclude=" + bl2);
                }
            }
        }
    }

    @Override
    protected String getErrorMsg() {
        return ErrorMsg.getString((EID)EMC.EID_ELE_RTRV_COND_ERROR);
    }
}

