/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.ui.event.EventColumnRenderer;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class EventPanel
extends JPanel
implements MouseListener {
    public static final int EXC_NEW = 1;
    public static final int EXC_ST = 2;
    public static final int EXC_EQT = 4;
    public static final int EXC_SLOT = 8;
    public static final int EXC_NODE = 16;
    public static final int EXC_DATE = 32;
    public static final int EXC_SEQ = 64;
    public static final int EXC_REF = 128;
    public static final int EXC_SEV = 256;
    public static final int EXC_SA = 512;
    public static final int EXC_SHELF = 1024;
    public static final int EXC_PATH_WIDTH = 2048;
    public static final int EXC_COND_DESC = 4096;
    public static final int EXC_ALM_DIRECTION = 8192;
    public static final int EXC_ALM_LOCATION = 16384;
    private static final int[] COL_SETTINGS = new int[]{13, 64, 14, 128, 15, 1, 9, 32, 10, 16, 8, 0, 16, 4, 1, 1024, 2, 8, 3, 0, 18, 0, 17, 2048, 0, 256, 11, 2, 12, 512, 6, 0, 7, 4096, 5, 8192, 4, 16384};
    protected JTable table;
    protected SortableRowTableModel model;
    protected IEventPanelController myController;

    public static ColumnRenderer[] getColumnRenderers(int n) {
        LinkedList<ColumnRenderer> linkedList = new LinkedList<ColumnRenderer>();
        for (int i = 0; i < COL_SETTINGS.length; i += 2) {
            if ((COL_SETTINGS[i + 1] & n) != 0) continue;
            linkedList.add(EventColumnRenderer.createEventColumnRenderer(COL_SETTINGS[i]));
        }
        ColumnRenderer[] columnRendererArray = linkedList.toArray(new ColumnRenderer[0]);
        return columnRendererArray;
    }

    public EventPanel(RowDataSource rowDataSource, IEventPanelController iEventPanelController, int n) {
        super(new BorderLayout());
        this.myController = iEventPanelController;
        ColumnRenderer[] columnRendererArray = EventPanel.getColumnRenderers(n);
        this.createTableAndModel(rowDataSource, columnRendererArray);
    }

    protected void createTableAndModel(RowDataSource rowDataSource, ColumnRenderer[] columnRendererArray) {
        this.model = new SortableRowTableModel(rowDataSource, columnRendererArray);
        this.table = new UTable((TableModel)((Object)this.model));
        this.initTable();
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.table.addMouseListener(this);
    }

    public JTable getTable() {
        return this.table;
    }

    public AbstractTableModel getModel() {
        return this.model;
    }

    protected void initTable() {
        this.model.initTable(this.table);
    }

    public void release() {
        this.table.removeMouseListener(this);
        this.model.release();
        this.removeAll();
    }

    public void dispose() {
        this.release();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.myController.mouseClicked(mouseEvent, this.getTable(), this.getModel());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

