/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.FCMedia.eFCMediaType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.CircuitExists;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.IModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.fcmr.FcmrPortTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.SoakTimeCellEditor;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FcmrPortProvPane
extends NodeProvPane
implements TableModelListener {
    private FcmrPortTableModel dataModel = null;
    private FcmrLineModel[] lineModels = null;
    private int numLines = 0;
    private static final SDebug db = new SDebug("FcmrPortProvPane");

    public FcmrPortProvPane(String string, TabbedView tabbedView, FcmrLineModel[] fcmrLineModelArray) {
        super(string, tabbedView);
        this.lineModels = fcmrLineModelArray;
        this.numLines = fcmrLineModelArray == null ? 0 : fcmrLineModelArray.length;
        this.setDataModel();
        this.table = new MutableEditorTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.registerWithModel();
        this.add((Component)uScrollPane);
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("FcmrPortProvPane::enteringPage!");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("FcmrPortLineProvPane::leavingPage!");
        }
        super.leavingPage();
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        Object var2_2 = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[2]);
        boolean bl = AdminState.isANSI(this.getUiModel().getNodeModel().getTdmProtocolType());
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(bl);
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[4]);
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[6]);
        tableColumn.setPreferredWidth(125);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[7]);
        tableColumn.sizeWidthToFit();
        SoakTimeCellEditor soakTimeCellEditor = new SoakTimeCellEditor();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[8]);
        tableColumn.setCellEditor(soakTimeCellEditor);
        tableColumn.setMinWidth(soakTimeCellEditor.getPreferredWidth() + 10);
        this.table.setRowHeight(soakTimeCellEditor.getPreferredHeight());
        this.prepareColumns();
        this.table.sizeColumnsToFit(-1);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected void prepareColumns() {
    }

    protected void setDataModel() {
        this.dataModel = new FcmrPortTableModel((JPanel)((Object)this), (FcmrModuleModel)this.getUiModel(), this.lineModels);
        this.dataModel.addTableModelListener(this);
    }

    private UComboBox getComboBoxFor(Attribute[] attributeArray) {
        UComboBox uComboBox = new UComboBox((Object[])attributeArray);
        uComboBox.setEditable(false);
        return uComboBox;
    }

    protected AttributeMaps getAttributeMap() {
        IModel iModel = this.uiModel;
        return ElementDefaults.getAttributeMap(iModel);
    }

    protected Attribute[] getAttributeArray(String string) {
        return this.getAttributeMap().getAttributeArray(string);
    }

    @Override
    protected void registerWithModel() {
        super.registerWithModel();
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unRegisterWithModel() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                FcmrPortProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = this.lineModels.length;
        int n2 = Arrays.asList(this.lineModels).indexOf(observable);
        if (n2 != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n2);
            }
            this.dataModel.refreshLineFromModel(n2);
        } else if (db.on()) {
            db.println("In FcmrPortProvPane change Message cannot find Model " + observable);
        }
    }

    @Override
    public void destroy() {
        this.unRegisterWithModel();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws Exception {
        block13: {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
                stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
                bl = true;
            }
            if (AdminState.needRemoveLoopback(this.dataModel, this.lineModels)) {
                stringBuffer.append("Some lines will be removed from loopback since their new state does not allow loopback.").append('\n');
            }
            if (stringBuffer.length() != 0) {
                if (bl) {
                    String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, false);
                    stringBuffer.append(string).append('\n');
                }
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                    return;
                }
            }
            try {
                this.dataModel.applyToModel();
                this.resetDirty();
            }
            catch (CircuitExists circuitExists) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PORT_RATE_PROV_ERROR);
                if (FcmrPortProvPane.db.on) {
                    SDebug.printStackTrace((Throwable)circuitExists);
                }
            }
            catch (InvalidState invalidState) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CURR_PORT_STATE_DISALLOWS_CHANGE_PARAM_1, (Object)("not " + AdminState.getAdminTermDSBLD(this.getUiModel().getNodeModel().getTDMTerminology())));
                if (FcmrPortProvPane.db.on) {
                    SDebug.printStackTrace((Throwable)invalidState);
                }
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNDEFINED_MEDIA_DISALLOWS_CHANGE);
                if (FcmrPortProvPane.db.on) {
                    SDebug.printStackTrace((Throwable)provisionError);
                }
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.getMessage());
                if (!FcmrPortProvPane.db.on) break block13;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void setAttrCellEditor(int n, String string) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
        Attribute[] attributeArray = this.getAttributeArray(string);
        tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
    }

    private boolean isDistExtensionMode() {
        if (this.lineModels != null && this.lineModels.length != 0) {
            ModuleModel moduleModel = null;
            try {
                moduleModel = this.lineModels[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("No Such Entity");
                }
                return false;
            }
            if (moduleModel.getCardOperMode() == eCardOperMode.OPER_MODE_FCMR_DIST_EXTN) {
                return true;
            }
        }
        return false;
    }

    private boolean isFcmrCard() {
        if (this.lineModels != null && this.lineModels.length != 0) {
            ModuleModel moduleModel = null;
            try {
                moduleModel = this.lineModels[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on()) {
                    db.println("No Such Entity");
                }
                return false;
            }
            if (moduleModel instanceof FcmrModuleModel) {
                return true;
            }
        }
        return false;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.FcmrPortProvPane;
    }

    private class MutableEditorTable
    extends UTable {
        private DefaultCellEditor lineRateMediaTypeEditor;
        private DefaultCellEditor distExMediaTypeEditor;

        public MutableEditorTable(FcmrPortTableModel fcmrPortTableModel) {
            super((TableModel)fcmrPortTableModel);
            Attribute[] attributeArray = FcmrPortProvPane.this.getAttributeArray(eFCMediaType.class.getName());
            Attribute[] attributeArray2 = FcmrPortProvPane.this.getAttributeArray("FCMR_NO_DIST_EXTN" + eFCMediaType.class.getName());
            this.lineRateMediaTypeEditor = new DefaultCellEditor((JComboBox<?>)FcmrPortProvPane.this.getComboBoxFor(attributeArray2));
            this.distExMediaTypeEditor = new DefaultCellEditor((JComboBox<?>)FcmrPortProvPane.this.getComboBoxFor(attributeArray));
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            boolean bl;
            boolean bl2;
            block6: {
                bl2 = true;
                bl = true;
                try {
                    bl2 = FcmrPortProvPane.this.isDistExtensionMode();
                    bl = FcmrPortProvPane.this.lineModels[n] != null && FcmrPortProvPane.this.lineModels[n].isDistExtensionEnabled();
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("No Such Interface");
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) break block6;
                    db.println("Wrong Interface type");
                }
            }
            int n3 = this.convertColumnIndexToModel(n2);
            if (n3 == 4) {
                if (bl2 && bl) {
                    return this.distExMediaTypeEditor;
                }
                return this.lineRateMediaTypeEditor;
            }
            return super.getCellEditor(n, n2);
        }
    }
}

