/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional.card;

import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IFvOTU2ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.functional.FunctDomainGrapher;
import cerent.cms.ui.functional.card.FunctTxpPpmCardGrapher;
import cerent.cms.ui.functional.port.FunctPortGraphic;
import cerent.cms.ui.functional.svg.SvgFactoryDirector;
import cerent.cms.ui.functional.svg.SvgGeneralFactory;
import cerent.util.view.fv.AbstractSvgFactory;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewDwdmSide;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.ViewZoomLabel;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.SvgParams;
import cerent.util.view.fv.helper.SvgParamsHelper;
import ilog.views.graphic.IlvZoomableLabel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FunctOTU2XpCardGrapher
extends FunctTxpPpmCardGrapher {
    public static final String[] cardModeLabel = new String[]{"Transponder", "Standard Regen", "Enhanced FEC", "Mixed", "10GE LAN to WAN", "Splitter", ""};
    public static final String[] subMixedModeLabel = new String[]{"Transponder", "Standard Regen"};
    private int subMixedMode;
    private IFvInterfaceModel[] bundle;

    public FunctOTU2XpCardGrapher(SvgParams svgParams, ViewGraphicSet viewGraphicSet) {
        super(svgParams, viewGraphicSet);
        IFvOTU2ModuleModel iFvOTU2ModuleModel = (IFvOTU2ModuleModel)svgParams.getSvgValue();
        if (this.getObject(ViewSvgDecoderHelper.SvgTypeEnum.CARD_NAME_LABEL.toString()) != null) {
            String string;
            IlvZoomableLabel ilvZoomableLabel = (IlvZoomableLabel)this.getObject(ViewSvgDecoderHelper.SvgTypeEnum.CARD_NAME_LABEL.toString());
            try {
                string = ilvZoomableLabel.getLabel() + " (" + cardModeLabel[iFvOTU2ModuleModel.getCardMode()] + ")";
            }
            catch (NoSuchInterface noSuchInterface) {
                string = "ERROR Card Mode";
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                string = "ERROR Card Mode";
                FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            this.setLabel(ViewSvgDecoderHelper.SvgTypeEnum.CARD_NAME_LABEL.toString(), string);
        }
    }

    @Override
    public IViewGraph createGenericPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        HashMap hashMap = (HashMap)viewAttribute.getBag();
        HashMap<Integer, IFvPortModel> hashMap2 = new HashMap<Integer, IFvPortModel>();
        int n = 1;
        Iterator iterator = hashMap.values().iterator();
        this.subMixedMode = -1;
        while (iterator.hasNext()) {
            IFvPortModel iFvPortModel = (IFvPortModel)iterator.next();
            if (iFvPortModel.isClientPort() || !this.addTrunkAfterFilter(iFvPortModel)) continue;
            hashMap2.put(n, iFvPortModel);
            ++n;
        }
        IFvPortModel iFvPortModel = SvgParamsHelper.getTrnkPortId(hashMap2, (ViewSvgDecoderHelper.SvgTypePortEnum)((IViewSvgParamInfo)viewAttribute.getKey()).getSvgPortTyp(), (int)((IViewSvgParamInfo)viewAttribute.getKey()).getSvgNumId());
        if (iFvPortModel != null) {
            return SvgFactoryDirector.getViewElem(SvgParamsHelper.getSvgGenericPortParams((IViewGraph)this, (ViewManager)this.getViewManager(), viewAttribute, (IFvPortModel)iFvPortModel));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addTrunkAfterFilter(IFvPortModel iFvPortModel) {
        IViewGraph iViewGraph = this.getGraphParent();
        IFvSideModel iFvSideModel = iViewGraph instanceof FunctDomainGrapher ? ((FunctDomainGrapher)this.getGraphParent()).getSideModel() : ((FunctDomainGrapher)this.getGraphParent().getGraphParent()).getSideModel();
        this.getViewManager();
        ArrayList arrayList = ViewManager.getTxpLinks((ArrayList)this.getViewManager().getNodeLinks());
        IFvOTU2ModuleModel iFvOTU2ModuleModel = (IFvOTU2ModuleModel)this.params.getSvgValue();
        block10: for (ViewInternalLink viewInternalLink : arrayList) {
            int n = viewInternalLink.getLinkSide();
            if (n == -10000) {
                n = 0;
            }
            if (viewInternalLink.getDwdmPort().getIndex() != iFvPortModel.getIndex()) continue;
            try {
                int n2 = iFvOTU2ModuleModel.getCardMode();
                switch (n2) {
                    case 0: 
                    case 1: {
                        if ((n & 0xFF) != (iFvSideModel.getId() & 0xFF)) continue block10;
                        return this.OtherTrunkSameSide(iFvPortModel, iFvOTU2ModuleModel, n2);
                    }
                    case 2: {
                        return (n & 0xFF) == (iFvSideModel.getId() & 0xFF);
                    }
                    case 3: {
                        this.bundle = iFvOTU2ModuleModel.getBundlePort(iFvPortModel.getIndex());
                        if (this.bundle.length <= 0) return false;
                        try {
                            if ((n & 0xFF) != (iFvSideModel.getId() & 0xFF)) return false;
                            if (this.bundle[0].getThePortModel().isClientPort()) {
                                if (((SvgParams)this.params).getDiscoveredPort().getIndex() != iFvPortModel.getIndex() || this.subMixedMode != -1) return false;
                                this.subMixedMode = 0;
                                return true;
                            }
                            if (this.subMixedMode == 0) return false;
                            this.subMixedMode = 1;
                            return true;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            return false;
                        }
                    }
                    default: {
                        return true;
                    }
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
                return false;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
                return false;
            }
        }
        return false;
    }

    private boolean OtherTrunkSameSide(IFvPortModel iFvPortModel, IFvOTU2ModuleModel iFvOTU2ModuleModel, int n) {
        if (!((SvgParams)this.params).isHasOtherInstance()) {
            if (iFvPortModel.getIndex() == iFvOTU2ModuleModel.getLineModel(1).getIndex() || iFvPortModel.getIndex() == iFvOTU2ModuleModel.getLineModel(3).getIndex()) {
                return true;
            }
            if (n == 0) {
                return true;
            }
        } else {
            if (iFvOTU2ModuleModel.getLineModel(1) != null && iFvPortModel.getIndex() == iFvOTU2ModuleModel.getLineModel(1).getIndex()) {
                return true;
            }
            if (iFvOTU2ModuleModel.getLineModel(3) != null && iFvPortModel.getIndex() == iFvOTU2ModuleModel.getLineModel(3).getIndex()) {
                return true;
            }
            if (iFvOTU2ModuleModel.getLineModel(2) != null && iFvPortModel.getIndex() == iFvOTU2ModuleModel.getLineModel(2).getIndex()) {
                return true;
            }
            if (iFvOTU2ModuleModel.getLineModel(4) != null && iFvPortModel.getIndex() == iFvOTU2ModuleModel.getLineModel(4).getIndex()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void refineTxpInit() {
        IFvOTU2ModuleModel iFvOTU2ModuleModel = (IFvOTU2ModuleModel)this.params.getSvgValue();
        try {
            int n = iFvOTU2ModuleModel.getCardMode();
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    this.updateSideLabel(n);
                    this.removeNotUsedTrunk();
                    if (this.extraIcon != null) {
                        this.extraIcon.setVisible(n == 1);
                    }
                    break;
                }
                case 5: {
                    super.refineTxpInit();
                    break;
                }
                default: {
                    this.updateSideLabel(n);
                    if (this.extraIcon != null) {
                        this.extraIcon.setVisible(this.subMixedMode == 1);
                    }
                    break;
                }
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            FunctDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
    }

    private void updateSideLabel(int n) {
        switch (n) {
            case 1: 
            case 2: {
                ViewInternalLink viewInternalLink = this.findOtherSideLink();
                if (viewInternalLink != null) {
                    int n2 = viewInternalLink.getLinkSide();
                    this.updateSideLabel("Regen Side " + ViewDwdmSide.getSideFromOffset((int)n2));
                    break;
                }
                this.updateSideLabel("Regen Side not connected");
                break;
            }
            case 0: {
                if (this.getObject("SIDE_LABEL-1") == null || !(this.getObject("SIDE_LABEL-1") instanceof ViewZoomLabel)) break;
                ((ViewZoomLabel)this.getObject("SIDE_LABEL-1")).setVisible(false);
                break;
            }
            case 3: {
                this.updateSideLabel(subMixedModeLabel[this.subMixedMode]);
                break;
            }
            default: {
                this.updateSideLabel("");
            }
        }
    }

    private void removeNotUsedTrunk() {
        for (IViewGraph iViewGraph : this.getGraphChildren().values()) {
            FunctPortGraphic functPortGraphic;
            if (!(iViewGraph instanceof FunctPortGraphic) || (functPortGraphic = (FunctPortGraphic)iViewGraph).hasLinks() != 0) continue;
            this.getGraphChildren().remove((Object)functPortGraphic);
        }
    }

    public static ViewCompositeGraphic createXPIcon(SvgParams svgParams, ViewGraphicSet viewGraphicSet) throws FunctException {
        IFvOTU2ModuleModel iFvOTU2ModuleModel = (IFvOTU2ModuleModel)svgParams.getSvgValue();
        IViewSvg.SvgCardShape svgCardShape = null;
        try {
            switch (iFvOTU2ModuleModel.getCardMode()) {
                case 0: 
                case 1: 
                case 3: {
                    svgCardShape = IViewSvg.SvgCardShape.OTU2_XP_TXP;
                    break;
                }
                case 2: {
                    svgCardShape = IViewSvg.SvgCardShape.OTU2_XP_REGEN;
                    break;
                }
                case 5: {
                    svgCardShape = IViewSvg.SvgCardShape.OTU2_XP_SPLITTER;
                    break;
                }
                default: {
                    throw new FunctException("Error in OTU2 Switch Factory");
                }
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            throw new FunctException("Error in OTU2 Factory");
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            throw new FunctException("Error in OTU2 Factory");
        }
        if (svgCardShape != null) {
            ViewGraphicSet viewGraphicSet2 = null;
            try {
                viewGraphicSet2 = AbstractSvgFactory.getSvgShape((IViewSvg.IViewSvgEnum)svgCardShape, (InputStream)SvgGeneralFactory.getSvgInputStream((IViewSvg.IViewSvgEnum)svgCardShape));
            }
            catch (SAXException sAXException) {
                FunctDebug.printStackTrace((Throwable)sAXException);
            }
            catch (IOException iOException) {
                FunctDebug.printStackTrace((Throwable)iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                FunctDebug.printStackTrace((Throwable)parserConfigurationException);
            }
            if (viewGraphicSet2 != null) {
                return new FunctOTU2XpCardGrapher(svgParams, viewGraphicSet2);
            }
            return new FunctOTU2XpCardGrapher(svgParams, viewGraphicSet);
        }
        return null;
    }
}

