/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.functional.svg;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.ui.functional.FunctTNCCardGrapher;
import cerent.cms.ui.functional.card.FunctCardGrapher;
import cerent.cms.ui.functional.card.FunctOTU2XpCardGrapher;
import cerent.cms.ui.functional.card.FunctPSMCardGrapher;
import cerent.cms.ui.functional.card.FunctPassiveCardGrapher;
import cerent.cms.ui.functional.card.FunctPassiveDCUCardGrapher;
import cerent.cms.ui.functional.card.FunctTxpCardGrapher;
import cerent.cms.ui.functional.card.FunctTxpPpmCardGrapher;
import cerent.cms.ui.functional.card.MMUFunctCardGrapher;
import cerent.cms.ui.functional.card.WxcFunctCardGrapher;
import cerent.cms.ui.functional.svg.SvgGeneralFactory;
import cerent.util.view.fv.AbstractSvgFactory;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.SvgParams;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SvgCardFactory
extends AbstractSvgFactory {
    private static final String MY_DEBUG_KEY = "FunctCardFactory";

    public SvgCardFactory(IFvNodeModel iFvNodeModel) {
        super(iFvNodeModel);
    }

    protected void initSvgHash() {
        SVGFileMap.put(129, IViewSvg.SvgCardShape.PRE);
        SVGFileMap.put(130, IViewSvg.SvgCardShape.BST);
        SVGFileMap.put(196, IViewSvg.SvgCardShape.BST);
        SVGFileMap.put(239, IViewSvg.SvgCardShape.BST);
        SVGFileMap.put(191, IViewSvg.SvgCardShape.WSS32);
        SVGFileMap.put(263, IViewSvg.SvgCardShape.WSS40);
        SVGFileMap.put(267, IViewSvg.SvgCardShape.WSS40);
        SVGFileMap.put(128, IViewSvg.SvgCardShape.OSC_CSM);
        SVGFileMap.put(127, IViewSvg.SvgCardShape.OSCM);
        SVGFileMap.put(192, IViewSvg.SvgCardShape.DMX32);
        SVGFileMap.put(241, IViewSvg.SvgCardShape.DMX32);
        SVGFileMap.put(132, IViewSvg.SvgCardShape.DMX32);
        SVGFileMap.put(131, IViewSvg.SvgCardShape.MUX32);
        SVGFileMap.put(249, IViewSvg.SvgCardShape.MMU);
        SVGFileMap.put(297, IViewSvg.SvgCardShape.WXC80);
        SVGFileMap.put(264, IViewSvg.SvgCardShape.DMX40);
        SVGFileMap.put(265, IViewSvg.SvgCardShape.MUX40);
        SVGFileMap.put(268, IViewSvg.SvgCardShape.DMX40);
        SVGFileMap.put(269, IViewSvg.SvgCardShape.MUX40);
        SVGFileMap.put(277, IViewSvg.SvgCardShape.OPT_AMP);
        SVGFileMap.put(278, IViewSvg.SvgCardShape.OPT_AMP);
        SVGFileMap.put(281, IViewSvg.SvgCardShape.OPT_AMP_C);
        SVGFileMap.put(240, IViewSvg.SvgCardShape.OPT_AMP_C);
        SVGFileMap.put(287, IViewSvg.SvgCardShape.OPT_RAMP);
        SVGFileMap.put(321, IViewSvg.SvgCardShape.OPT_RAMP);
        SVGFileMap.put(286, IViewSvg.SvgCardShape.PSM);
        SVGFileMap.put(134, IViewSvg.SvgCardShape.AD_1C);
        SVGFileMap.put(135, IViewSvg.SvgCardShape.AD_2C);
        SVGFileMap.put(136, IViewSvg.SvgCardShape.AD_4C);
        SVGFileMap.put(298, IViewSvg.SvgCardShape.TDCU);
        SVGFileMap.put(299, IViewSvg.SvgCardShape.TDCU);
        SVGFileMap.put(266, IViewSvg.SvgCardShape.WXC);
        SVGFileMap.put(294, IViewSvg.SvgCardShape.SMR1_40_C);
        SVGFileMap.put(295, IViewSvg.SvgCardShape.SMR2_40_C);
        SVGFileMap.put(296, IViewSvg.SvgCardShape.SMR1_80_C);
        SVGFileMap.put(181, IViewSvg.SvgCardShape.TXP);
        SVGFileMap.put(274, IViewSvg.SvgCardShape.TXP);
        SVGFileMap.put(118, IViewSvg.SvgCardShape.TXP);
        SVGFileMap.put(120, IViewSvg.SvgCardShape.TXP);
        SVGFileMap.put(300, IViewSvg.SvgCardShape.TXP);
        SVGFileMap.put(358, IViewSvg.SvgCardShape.TXP);
        SVGFileMap.put(275, IViewSvg.SvgCardShape.TXPP);
        SVGFileMap.put(121, IViewSvg.SvgCardShape.TXPP);
        SVGFileMap.put(272, IViewSvg.SvgCardShape.GE_XP);
        SVGFileMap.put(271, IViewSvg.SvgCardShape.GE_XP);
        SVGFileMap.put(293, IViewSvg.SvgCardShape.OTU2_XP_TXP);
        SVGFileMap.put(273, IViewSvg.SvgCardShape.ADM_10G);
        SVGFileMap.put(182, IViewSvg.SvgCardShape.MXP);
        SVGFileMap.put(119, IViewSvg.SvgCardShape.MXP);
        SVGFileMap.put(276, IViewSvg.SvgCardShape.MXP);
        SVGFileMap.put(243, IViewSvg.SvgCardShape.MXP);
        SVGFileMap.put(282, IViewSvg.SvgCardShape.MXP);
        SVGFileMap.put(183, IViewSvg.SvgCardShape.MXP);
        SVGFileMap.put(184, IViewSvg.SvgCardShape.MXPP);
        SVGFileMap.put(301, IViewSvg.SvgCardShape.MXP);
        SVGFileMap.put(309, IViewSvg.SvgCardShape.MD_40_PASSIVE);
        SVGFileMap.put(308, IViewSvg.SvgCardShape.MD_40_PASSIVE);
        SVGFileMap.put(312, IViewSvg.SvgCardShape.TDCU);
        SVGFileMap.put(313, IViewSvg.SvgCardShape.DEGREE_4);
        SVGFileMap.put(314, IViewSvg.SvgCardShape.DEGREE_8);
        SVGFileMap.put(311, IViewSvg.SvgCardShape.DEGREE_4_NEW);
        SVGFileMap.put(310, IViewSvg.SvgCardShape.PASSIVE_MD_ID_50);
        SVGFileMap.put(330, IViewSvg.SvgCardShape.TNC);
        SVGFileMap.put(357, IViewSvg.SvgCardShape.PASSIVE_MD_ID_50);
        SVGFileMap.put(356, IViewSvg.SvgCardShape.MXP);
    }

    public IViewGraph getViewElem(SvgParams svgParams) throws SAXException, IOException, ParserConfigurationException, FunctException {
        Object object = null;
        if (svgParams.getSvgValue() instanceof IFvCardModel) {
            IFvCardModel iFvCardModel = (IFvCardModel)svgParams.getSvgValue();
            IViewSvg.IViewSvgEnum iViewSvgEnum = (IViewSvg.IViewSvgEnum)SVGFileMap.get(iFvCardModel.getEqType());
            if (svgParams.hasOtherShapeToDisplay()) {
                iViewSvgEnum = svgParams.getOtherShapeToDisplay();
            }
            if (iViewSvgEnum != null) {
                ViewGraphicSet viewGraphicSet = SvgCardFactory.getSvgShape((IViewSvg.IViewSvgEnum)iViewSvgEnum, (InputStream)SvgGeneralFactory.getSvgInputStream(iViewSvgEnum));
                if (viewGraphicSet != null) {
                    block0 : switch (this.isCardInMpo(iFvCardModel.getEqType())) {
                        case TXP: {
                            object = new FunctTxpCardGrapher(svgParams, viewGraphicSet);
                            break;
                        }
                        case TXP_PPM: {
                            object = new FunctTxpPpmCardGrapher(svgParams, viewGraphicSet);
                            break;
                        }
                        case PSM_CARD: {
                            object = FunctPSMCardGrapher.createPSMIcon(svgParams, viewGraphicSet);
                            break;
                        }
                        case XP: {
                            object = FunctOTU2XpCardGrapher.createXPIcon(svgParams, viewGraphicSet);
                            break;
                        }
                        default: {
                            IFvCardModel iFvCardModel2 = (IFvCardModel)svgParams.getSvgValue();
                            switch (iFvCardModel2.getEqType()) {
                                case 249: {
                                    object = new MMUFunctCardGrapher(svgParams, viewGraphicSet);
                                    break block0;
                                }
                                case 266: 
                                case 270: 
                                case 297: {
                                    object = new WxcFunctCardGrapher(svgParams, viewGraphicSet);
                                    break block0;
                                }
                                case 312: {
                                    object = new FunctPassiveDCUCardGrapher(svgParams, viewGraphicSet);
                                    break block0;
                                }
                                case 311: 
                                case 313: 
                                case 314: {
                                    break block0;
                                }
                                case 308: 
                                case 309: 
                                case 310: 
                                case 357: {
                                    object = new FunctPassiveCardGrapher(svgParams, viewGraphicSet);
                                    break block0;
                                }
                                case 330: {
                                    object = new FunctTNCCardGrapher(svgParams, viewGraphicSet);
                                    break block0;
                                }
                            }
                            object = new FunctCardGrapher(svgParams, viewGraphicSet);
                        }
                    }
                }
            } else {
                throw new FunctException("Unknow model [" + iFvCardModel.getEqLabel() + " sh" + iFvCardModel.getShelfId() + "/" + iFvCardModel.getSlot() + "]");
            }
        }
        return object;
    }

    private CardInMpoType isCardInMpo(int n) {
        switch (n) {
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 243: 
            case 274: 
            case 275: 
            case 276: 
            case 282: 
            case 300: 
            case 301: 
            case 356: 
            case 358: {
                return CardInMpoType.TXP;
            }
            case 271: 
            case 272: 
            case 273: {
                return CardInMpoType.TXP_PPM;
            }
            case 293: {
                return CardInMpoType.XP;
            }
            case 286: {
                return CardInMpoType.PSM_CARD;
            }
        }
        return CardInMpoType.NO_TXP;
    }

    public static enum CardInMpoType {
        NO_TXP,
        TXP,
        TXP_PPM,
        XP,
        PSM_CARD;

    }
}

