/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.hdge;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.EtherMedia.sGmacLineAdminInfo;
import cerent.cms.idl.EtherMedia.sGmacLineAdminInfo_4_01;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.HdGeModuleModel;
import cerent.cms.model.HdGePortModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.hdge.HdGeLineMaintTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HdGeLineMaintPane
extends NodeProvPane
implements TableModelListener {
    private HdGeLineMaintTableModel dataModel = null;
    private HdGePortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private int numLines = 0;
    private int numPorts = 0;
    private HdGeModuleModel eqpmtModel = null;
    private static final SDebug db = new SDebug("HdLineMaintPane");

    public HdGeLineMaintPane(String string, TabbedView tabbedView, HdGePortModel[] hdGePortModelArray, EtherLineModel[] etherLineModelArray) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        Attribute[] attributeArray = null;
        this.portModels = hdGePortModelArray;
        this.lineModels = etherLineModelArray;
        this.numPorts = hdGePortModelArray == null ? 0 : hdGePortModelArray.length;
        int n = this.numLines = etherLineModelArray == null ? 0 : etherLineModelArray.length;
        if (this.getParentView().getUiModel() instanceof HdGeModuleModel) {
            this.eqpmtModel = (HdGeModuleModel)this.getParentView().getUiModel();
        } else if (db.on()) {
            db.println("Equipment Model is not HdGeModuleModel");
        }
        this.dataModel = new HdGeLineMaintTableModel(this.eqpmtModel, hdGePortModelArray, etherLineModelArray);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(90);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(AdminState.isANSI(this.eqpmtModel.getNodeModel().getTdmProtocolType()));
        JComboBox<AdminState> jComboBox = new JComboBox<AdminState>(adminStateArray);
        jComboBox.setEditable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.sizeWidthToFit();
        tableColumn = this.table.getColumn(this.dataModel.columnNames[3]);
        attributeArray = this.getAttributeArray("G1000 Loopback Type");
        tableColumn.setCellEditor(new DefaultCellEditor((JComboBox<?>)this.getComboBoxFor(attributeArray)));
        tableColumn.sizeWidthToFit();
        this.table.sizeColumnsToFit(-1);
        this.registerForUpdates();
        this.add(jScrollPane);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private UComboBox getComboBoxFor(Attribute[] attributeArray) {
        UComboBox uComboBox = new UComboBox((Object[])attributeArray);
        uComboBox.setEditable(false);
        return uComboBox;
    }

    protected Attribute[] getAttributeArray(String string) {
        INodeModel iNodeModel = this.getParentView().getUiModel().getNodeModel();
        return ElementDefaults.getAttributeMap((IModel)iNodeModel).getAttributeArray(string);
    }

    private void registerForUpdates() {
        if (this.lineModels == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            @Override
            public void run() {
                HdGeLineMaintPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In HdGeLineMaintPane change Message cannot find Model " + observable);
        }
    }

    @Override
    public void destroy() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.numLines; ++i) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
            }
            this.lineModels = null;
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.numPorts == 0) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.numPorts ? this.numPorts - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    @Override
    protected boolean queryRemainDirty() {
        return true;
    }

    @Override
    public void applyChangesToModel() throws AnnotatedException {
        int n = 0;
        try {
            if (!this.verifyApplyChangesToModel()) {
                return;
            }
            for (n = 0; n < this.numLines; ++n) {
                if (!this.dataModel.isRowDirty(n)) continue;
                this.applyInterdependentChangesToModel(n);
            }
            this.dataModel.resetRowDirty();
            this.setDirty(false);
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.dataModel.refresh();
        this.dataModel.resetRowDirty();
    }

    @Override
    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    protected void applyInterdependentChangesToModel(int n) throws Exception {
        if (db.on()) {
            db.println("Setting Loopback for " + (n + 1) + " to " + this.dataModel.getLoopbackFor(n));
        }
        eAdminState eAdminState2 = this.lineModels[n].getAdminStateEnum();
        eAdminState eAdminState3 = this.dataModel.getAdminStateFor(n);
        sGmacLineAdminInfo sGmacLineAdminInfo2 = this.dataModel.getLineAdminInfo(n);
        sGmacLineAdminInfo_4_01 sGmacLineAdminInfo_4_012 = this.dataModel.getLineAdminInfo_4_01(n);
        if (AdminState.admitsLoopback(eAdminState3) && this.loopbackChanged(n)) {
            if (this.adminStateChanged(n)) {
                this.lineModels[n].setAdminState(eAdminState3);
            }
            this.lineModels[n].setGmacLineAdminInfo(sGmacLineAdminInfo2);
            this.lineModels[n].setGmacLineAdminInfo_4_01(sGmacLineAdminInfo_4_012);
        } else if (AdminState.admitsLoopback(eAdminState2) && this.loopbackChanged(n)) {
            this.lineModels[n].setGmacLineAdminInfo(sGmacLineAdminInfo2);
            this.lineModels[n].setGmacLineAdminInfo_4_01(sGmacLineAdminInfo_4_012);
            if (this.adminStateChanged(n)) {
                this.lineModels[n].setAdminState(eAdminState3);
            }
        } else {
            this.lineModels[n].setAdminState(eAdminState3);
        }
    }

    private boolean adminStateChanged(int n) throws Exception {
        eAdminState eAdminState2 = this.lineModels[n].getAdminStateEnum();
        eAdminState eAdminState3 = this.dataModel.getAdminStateFor(n);
        return eAdminState2.value() != eAdminState3.value();
    }

    private boolean loopbackChanged(int n) throws Exception {
        sGmacLineAdminInfo_4_01 sGmacLineAdminInfo_4_012 = this.lineModels[n].getGmacLineAdminInfo_4_01();
        sGmacLineAdminInfo_4_01 sGmacLineAdminInfo_4_013 = this.dataModel.getLineAdminInfo_4_01(n);
        return sGmacLineAdminInfo_4_012.loopback != sGmacLineAdminInfo_4_013.loopback;
    }

    private boolean verifyApplyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            if (!bl && AdminState.isTransitionToOOS(this.dataModel.getAdminStateFor(i), this.lineModels[i].getAdminStateEnum())) {
                bl = true;
                if (bl2) break;
            }
            if (!bl2 && this.dataModel.getLineAdminInfo((int)i).loopback && !this.lineModels[i].getGmacLineAdminInfo().loopback) {
                bl2 = true;
                if (bl) break;
            }
            if (bl3 || !this.portModels[i].getHdGeLineModel().isTransponder() || this.dataModel.getLineAdminInfo_4_01((int)i).loopback != eLoopback.INWARD_LOOPBACK) continue;
            bl3 = true;
        }
        if (bl || bl2 || bl3) {
            if (bl) {
                stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            }
            if (bl2) {
                stringBuffer.append("Some lines are being placed in Loopback.").append('\n');
            }
            if (bl3) {
                stringBuffer.append("Terminal loopback has no effect if a line is\nin transponder mode.").append("\n");
            }
            if (bl || bl3) {
                stringBuffer.append(this.getSeverityWarningMsg(true));
            } else {
                stringBuffer.append(this.getApplyString());
            }
            bl4 = CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog");
        }
        return bl4;
    }

    private String getSeverityWarningMsg(boolean bl) {
        String string;
        try {
            String string2 = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, bl, true);
            string = string2 + "\n\n" + this.getApplyString(false);
        }
        catch (Exception exception) {
            string = "\n" + this.getApplyString();
        }
        return string;
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.HdGeLineMaintPane;
    }
}

