/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.hdge;

import cerent.cms.model.EtherLineModel;
import cerent.cms.model.HdGeModuleModel;
import cerent.cms.model.HdGePortModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.MaintBandwidthPane;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SoakMaintenancePane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.hdge.HdGeLineMaintPane;
import cerent.util.SDebug;
import java.awt.Component;
import javax.swing.JLabel;

public class HdGeMaintenancePane
extends NodeProvPane {
    private HdGeModuleModel hdgeModel;
    private HdGePortModel[] portModels = null;
    private EtherLineModel[] lineModels = null;
    private static final String LOOPBACK_TAB = "Loopback";
    private static final String BANDWIDTH_TAB = "Bandwidth";
    private static final SDebug db = new SDebug("HdGeMaintenancePane");

    public HdGeMaintenancePane(String string, CardTabbedView cardTabbedView, HdGeModuleModel hdGeModuleModel, HdGePortModel[] hdGePortModelArray, EtherLineModel[] etherLineModelArray) {
        super(string, cardTabbedView);
        if (hdGePortModelArray == null || etherLineModelArray == null) {
            db.println("ERROR: Line or Port Models are null!");
            this.add(new JLabel("This pane is unimplemented."));
            return;
        }
        this.hdgeModel = hdGeModuleModel;
        this.portModels = hdGePortModelArray;
        this.lineModels = etherLineModelArray;
        this.subTabs = new SubTabbedView(this.getUiModel(), cardTabbedView);
        if (hdGeModuleModel.supportsJ1PathTrace(etherLineModelArray)) {
            this.subTabs.addTab("Path Trace", (Component)CardTabbedView.getPathTracePane(etherLineModelArray, this.subTabs));
        }
        this.subTabs.addTab(LOOPBACK_TAB, (Component)this.getLoopbackTab());
        this.subTabs.addTab(BANDWIDTH_TAB, (Component)this.getBandwidthTab());
        this.subTabs.addTab("AINS Soak", (Component)this.getSoakTab());
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    private Pane getLoopbackTab() {
        return new HdGeLineMaintPane("HdGeLineMaintPane", this.getParentView(), this.portModels, this.lineModels);
    }

    private Pane getBandwidthTab() {
        return new MaintBandwidthPane("HdGeMaintBandwidthPane", this.getParentView(), this.hdgeModel);
    }

    protected Pane getSoakTab() {
        return new SoakMaintenancePane("AINS Soak", this.getParentView(), this.lineModels, true);
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }
}

