/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.PSMModuleModel;
import cerent.cms.ui.AbstractPortSelectorAttr;
import cerent.cms.ui.CombosCellRenderer;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.intpatch.IntPatchCreationInfo;
import cerent.cms.ui.intpatch.IntPatchHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import javax.swing.JLabel;

public class IntPatchPortSelectorAttr
extends AbstractPortSelectorAttr {
    private final IntPatchCreationInfo info;
    private boolean isSrc;
    private boolean isRev;
    private boolean loaded = false;
    private IntPatchCreationInfo.eIntPatchPortType pt;
    private final IntPatchHelper.PortFilter filter = IntPatchHelper.getFilter();
    private final JLabel label = new JLabel();
    private final WzDiagDebug db;

    IntPatchPortSelectorAttr(IntPatchCreationInfo intPatchCreationInfo, WzDiagDebug wzDiagDebug) {
        super(intPatchCreationInfo.getNodeModel(), null, true, new CombosCellRenderer());
        this.info = intPatchCreationInfo;
        this.db = wzDiagDebug;
    }

    public void init(boolean bl, boolean bl2, boolean bl3) throws AbstractCmsNoSuchEntityException, NoSuchEquipment {
        this.db.info("IntPatchPortSelectorAttr.init() isSrc=" + bl + ", isRev=" + bl2 + ", reload=" + bl3);
        if (!this.loaded || bl3) {
            this.isSrc = bl;
            this.isRev = bl2;
            this.pt = this.info.getPatchPortType(this.isSrc, this.isRev);
            this.initUI();
            IntPatchCreationInfo.TermInfo termInfo = this.info.getActiveTerm();
            if (bl && bl2 && termInfo.isAutoRevSrc()) {
                this.initRO(termInfo.getSecSrcPort());
            } else if (!bl && bl2 && termInfo.isAutoRevDst()) {
                this.initRO(termInfo.getSecDstPort());
            } else if (bl && bl2 && termInfo.getSecSrcPorts() != null && termInfo.getSecSrcPorts().length > 1) {
                this.loadNode(termInfo.getSecSrcPorts());
            } else if (!bl && bl2 && termInfo.getSecDstPorts() != null && termInfo.getSecDstPorts().length > 1) {
                this.loadNode(termInfo.getSecDstPorts());
            } else {
                this.setupFilter();
                this.loadNode();
            }
            this.loaded = true;
        }
    }

    @Override
    protected void initOtherUIComponent(GridBagConstraints gridBagConstraints) {
        this.db.info("IntPatchPortSelectorAttr.initOtherUIComponent()");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = this.slotCB.gridy();
        Dimension dimension = this.slotCB.getCB().getPreferredSize();
        dimension.width = 130;
        this.label.setPreferredSize(dimension);
        this.addUIComponent(this.label, gridBagConstraints);
    }

    private void setupFilter() {
        this.db.info("IntPatchPortSelectorAttr.setupFilter()");
        this.filter.txonly = this.isSrc;
        this.filter.rxonly = !this.isSrc;
        this.filter.wavelength = this.info.getWavelength();
        this.filter.colorless = this.info.isColorless();
        this.filter.grid = this.info.getGrid();
        this.filter.filterMPOOnly = this.info.isMPOConnection();
        this.filter.acceptRepetition = this.info.acceptRepetition();
        this.filter.optype.clear();
        this.filter.notOfOptype.clear();
        this.filter.parent = null;
        this.filter.notOfParent = null;
        this.filter.parentClass = null;
        this.filter.parentNotOfClass = null;
        if (this.pt == IntPatchCreationInfo.eIntPatchPortType.OSC) {
            this.filter.optype.add(this.isSrc ? OpticalPortType.OUT_OSC : OpticalPortType.IN_OSC);
            IntPatchHelper.PortFilter portFilter = IntPatchHelper.getFilter(this.filter);
            portFilter.eqtype.add(eEqType.OSC_CSM_CARD);
            portFilter.optype.add(this.isSrc ? OpticalPortType.OUT_LINE : OpticalPortType.IN_LINE);
            this.filter.or.add(portFilter);
        } else if (this.pt == IntPatchCreationInfo.eIntPatchPortType.DC) {
            this.filter.optype.add(this.isSrc ? OpticalPortType.OUT_DC : OpticalPortType.IN_DC);
            this.filter.notOfEqtype.add(eEqType.TNC_UTS_CARD);
        } else if (this.pt == IntPatchCreationInfo.eIntPatchPortType.OTS) {
            this.filter.notOfOptype.add(OpticalPortType.OUT_OSC);
            this.filter.notOfOptype.add(OpticalPortType.IN_OSC);
            this.filter.notOfOptype.add(OpticalPortType.OUT_DC);
            this.filter.notOfOptype.add(OpticalPortType.IN_DC);
            this.filter.notOfEqtype.add(eEqType.TNC_UTS_CARD);
            if (this.filter.acceptRepetition && !this.isSrc) {
                this.filter.originPort = this.isRev ? this.info.getActiveTerm().getSecSrcPort() : this.info.getActiveTerm().getSrcPort();
                this.filter.notOfParent = this.filter.originPort.getModuleModel();
            }
        } else if (this.info.isPsmProtection()) {
            if (this.pt == IntPatchCreationInfo.eIntPatchPortType.PSM_COM) {
                this.filter.optype.add(this.isSrc ? OpticalPortType.OUT_COM : OpticalPortType.IN_COM);
            } else if (this.pt == IntPatchCreationInfo.eIntPatchPortType.PSM_WRK) {
                this.filter.optype.add(this.isSrc ? OpticalPortType.OUT_WRK : OpticalPortType.IN_WRK);
            } else if (this.pt == IntPatchCreationInfo.eIntPatchPortType.PSM_PRT) {
                this.filter.optype.add(this.isSrc ? OpticalPortType.OUT_PROT : OpticalPortType.IN_PROT);
            }
            if (this.filter.optype.size() > 0) {
                this.filter.parent = this.info.getPSMModule();
                this.filter.parentClass = PSMModuleModel.class;
            } else {
                this.filter.parentNotOfClass = PSMModuleModel.class;
            }
        }
    }

    @Override
    public String getPortLabel() {
        if (this.isSrc) {
            return "Tx Port";
        }
        return "Rx Port";
    }

    @Override
    protected boolean isCardSelectorNeeded() {
        return this.pt == IntPatchCreationInfo.eIntPatchPortType.OCH || this.pt == IntPatchCreationInfo.eIntPatchPortType.OTS || this.pt == IntPatchCreationInfo.eIntPatchPortType.DC;
    }

    @Override
    public boolean isSideSelectorNeeded() {
        return this.pt == IntPatchCreationInfo.eIntPatchPortType.OCH;
    }

    @Override
    protected boolean isPortSelectorNeeded() {
        return !this.info.isMPOConnection();
    }

    @Override
    protected boolean isMPOSelectorNeeded() {
        return this.info.isMPOConnection();
    }

    @Override
    protected void loadSelectedCard(IModuleModel iModuleModel) {
        super.loadSelectedCard(iModuleModel);
        if (iModuleModel != null) {
            String string = iModuleModel.getModuleInfoString();
            this.label.setText(string);
        }
    }

    @Override
    protected void loadPassiveUnit(IModuleModel iModuleModel) {
        super.loadPassiveUnit(iModuleModel);
        this.label.setText("");
    }

    @Override
    public IEntityModel getPort() {
        if (this.isMPOSelectorNeeded()) {
            return this.mpoCB.getSelectedEntity();
        }
        return this.portCB.getSelectedEntity();
    }

    private void loadNode() {
        this.db.info("IntPatchPortSelectorAttr.loadNode()");
        IEntityModel[] iEntityModelArray = null;
        if (this.pt == IntPatchCreationInfo.eIntPatchPortType.TRK) {
            iEntityModelArray = IntPatchHelper.getOchTxpPorts(this.info.getNodeModel(), this.filter, this.warningMessage);
        } else if (this.pt == IntPatchCreationInfo.eIntPatchPortType.OCH || this.pt == IntPatchCreationInfo.eIntPatchPortType.PSM_COM || this.pt == IntPatchCreationInfo.eIntPatchPortType.PSM_WRK || this.pt == IntPatchCreationInfo.eIntPatchPortType.PSM_PRT) {
            iEntityModelArray = IntPatchHelper.getOchPorts(this.info.getNodeModel(), this.filter);
        } else if (this.pt == IntPatchCreationInfo.eIntPatchPortType.OTS || this.pt == IntPatchCreationInfo.eIntPatchPortType.OSC || this.pt == IntPatchCreationInfo.eIntPatchPortType.DC) {
            iEntityModelArray = IntPatchHelper.getOtsPorts(this.info.getNodeModel(), this.filter);
        } else if (this.pt == IntPatchCreationInfo.eIntPatchPortType.TRKL2) {
            iEntityModelArray = IntPatchHelper.getTrkL2Ports(this.info.getNodeModel(), this.isSrc ? null : this.info.getActiveTerm().getSrcPort());
        }
        this.loadNode(iEntityModelArray);
    }

    private void loadNode(IEntityModel[] iEntityModelArray) {
        this.warningMessage = new StringBuffer();
        this.loadAllPorts(iEntityModelArray);
        this.handleWarnings();
    }

    protected void handleWarnings() {
        if (this.warningMessage != null && this.warningMessage.length() > 0) {
            String string = ErrorMsg.getString((EID)EMC.WID_OPTICAL_LINK_NON_EQUIPPED_OCN_PARAM_1, (Object)this.warningMessage);
            CerentDialog.warningDialog((Component)this, (String)string);
        }
    }

    @Override
    protected boolean skipThisEntity(IEntityModel iEntityModel) {
        boolean bl = this.info.isEntityUsed(iEntityModel, this.isSrc, this.isRev);
        if (this.db.on()) {
            this.db.info("IntPatchPortSelectorAttr.skipThisEntity(" + iEntityModel + ")=" + bl);
        }
        return bl;
    }
}

