/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.intpatch;

import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IntPatchCreationDialog;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.intpatch.IntPatchCreationInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class IntPatchcdTypeSelPane
extends WzPane {
    private IntPatchTypeAttr typeAttr;
    private JCheckBox autorun;
    private HelpOnLine hol;

    public IntPatchcdTypeSelPane(WzDialog wzDialog, WzDiagDebug wzDiagDebug, String string) {
        super(wzDialog, wzDiagDebug, string);
    }

    @Override
    public void validatePage() throws Exception {
        IntPatchCreationInfo intPatchCreationInfo = ((IntPatchCreationDialog)this.parent).getInfo();
        intPatchCreationInfo.setPatchType(this.typeAttr.getPatchType());
        if (this.typeAttr.getPatchType() == IntPatchCreationInfo.eIntPatchCordType.TRK2OCH || this.typeAttr.getPatchType() == IntPatchCreationInfo.eIntPatchCordType.TRK2TRK) {
            intPatchCreationInfo.setBidi(true);
        }
        intPatchCreationInfo.setAutorun(this.autorun.isSelected());
        ((IntPatchCreationDialog)this.parent).createAutorun(this.autorun.isSelected());
    }

    @Override
    protected String getNextPaneName() {
        IntPatchCreationInfo intPatchCreationInfo = ((IntPatchCreationDialog)this.parent).getInfo();
        switch (intPatchCreationInfo.getPatchType()) {
            case OCH2OCH: 
            case TRK2OCH: {
                return "Internal Patchcord OCH Attributes";
            }
            case OTS2OTS: {
                return "Internal Patchcord OTS Attributes";
            }
            case CARD2CARD: {
                return "Internal Patchcord Card List";
            }
        }
        return "Internal Patchcord Origination";
    }

    @Override
    protected void initPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.typeAttr = new IntPatchTypeAttr();
        jPanel.add((Component)this.typeAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.autorun = new JCheckBox("Autorun Wizard");
        this.autorun.addActionListener(this);
        jPanel.add((Component)this.autorun, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.hol = new HelpOnLine();
        jPanel.add((Component)this.hol.getUI(), gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.hol.updateHelp();
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.IntPatchCdAttrsPane;
    }

    @Override
    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Type: ", this.typeAttr.toString()});
        if (this.autorun.isSelected()) {
            arrayList.add(new String[]{"Auto-run: ", "active"});
        }
        return IntPatchcdTypeSelPane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Type: ").append(this.typeAttr.toString());
        if (this.autorun.isSelected()) {
            stringBuffer.append("\nAuto-run is active.");
        }
        return stringBuffer.toString();
    }

    class HelpOnLine {
        private final JPanel p;
        private final JTextArea text;
        private final Font f = new Font("Arial", 1, 11);
        private static final String T2TL2 = "Trunk to Trunk L2:\n\nUse this option to create a bidirectional patch-cord\nbetween two 10GE-XP or GE-XP trunk ports in daisy chain.";
        private static final String T2F = "OCH Trunk to OCH Filter:\n\nUse this option to create a bidirectional patch-cord\nbetween a TXP / MXP / XP trunk\nand a DWDM Add & Drop channel port";
        private static final String F2F = "OCH Filter to OCH Filter:\n\nUse this option to create a mono-directional or bidirectional\npatch-cord between two DWDM add & Drop channel port";
        private static final String O2O = "OTS to OTS:\nUse this option to create a mono-directional or bidirectional\npatch-cord between two Optical Transport Section ports\nof DWDM units.\n(an OTS port carries more than one wavelength).\nThis option includes also the OSC ports.";
        private static final String OP = "Optical Path:\n\nUse this option to create the sequence of patch-cords\nthat build the optical path between two optical units\nfacing two sides";

        HelpOnLine() {
            this.p = new JPanel();
            this.text = new JTextArea();
            this.p.add(this.text);
            this.text.setEditable(false);
            this.text.setPreferredSize(new Dimension(350, 100));
            this.text.setBorder(BorderFactory.createEtchedBorder());
            this.text.setFont(this.f);
            this.updateHelp();
        }

        JPanel getUI() {
            return this.p;
        }

        void updateHelp() {
            switch (IntPatchcdTypeSelPane.this.typeAttr.getPatchType()) {
                case OCH2OCH: {
                    this.text.setText(F2F);
                    break;
                }
                case TRK2OCH: {
                    this.text.setText(T2F);
                    break;
                }
                case OTS2OTS: {
                    this.text.setText(O2O);
                    break;
                }
                case TRK2TRK: {
                    this.text.setText(T2TL2);
                    break;
                }
                case CARD2CARD: {
                    this.text.setText(OP);
                }
            }
        }
    }

    class IntPatchTypeAttr {
        private ButtonGroup typeBG;
        private JRadioButton ochT2ochFRB;
        private JRadioButton ochF2ochFRB;
        private JRadioButton trk2trkRB;
        private JRadioButton ots2otsRB;
        private JRadioButton card2cardRB;
        private JPanel p = new JPanel(new GridBagLayout());
        private IntPatchCreationInfo.eIntPatchCordType patchType;

        IntPatchTypeAttr() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 18;
            this.trk2trkRB = new JRadioButton("Trunk to Trunk (L2)");
            this.p.add((Component)this.trk2trkRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.ochT2ochFRB = new JRadioButton("OCH-Trunk to OCH-Filter");
            this.p.add((Component)this.ochT2ochFRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.ochF2ochFRB = new JRadioButton("OCH-Filter to OCH-Filter");
            this.p.add((Component)this.ochF2ochFRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.ots2otsRB = new JRadioButton("OTS to OTS");
            this.p.add((Component)this.ots2otsRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.card2cardRB = new JRadioButton("Optical Path");
            this.p.add((Component)this.card2cardRB, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.typeBG = new ButtonGroup();
            this.typeBG.add(this.ochT2ochFRB);
            this.typeBG.add(this.ochF2ochFRB);
            this.typeBG.add(this.trk2trkRB);
            this.typeBG.add(this.ots2otsRB);
            this.typeBG.add(this.card2cardRB);
            this.trk2trkRB.addActionListener(IntPatchcdTypeSelPane.this);
            this.ots2otsRB.addActionListener(IntPatchcdTypeSelPane.this);
            this.ochT2ochFRB.addActionListener(IntPatchcdTypeSelPane.this);
            this.ochF2ochFRB.addActionListener(IntPatchcdTypeSelPane.this);
            this.card2cardRB.addActionListener(IntPatchcdTypeSelPane.this);
            this.typeBG.setSelected(this.ochT2ochFRB.getModel(), true);
            ++gridBagConstraints.gridx;
            this.p.add((Component)new JPanel(), gridBagConstraints);
            this.p.setBorder(BorderFactory.createTitledBorder("Patchcord Type"));
        }

        JPanel getUI() {
            return this.p;
        }

        IntPatchCreationInfo.eIntPatchCordType getPatchType() {
            if (this.ots2otsRB.isSelected()) {
                this.patchType = IntPatchCreationInfo.eIntPatchCordType.OTS2OTS;
            } else if (this.ochT2ochFRB.isSelected()) {
                this.patchType = IntPatchCreationInfo.eIntPatchCordType.TRK2OCH;
            } else if (this.trk2trkRB.isSelected()) {
                this.patchType = IntPatchCreationInfo.eIntPatchCordType.TRK2TRK;
            } else if (this.ochF2ochFRB.isSelected()) {
                this.patchType = IntPatchCreationInfo.eIntPatchCordType.OCH2OCH;
            } else if (this.card2cardRB.isSelected()) {
                this.patchType = IntPatchCreationInfo.eIntPatchCordType.CARD2CARD;
            }
            return this.patchType;
        }

        public String toString() {
            switch (this.getPatchType()) {
                case OCH2OCH: {
                    return "OCH-Filter to OCH-Filter";
                }
                case TRK2OCH: {
                    return "OCH-Trunk to OCH-Filter";
                }
                case OTS2OTS: {
                    return "OTS/OMS to OTS/OMS";
                }
                case TRK2TRK: {
                    return "Trunk to Trunk (L2)";
                }
                case CARD2CARD: {
                    return "Optical Path";
                }
            }
            return "";
        }
    }
}

