/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IOSConsoleDisabledException;
import cerent.cms.model.IosAccessModel;
import cerent.cms.model.IosModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IOSConfigDialog;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.IOSTelnetFrame;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class IosPane
extends NodeProvPane
implements ActionListener {
    private static final SDebug db = new SDebug("IosPane");
    private IosAccessModel iosAccessModel = null;
    private JButton openButton;
    private JButton configButton;
    private JCheckBox consoleAccessCB;
    private JCheckBox radiusRelayCB;
    private IosModuleModel moduleModel;

    public IosPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        IModel iModel = this.getParentView().getUiModel();
        if (iModel instanceof IosModuleModel) {
            this.moduleModel = (IosModuleModel)iModel;
            this.iosAccessModel = this.moduleModel.getIosAccess();
        }
        if (this.iosAccessModel == null) {
            throw new IllegalArgumentException("IosAccessModel not supported");
        }
        this.iosAccessModel.addObserver((Observer)((Object)this));
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = IosPane.createVerticalPanel(null);
        this.add((Component)new UScrollPane((Component)jPanel));
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel2 = IosPane.createVerticalPanel("Open IOS Command Line Interface (CLI) Window");
        this.openButton = new JButton("Open IOS Connection...");
        jPanel2.add(this.openButton);
        this.openButton.addActionListener(this);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel2 = IosPane.createVerticalPanel("Manage IOS Config File");
        this.configButton = new JButton("IOS Startup Config...");
        jPanel2.add(this.configButton);
        this.configButton.addActionListener(this);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        this.consoleAccessCB = new JCheckBox("Enable Console Port Access");
        this.radiusRelayCB = new JCheckBox("Enable RADIUS Relay");
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            this.consoleAccessCB.addActionListener(this);
            this.radiusRelayCB.addActionListener(this);
        } else {
            this.consoleAccessCB.setEnabled(false);
            this.radiusRelayCB.setEnabled(false);
        }
        jPanel.add(this.consoleAccessCB);
        jPanel.add(this.radiusRelayCB);
        jPanel.add(Box.createVerticalGlue());
        this.registerWithModel();
        this.toggleButton();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.toggleButton();
    }

    private synchronized void toggleButton() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (IosPane.this.openButton != null) {
                    eEqState eEqState2 = IosPane.this.moduleModel.getState();
                    boolean bl = eEqState2.value() == 5 || eEqState2.value() == 4;
                    boolean bl2 = AbstractPane.isUserAuthorized(IosPane.this.moduleModel, SecurityLevel.PROVISIONING);
                    IosPane.this.openButton.setEnabled(bl && bl2);
                    IosPane.this.configButton.setEnabled(bl2);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.openButton) {
            try {
                IOSTelnetFrame iOSTelnetFrame = IOSTelnetFrame.instance((IModuleModel)this.moduleModel);
                iOSTelnetFrame.pack();
                iOSTelnetFrame.setVisible(true);
            }
            catch (IOSConsoleDisabledException iOSConsoleDisabledException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_IOS_CONSOLE_DISABLED, (Object)new Integer(this.moduleModel.getSlot()));
            }
        } else if (object == this.configButton) {
            IOSConfigDialog iOSConfigDialog = IOSConfigDialog.instance((Component)((Object)this), this.moduleModel);
            iOSConfigDialog.pack();
            iOSConfigDialog.setVisible(true);
        } else if (object == this.consoleAccessCB || object == this.radiusRelayCB) {
            this.setDirty();
        } else if (object == null) {
            db.severe("Null actionPerformed source");
            return;
        }
    }

    @Override
    public void applyChangesToModel() throws Exception {
        if (this.iosAccessModel.getConsolePortAccess() != this.consoleAccessCB.isSelected()) {
            this.iosAccessModel.setConsolePortAccess(this.consoleAccessCB.isSelected());
        }
        if (this.iosAccessModel.getRadiusRelayAccess() != this.radiusRelayCB.isSelected()) {
            this.iosAccessModel.setRadiusRelayAccess(this.radiusRelayCB.isSelected());
        }
    }

    @Override
    public void refreshFromModel() throws Exception {
        this.consoleAccessCB.setSelected(this.iosAccessModel.getConsolePortAccess());
        this.radiusRelayCB.setSelected(this.iosAccessModel.getRadiusRelayAccess());
        this.setDirty(false);
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.IosPane;
    }

    @Override
    public void destroy() {
        if (this.iosAccessModel != null) {
            this.iosAccessModel.deleteObserver((Observer)((Object)this));
        }
        super.destroy();
    }
}

