/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ml2.CEMRHoUsageTableModel;
import cerent.cms.ui.ml2.CEMRLoMapDialog;
import cerent.cms.ui.ml2.CEMRPosPortUsageTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CEMRPosPortUsagePane
extends AbstractPane
implements ActionListener,
MouseListener {
    private static SDebug db = new SDebug("ML2PosPortUsagePane");
    private JButton refreshButton;
    private ML2ModuleModel moduleModel;
    protected CEMRPosPortUsageTableModel lDataModel;
    protected CEMRHoUsageTableModel rDataModel;
    protected UTable lTable;
    protected UTable rTable;
    private JLabel refreshLabel;

    public CEMRPosPortUsagePane(String string, TabbedView tabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, null, tabbedView);
        this.moduleModel = mL2ModuleModel;
        this.setLayout(new BorderLayout());
        this.setDefaultPrivilegeLevel(SecurityLevel.RETRIEVE);
        this.add(this.createDualPanels(), "Center");
        this.add(this.createButtonPane(), "South");
    }

    protected JSplitPane createDualPanels() {
        JPanel jPanel = CEMRPosPortUsagePane.createVerticalPanel(this.getPortMapName());
        this.lDataModel = new CEMRPosPortUsageTableModel(this.getModuleModel());
        String string = this.moduleModel.getNodeModel().getTDMTerminology().getGeneralTerms(0);
        JPanel jPanel2 = CEMRPosPortUsagePane.createVerticalPanel(string + " Map");
        this.rDataModel = new CEMRHoUsageTableModel(this.getModuleModel());
        this.lTable = new UTable((TableModel)this.lDataModel);
        jPanel.add((Component)new UScrollPane((Component)this.lTable));
        this.rTable = new UTable((TableModel)this.rDataModel);
        jPanel2.add((Component)new UScrollPane((Component)this.rTable));
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        jSplitPane.setDividerSize(2);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setContinuousLayout(true);
        this.customizePane();
        return jSplitPane;
    }

    protected void customizePane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.lTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        this.rTable.setRowSelectionAllowed(true);
        this.rTable.addMouseListener((MouseListener)this);
        listSelectionModel = this.rTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.lTable.getColumn((Object)this.lDataModel.getColumnName(0));
        tableColumn.setPreferredWidth(80);
        tableColumn = this.lTable.getColumn((Object)this.lDataModel.getColumnName(1));
        tableColumn.setPreferredWidth(130);
        tableColumn = this.lTable.getColumn((Object)this.lDataModel.getColumnName(2));
        tableColumn.setPreferredWidth(60);
        tableColumn = this.lTable.getColumn((Object)this.lDataModel.getColumnName(3));
        tableColumn.setPreferredWidth(120);
        tableColumn = this.rTable.getColumn((Object)this.rDataModel.getColumnName(0));
        tableColumn.setPreferredWidth(45);
        tableColumn = this.rTable.getColumn((Object)this.rDataModel.getColumnName(2));
        tableColumn.setPreferredWidth(65);
        tableColumn = this.rTable.getColumn((Object)this.rDataModel.getColumnName(3));
        tableColumn.setPreferredWidth(80);
        tableColumn = this.rTable.getColumn((Object)this.rDataModel.getColumnName(4));
        tableColumn.setPreferredWidth(100);
    }

    private JPanel createButtonPane() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        this.refreshButton = new JButton("Retrieve");
        this.refreshButton.addActionListener(this);
        this.refreshLabel = new JLabel(" ");
        cSHelpButtonPane.addLeft(this.refreshButton);
        cSHelpButtonPane.addRight(this.refreshLabel);
        return cSHelpButtonPane;
    }

    protected String getPortMapName() {
        return "POS Port Map";
    }

    private ML2ModuleModel getModuleModel() {
        return (ML2ModuleModel)this.getUiModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        try {
            this.uiToolkit.setCursor(3);
            if (object == this.refreshButton) {
                this.refresh();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    @Override
    public void enteringPage() throws Exception {
        TablePropertyMgr.getColumnPrefs((JTable)this.lTable, "ML2PosPortUsagePane");
        TablePropertyMgr.getColumnPrefs((JTable)this.rTable, "ML2SonetPoolUsagePane");
        this.refresh();
    }

    private void saveTablePref() {
        TablePropertyMgr.setColumnPrefs((JTable)this.lTable, "ML2PosPortUsagePane");
        TablePropertyMgr.setColumnPrefs((JTable)this.rTable, "ML2SonetPoolUagePane");
    }

    @Override
    public void leavingPage() throws Exception {
        this.saveTablePref();
    }

    @Override
    public void refresh() {
        try {
            this.lDataModel.refreshFromModel();
            this.rDataModel.refreshFromModel();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        String string = "Retrieved: " + CEMRPosPortUsagePane.getFormattedDateTime(new Date());
        this.refreshLabel.setText(string);
    }

    @Override
    public void destroy() {
        this.saveTablePref();
        super.destroy();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        int n = this.rTable.getSelectedRow();
        if (this.rDataModel.isLo(n)) {
            new CEMRLoMapDialog(this, this.getModuleModel(), this.rDataModel.getStsNum(n)).show();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public CSHelpID getHelpID() {
        return CSHelpConst.CEMRPosPortUsagePane;
    }
}

