/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.ML2EnhModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.ml2.MLPortGraphic;
import cerent.cms.ui.ml2.MLPosPortGraphic;
import cerent.cms.ui.shelf.CardView;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.JLabel;

public class ML2EnhCardView
extends CardView {
    private ModuleModel model = null;
    private PortModel[] etherPortModels = null;
    private PortModel[] posPortModels = null;
    private PortModel[] rprPortModels = null;
    private MLPortGraphic[] etherPorts = null;
    private MLPosPortGraphic[] posPorts = null;
    private MLPosPortGraphic[] rprPorts = null;

    public ML2EnhCardView(ModuleModel moduleModel) {
        super(moduleModel);
        ML2EnhModuleModel mL2EnhModuleModel = (ML2EnhModuleModel)moduleModel;
        this.etherPortModels = mL2EnhModuleModel.getEtherPortModels();
        this.posPortModels = mL2EnhModuleModel.getPosPortModels();
        this.rprPortModels = mL2EnhModuleModel.getRprPortModels();
        mL2EnhModuleModel.addObserver(this);
        this.addPorts();
    }

    protected void addPorts() {
        this.etherPorts = new MLPortGraphic[this.etherPortModels.length];
        if (this.posPortModels != null) {
            this.posPorts = new MLPosPortGraphic[this.posPortModels.length];
        }
        if (this.rprPortModels != null) {
            this.rprPorts = new MLPosPortGraphic[this.rprPortModels.length];
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 3, 2, 2);
        this.add((Component)new JLabel("ETHER"), gridBagConstraints);
        this.addPortsToCard(this.etherPortModels, this.etherPorts, gridBagConstraints);
        this.setGbc(gridBagConstraints);
        this.add((Component)new JLabel("POS"), gridBagConstraints);
        if (this.posPortModels != null) {
            this.addPosPortsToCard(this.posPortModels, this.posPorts, gridBagConstraints, false);
        }
        this.setGbc(gridBagConstraints);
        this.add((Component)new JLabel("RPR"), gridBagConstraints);
        if (this.rprPortModels != null) {
            this.addPosPortsToCard(this.rprPortModels, this.rprPorts, gridBagConstraints, true);
        }
        this.repaint();
    }

    private void addPortsToCard(PortModel[] portModelArray, MLPortGraphic[] mLPortGraphicArray, GridBagConstraints gridBagConstraints) {
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel = portModelArray[i];
            mLPortGraphicArray[i] = new MLPortGraphic(this, portModel, portModel.getPort());
            gridBagConstraints.gridx = i + 1;
            this.add((Component)mLPortGraphicArray[i], gridBagConstraints);
        }
        this.updatePortAlarmColor(portModelArray, mLPortGraphicArray);
    }

    private void addPosPortsToCard(PortModel[] portModelArray, MLPosPortGraphic[] mLPosPortGraphicArray, GridBagConstraints gridBagConstraints, boolean bl) {
        gridBagConstraints.gridx = 0;
        boolean bl2 = false;
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel = portModelArray[i];
            mLPosPortGraphicArray[i] = new MLPosPortGraphic(this, portModel, portModel.getPort());
            if (!bl) {
                if (i > 0 && i % 10 == 0) {
                    gridBagConstraints.gridx = 1;
                    ++gridBagConstraints.gridy;
                } else {
                    ++gridBagConstraints.gridx;
                }
            } else if (bl2) {
                gridBagConstraints.gridx = 3;
            } else {
                bl2 = true;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 2;
            }
            this.add((Component)mLPosPortGraphicArray[i], gridBagConstraints);
        }
        this.updatePortAlarmColor(portModelArray, mLPosPortGraphicArray);
    }

    @Override
    protected List getPorts() {
        return new ArrayList();
    }

    private void setGbc(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
    }

    private void updatePortAlarmColor(PortModel[] portModelArray, MLPortGraphic[] mLPortGraphicArray) {
        if (portModelArray == null || mLPortGraphicArray == null) {
            return;
        }
        for (int i = 0; i < portModelArray.length; ++i) {
            PortModel portModel = portModelArray[i];
            IAlarmStatus iAlarmStatus = this.cardAlarmStore.getEntityAlarmStatus(portModel);
            if (iAlarmStatus == null) continue;
            mLPortGraphicArray[i].setAlarmState(iAlarmStatus.getHighestSeverity());
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof AlarmStatus) {
            AlarmStatus alarmStatus = (AlarmStatus)object;
            this.setAlarmColor(alarmStatus.getHighestSeverity());
            this.updatePortAlarmColor(this.etherPortModels, this.etherPorts);
            this.updatePortAlarmColor(this.posPortModels, this.posPorts);
            this.updatePortAlarmColor(this.rprPortModels, this.rprPorts);
        }
    }

    @Override
    public void dispose() {
        int n;
        if (this.etherPorts != null) {
            for (n = 0; n < this.etherPorts.length; ++n) {
                if (this.etherPorts[n] == null) continue;
                this.etherPorts[n].dispose();
            }
        }
        if (this.posPorts != null) {
            for (n = 0; n < this.posPorts.length; ++n) {
                if (this.posPorts[n] == null) continue;
                this.posPorts[n].dispose();
            }
        }
        if (this.rprPorts != null) {
            for (n = 0; n < this.rprPorts.length; ++n) {
                if (this.rprPorts[n] == null) continue;
                this.rprPorts[n].dispose();
            }
        }
        if (this.model != null && this.model.supportsRPR()) {
            this.model.deleteObserver(this);
        }
        super.dispose();
    }
}

