/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.ML2ModuleModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.RprHelper;
import cerent.cms.ui.SoakMaintenancePane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.ml2.CEMRPosPortUsagePane;
import cerent.cms.ui.ml2.ML2LineMaintPane;
import cerent.cms.ui.ml2.ML2PosPortUsagePane;
import cerent.cms.ui.ml2.ML2ProtectionPane;
import cerent.cms.ui.ml2.MLMRPosPortUsagePane;
import cerent.cms.ui.ml2.MLSoakMaintenancePane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;

public class ML2MaintenancePane
extends NodeProvPane {
    private ML2ModuleModel eqpmtModel;
    private static final SDebug db = new SDebug("ML2MaintenancePane");

    public ML2MaintenancePane(String string, CardTabbedView cardTabbedView, ML2ModuleModel mL2ModuleModel) {
        super(string, cardTabbedView);
        this.eqpmtModel = mL2ModuleModel;
        this.subTabs = new SubTabbedView(mL2ModuleModel, cardTabbedView);
        this.subTabs.addTab("Path Trace", (Component)CardTabbedView.getPathTracePane(mL2ModuleModel.getPosLineModels(), this.subTabs));
        if (mL2ModuleModel.getEqType() == 285) {
            this.subTabs.addTab("Protection", (Component)((Object)new ML2ProtectionPane("Protection", this.subTabs, mL2ModuleModel)));
        }
        if (mL2ModuleModel.isInMapperMode()) {
            this.subTabs.addTab("Loopback", (Component)this.getLoopbackTab());
        }
        TDMTerminology tDMTerminology = mL2ModuleModel.getNodeModel().getTDMTerminology();
        String string2 = tDMTerminology.getGeneralTerms(0) + "/" + tDMTerminology.getGeneralTerms(1) + " Allocation";
        if (mL2ModuleModel.getEqType() == 283 || mL2ModuleModel.getEqType() == 284) {
            this.subTabs.addTab(string2, (Component)this.getCEMRPosPortUsageTab());
        } else if (mL2ModuleModel.getEqType() == 285) {
            this.subTabs.addTab(string2, (Component)this.getMLMRPosPortUsageTab());
        } else if (mL2ModuleModel.getEqType() != 229) {
            this.subTabs.addTab(string2, (Component)this.getPosPortUsageTab());
        }
        if (mL2ModuleModel.isInMapperMode()) {
            this.subTabs.addTab("AINS Soak", (Component)this.getSoakTab());
        } else {
            this.subTabs.addTab("Ether Port Soak", (Component)this.getEtherSoakTab());
            this.subTabs.addTab(this.getCurrentTitle(), (Component)this.getPosSoakTab());
        }
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    private Pane getCEMRPosPortUsageTab() {
        return new CEMRPosPortUsagePane("CEMRPosPortUsagePane", this.getParentView(), this.eqpmtModel);
    }

    private Pane getMLMRPosPortUsageTab() {
        return new MLMRPosPortUsagePane("MLMRPosPortUsagePane", this.getParentView(), this.eqpmtModel);
    }

    private Pane getPosPortUsageTab() {
        return new ML2PosPortUsagePane("ML2PosPortUsagePane", this.getParentView(), this.eqpmtModel);
    }

    protected Pane getSoakTab() {
        return new SoakMaintenancePane("AINS Soak", this.getParentView(), this.eqpmtModel.getEtherLineModels(), true);
    }

    protected Pane getEtherSoakTab() {
        return new MLSoakMaintenancePane("Ether Port Soak", this.getParentView(), this.eqpmtModel.getEtherLineModels(), true);
    }

    protected Pane getPosSoakTab() {
        return new MLSoakMaintenancePane(this.getCurrentTitle(), this.getParentView(), this.eqpmtModel.getPosLineModels(), true);
    }

    private Pane getLoopbackTab() {
        return new ML2LineMaintPane("ML2LineMaintPane", this.getParentView(), this.eqpmtModel);
    }

    @Override
    public boolean hasSubTabs() {
        return true;
    }

    protected String getCurrentTitle() {
        return RprHelper.getSoakTabName(this.eqpmtModel);
    }
}

